/*
 * Decompiled with CFR 0.152.
 */
package pal.eval;

import java.util.Vector;
import pal.alignment.SitePattern;
import pal.eval.LikelihoodCalculator;
import pal.misc.Identifier;
import pal.misc.PalObjectEvent;
import pal.misc.PalObjectListener;
import pal.misc.Utils;
import pal.substmodel.RateMatrix;
import pal.tree.Node;
import pal.tree.Tree;

public class FastLikelihoodCalculator
implements PalObjectListener,
LikelihoodCalculator {
    RootNode root_;
    boolean modelChanged_ = false;
    int numberOfSites_;
    int numberOfStates_;
    RateMatrix model_;
    SitePattern sitePattern_;
    private static double THRESHOLD = 1.0E-12;

    public FastLikelihoodCalculator(SitePattern pattern) {
        this.sitePattern_ = pattern;
        this.numberOfSites_ = pattern.getNumberOfPatterns();
        this.numberOfStates_ = pattern.getDataType().getNumStates();
    }

    public FastLikelihoodCalculator(SitePattern pattern, Tree tree, RateMatrix model) {
        this(pattern);
        this.setTree(tree);
        this.setRateMatrix(model);
    }

    public void parametersChanged(PalObjectEvent pe) {
        this.modelChanged_ = true;
    }

    public void structureChanged(PalObjectEvent pe) {
        this.modelChanged_ = true;
    }

    public final void setRateMatrix(RateMatrix rateMatrix) {
        if (this.model_ == null || this.model_ != rateMatrix) {
            this.model_ = rateMatrix;
            this.model_.addPalObjectListener(this);
            this.root_.setModel(this.model_);
            this.modelChanged_ = true;
        }
    }

    public void release() {
        try {
            this.model_.removePalObjectListener(this);
            this.model_ = null;
        }
        catch (NullPointerException e) {}
    }

    public final void setTree(Tree t) {
        if (this.root_ == null) {
            this.root_ = new RootNode(t.getRoot());
        } else {
            NNode newNode = this.root_.switchNodes(t.getRoot());
            if (newNode != this.root_) {
                throw new RuntimeException("Assertion error : new tree generates new Root NNode (tree probably contains only one branch)");
            }
            this.root_.setModel(this.model_);
        }
        this.root_.setupSequences(this.sitePattern_);
    }

    public final void updateSitePattern(SitePattern pattern) {
        this.sitePattern_ = pattern;
        this.root_.setupSequences(pattern);
        if (pattern.numPatterns != this.numberOfSites_) {
            this.numberOfSites_ = pattern.numPatterns;
            this.root_.setModel(this.model_);
            this.modelChanged_ = true;
        }
    }

    public double calculateLogLikelihood() {
        double lkl = this.root_.computeLikelihood();
        return lkl;
    }

    final NNode create(Node peer) {
        if (peer.getChildCount() == 0) {
            return new LeafNode(peer);
        }
        return new InternalNode(peer);
    }

    class RootNode
    extends InternalNode {
        double[] equilibriumProbabilities_;
        int[] siteWeightings_;

        public RootNode(Node peer) {
            this(peer, null);
        }

        public RootNode(Node peer, double[] equilibriumProbabilities) {
            super(peer);
            this.equilibriumProbabilities_ = equilibriumProbabilities;
        }

        public double computeLikelihood() {
            double lh = this.calculateFinal(this.equilibriumProbabilities_, this.siteWeightings_);
            FastLikelihoodCalculator.this.modelChanged_ = false;
            return lh;
        }

        public void setModel(RateMatrix rm) {
            super.setModel(rm);
            this.equilibriumProbabilities_ = rm.getEquilibriumFrequencies();
        }

        public void setupSequences(SitePattern sp) {
            super.setupSequences(sp);
            this.siteWeightings_ = sp.weight;
        }
    }

    class InternalNode
    extends NNode {
        private NNode[] children_;
        private double[][][] childSiteStateProbs_;
        double[] endStateProbs_;

        public InternalNode(Node peer) {
            super(peer);
            this.children_ = new NNode[peer.getChildCount()];
            int i = 0;
            while (i < this.children_.length) {
                this.children_[i] = FastLikelihoodCalculator.this.create(peer.getChild(i));
                ++i;
            }
            this.childSiteStateProbs_ = new double[this.children_.length][][];
        }

        public void setModel(RateMatrix rm) {
            super.setModel(rm);
            if (this.endStateProbs_ == null || FastLikelihoodCalculator.this.numberOfStates_ != this.endStateProbs_.length) {
                this.endStateProbs_ = new double[FastLikelihoodCalculator.this.numberOfStates_];
            }
            int i = 0;
            while (i < this.children_.length) {
                this.children_[i].setModel(rm);
                ++i;
            }
        }

        public void setupSequences(SitePattern sp) {
            super.setupSequences(sp);
            int i = 0;
            while (i < this.children_.length) {
                this.children_[i].setupSequences(sp);
                ++i;
            }
        }

        public boolean isLeaf() {
            return false;
        }

        private final boolean populateChildSiteStateProbs() {
            boolean allNull = true;
            int i = 0;
            while (i < this.children_.length) {
                double[][] ss = this.children_[i].calculateSiteStateProbabilities();
                if (ss != null) {
                    this.childSiteStateProbs_[i] = ss;
                    allNull = false;
                } else if (this.childSiteStateProbs_[i] == null) {
                    throw new RuntimeException("Assertion error : Not as should be!");
                }
                ++i;
            }
            return allNull;
        }

        protected final int getNumberOfChildren() {
            return this.children_.length;
        }

        public NNode switchNodes(Node n) {
            int nc = n.getChildCount();
            if (nc == 0) {
                return FastLikelihoodCalculator.this.create(n);
            }
            if (nc != this.children_.length) {
                NNode[] newChildren = new NNode[nc];
                int i = 0;
                while (i < nc) {
                    newChildren[i] = i < this.children_.length ? this.children_[i].switchNodes(n.getChild(i)) : FastLikelihoodCalculator.this.create(n.getChild(i));
                    ++i;
                }
                this.children_ = newChildren;
            } else {
                int i = 0;
                while (i < nc) {
                    this.children_[i] = this.children_[i].switchNodes(n.getChild(i));
                    ++i;
                }
            }
            this.setPeer(n);
            return this;
        }

        public double[][] calculateSiteStateProbabilities() {
            if (this.populateChildSiteStateProbs() && !FastLikelihoodCalculator.this.modelChanged_ && !this.isBranchLengthChanged()) {
                return null;
            }
            double[][] probs = this.getTransitionProbabilities();
            double[][] siteStateProbs = this.getSiteStateProbabilities();
            int site = 0;
            while (site < siteStateProbs.length) {
                int endState = 0;
                while (endState < FastLikelihoodCalculator.this.numberOfStates_) {
                    double probOfEndState = this.childSiteStateProbs_[0][site][endState];
                    int i = 1;
                    while (i < this.childSiteStateProbs_.length) {
                        probOfEndState *= this.childSiteStateProbs_[i][site][endState];
                        ++i;
                    }
                    this.endStateProbs_[endState] = probOfEndState;
                    ++endState;
                }
                int startState = 0;
                while (startState < FastLikelihoodCalculator.this.numberOfStates_) {
                    double probOfStartState = 0.0;
                    int endState2 = 0;
                    while (endState2 < FastLikelihoodCalculator.this.numberOfStates_) {
                        probOfStartState += probs[startState][endState2] * this.endStateProbs_[endState2];
                        ++endState2;
                    }
                    siteStateProbs[site][startState] = probOfStartState;
                    ++startState;
                }
                ++site;
            }
            return siteStateProbs;
        }

        public double calculateFinal(double[] equilibriumProbs, int[] siteWeights) {
            this.populateChildSiteStateProbs();
            double logSum = 0.0;
            int site = 0;
            while (site < FastLikelihoodCalculator.this.numberOfSites_) {
                double total = 0.0;
                int state = 0;
                while (state < FastLikelihoodCalculator.this.numberOfStates_) {
                    double stateProb = this.childSiteStateProbs_[0][site][state];
                    int i = 1;
                    while (i < this.childSiteStateProbs_.length) {
                        stateProb *= this.childSiteStateProbs_[i][site][state];
                        ++i;
                    }
                    total += equilibriumProbs[state] * stateProb;
                    ++state;
                }
                logSum += Math.log(total) * (double)siteWeights[site];
                ++site;
            }
            return logSum;
        }

        public LeafNode[] getLeafNodes() {
            Vector<LeafNode> v = new Vector<LeafNode>();
            int i = 0;
            while (i < this.children_.length) {
                LeafNode[] clns = this.children_[i].getLeafNodes();
                int j = 0;
                while (j < clns.length) {
                    v.addElement(clns[j]);
                    ++j;
                }
                ++i;
            }
            Object[] lns = new LeafNode[v.size()];
            v.copyInto(lns);
            return lns;
        }
    }

    class LeafNode
    extends NNode {
        public LeafNode(Node peer) {
            super(peer);
        }

        public double computeLikelihood() {
            return 0.0;
        }

        public boolean isLeaf() {
            return true;
        }

        protected final void setPeer(Node newPeer) {
            if (!this.peer_.getIdentifier().getName().equals(newPeer.getIdentifier().getName())) {
                this.lastLength_ = Double.NEGATIVE_INFINITY;
            }
            this.peer_ = newPeer;
        }

        public NNode switchNodes(Node n) {
            if (n.getChildCount() == 0) {
                this.setPeer(n);
                return this;
            }
            return FastLikelihoodCalculator.this.create(n);
        }

        public LeafNode[] getLeafNodes() {
            return new LeafNode[]{this};
        }

        public double[][] calculateSiteStateProbabilities() {
            if (!FastLikelihoodCalculator.this.modelChanged_ && !this.isBranchLengthChanged()) {
                return null;
            }
            byte[] sequence = this.getSequence();
            double[][] probs = this.getTransitionProbabilitiesReverse();
            double[][] siteStateProbs = this.getSiteStateProbabilities();
            int site = 0;
            while (site < sequence.length) {
                int startState;
                byte endState = sequence[site];
                if (endState < 0) {
                    startState = 0;
                    while (startState < FastLikelihoodCalculator.this.numberOfStates_) {
                        siteStateProbs[site][startState] = 1.0;
                        ++startState;
                    }
                } else {
                    startState = 0;
                    while (startState < FastLikelihoodCalculator.this.numberOfStates_) {
                        siteStateProbs[site][startState] = probs[startState][endState];
                        ++startState;
                    }
                }
                ++site;
            }
            return siteStateProbs;
        }
    }

    abstract class NNode {
        private double[][] transitionProbs_;
        double lastLength_ = Double.NEGATIVE_INFINITY;
        Node peer_;
        private byte[] sequence_;
        private double[][] siteStateProbabilities_;

        public NNode(Node peer) {
            this.peer_ = peer;
        }

        public void setModel(RateMatrix rm) {
            if (this.transitionProbs_ == null || FastLikelihoodCalculator.this.numberOfStates_ != this.transitionProbs_.length) {
                this.transitionProbs_ = new double[FastLikelihoodCalculator.this.numberOfStates_][FastLikelihoodCalculator.this.numberOfStates_];
                this.siteStateProbabilities_ = new double[FastLikelihoodCalculator.this.numberOfSites_][FastLikelihoodCalculator.this.numberOfStates_];
            }
        }

        protected void setPeer(Node newPeer) {
            this.peer_ = newPeer;
        }

        public final boolean isBranchLengthChanged() {
            return Math.abs(this.peer_.getBranchLength() - this.lastLength_) > THRESHOLD;
        }

        protected final double[][] getSiteStateProbabilities() {
            return this.siteStateProbabilities_;
        }

        public final void setSequence(byte[] sequence) {
            this.sequence_ = Utils.getCopy(sequence);
            int i = 0;
            while (i < this.sequence_.length) {
                if (sequence[i] >= FastLikelihoodCalculator.this.numberOfStates_) {
                    this.sequence_[i] = -1;
                }
                ++i;
            }
        }

        public final boolean hasSequence() {
            return this.sequence_ != null;
        }

        public final byte[] getSequence() {
            return this.sequence_;
        }

        protected double[][] getTransitionProbabilities() {
            if (FastLikelihoodCalculator.this.modelChanged_ || this.isBranchLengthChanged()) {
                double distance = this.peer_.getBranchLength();
                FastLikelihoodCalculator.this.model_.setDistance(distance);
                FastLikelihoodCalculator.this.model_.getTransitionProbabilities(this.transitionProbs_);
                this.lastLength_ = distance;
            }
            return this.transitionProbs_;
        }

        protected double[][] getTransitionProbabilitiesReverse() {
            if (FastLikelihoodCalculator.this.modelChanged_ || this.isBranchLengthChanged()) {
                double distance = this.peer_.getBranchLength();
                FastLikelihoodCalculator.this.model_.setDistance(distance);
                FastLikelihoodCalculator.this.model_.getTransitionProbabilities(this.transitionProbs_);
                this.lastLength_ = distance;
            }
            return this.transitionProbs_;
        }

        private String toString(byte[] bs) {
            char[] cs = new char[bs.length];
            int i = 0;
            while (i < cs.length) {
                cs[i] = (char)(65 + bs[i]);
                ++i;
            }
            return new String(cs);
        }

        public void setupSequences(SitePattern sp) {
            int number;
            Identifier id = this.peer_.getIdentifier();
            if (id != null && (number = sp.whichIdNumber(id.getName())) >= 0) {
                if (this.sequence_ == null) {
                    this.sequence_ = new byte[sp.pattern[number].length];
                }
                byte[] pattern = sp.pattern[number];
                int i = 0;
                while (i < this.sequence_.length) {
                    this.sequence_[i] = pattern[i] >= FastLikelihoodCalculator.this.numberOfStates_ ? -1 : pattern[i];
                    ++i;
                }
            }
        }

        public abstract double[][] calculateSiteStateProbabilities();

        public abstract LeafNode[] getLeafNodes();

        public abstract NNode switchNodes(Node var1);
    }
}

