/*
 * Decompiled with CFR 0.152.
 */
package pal.eval;

import java.io.Serializable;

public final class ConditionalProbabilityStore
implements Serializable {
    private final int numberOfCategories_;
    private final int numberOfStates_;
    private final double[][][] store_;
    private int patternCapacity_;
    private final double[][] logScales_;
    private final boolean hasLogScales_;
    private double totalLogScale_ = 0.0;
    private boolean isBasedOnCachedData_ = false;
    private boolean fix_ = false;

    public ConditionalProbabilityStore(int numberOfCategories, int numberOfStates) {
        this(numberOfCategories, numberOfStates, false);
    }

    public ConditionalProbabilityStore(int numberOfCategories, int numberOfStates, boolean hasLogScales) {
        this.numberOfCategories_ = numberOfCategories;
        this.numberOfStates_ = numberOfStates;
        this.store_ = new double[numberOfCategories][][];
        this.patternCapacity_ = 0;
        this.hasLogScales_ = hasLogScales;
        this.logScales_ = (double[][])(hasLogScales ? (double[][])new double[numberOfCategories][] : null);
    }

    public final void clearTotalLogScale() {
        this.totalLogScale_ = 0.0;
    }

    public final void addTotalLogScale(double amount) {
        this.totalLogScale_ += amount;
    }

    public final double getTotalLogScale() {
        return this.totalLogScale_;
    }

    public final void setTotalLogScale(double value) {
        this.totalLogScale_ = value;
    }

    public final boolean isHasLogScales() {
        return this.hasLogScales_;
    }

    private final void ensureSize(int numberOfPatterns, boolean createStateArray) {
        if (numberOfPatterns > this.patternCapacity_) {
            int i;
            if (this.fix_) {
                throw new IllegalArgumentException("Cannot resize to accomodate " + numberOfPatterns + " patterns (store has been fixed)");
            }
            if (createStateArray) {
                i = 0;
                while (i < this.numberOfCategories_) {
                    this.store_[i] = new double[numberOfPatterns][this.numberOfStates_];
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.numberOfCategories_) {
                    this.store_[i] = new double[numberOfPatterns][];
                    ++i;
                }
            }
            if (this.logScales_ != null) {
                i = 0;
                while (i < this.numberOfCategories_) {
                    this.logScales_[i] = new double[numberOfPatterns];
                    ++i;
                }
            }
            this.patternCapacity_ = numberOfPatterns;
        }
    }

    public double[][] getCurrentLogScales() {
        return this.logScales_;
    }

    public double[][] getLogScales(int numberOfPatterns) {
        if (this.logScales_ == null) {
            throw new RuntimeException("Illegal operation:getLogScales() called on non log scaled store!");
        }
        this.ensureSize(numberOfPatterns, true);
        return this.logScales_;
    }

    public double[][] getCheckLogScales(int numberOfPatterns) {
        if (this.logScales_ == null) {
            throw new RuntimeException("Illegal operation:getLogScales() called on non log scaled store!");
        }
        if (this.patternCapacity_ < numberOfPatterns) {
            throw new RuntimeException("Assertion error : log scales have not been updated correctly");
        }
        return this.logScales_;
    }

    public int getPatternCapacity() {
        return this.patternCapacity_;
    }

    public double[][][] getCurrentConditionalProbabilities() {
        return this.store_;
    }

    public double[][] getCurrentConditionalProbabilities(int category) {
        return this.store_[category];
    }

    public double[][][] getConditionalProbabilityAccess(int numberOfPatterns, boolean resultsBasedOnCachedData) {
        this.ensureSize(numberOfPatterns, true);
        this.isBasedOnCachedData_ = resultsBasedOnCachedData;
        return this.store_;
    }

    public double[][][] getConditionalProbabilityAccessNoChangeData(int numberOfPatterns, boolean resultsBasedOnCachedData) {
        if (numberOfPatterns > this.patternCapacity_) {
            throw new IllegalArgumentException("Cannot provided for requested number of patterns. Asked for " + numberOfPatterns + " can only give " + this.patternCapacity_);
        }
        this.isBasedOnCachedData_ = resultsBasedOnCachedData;
        return this.store_;
    }

    public double[][][] getIncompleteConditionalProbabilityAccess(int numberOfPatterns, boolean resultsBasedOnCachedData, boolean fix) {
        this.ensureSize(numberOfPatterns, false);
        this.isBasedOnCachedData_ = resultsBasedOnCachedData;
        this.fix_ = fix;
        return this.store_;
    }

    public double calculateLogLikelihood(double[] categoryProbabilities, double[] equilibriumFrequencies, int[] patternWeights, int numberOfPatterns) {
        double logLikelihood = 0.0;
        int pattern = 0;
        while (pattern < numberOfPatterns) {
            double total = 0.0;
            int cat = 0;
            while (cat < this.numberOfCategories_) {
                double prob = 0.0;
                double[] stateArray = this.store_[cat][pattern];
                int state = 0;
                while (state < this.numberOfStates_) {
                    prob += equilibriumFrequencies[state] * stateArray[state];
                    ++state;
                }
                total += categoryProbabilities[cat] * prob;
                ++cat;
            }
            logLikelihood = patternWeights != null ? (logLikelihood += Math.log(total) * (double)patternWeights[pattern]) : (logLikelihood += Math.log(total));
            ++pattern;
        }
        return logLikelihood;
    }

    public double calculateLogLikelihood(double[] categoryProbabilities, double[] equilibriumFrequencies, int numberOfPatterns) {
        return this.calculateLogLikelihood(categoryProbabilities, equilibriumFrequencies, null, numberOfPatterns);
    }

    public double[] calculatePatternLogLikelihoods(double[] categoryProbabilities, double[] equilibriumFrequencies, int numberOfPatterns) {
        double[] result = new double[numberOfPatterns];
        int pattern = 0;
        while (pattern < numberOfPatterns) {
            double total = 0.0;
            int cat = 0;
            while (cat < this.numberOfCategories_) {
                double prob = 0.0;
                double[] stateArray = this.store_[cat][pattern];
                int state = 0;
                while (state < this.numberOfStates_) {
                    prob += equilibriumFrequencies[state] * stateArray[state];
                    ++state;
                }
                total += categoryProbabilities[cat] * prob;
                ++cat;
            }
            result[pattern] = Math.log(total);
            ++pattern;
        }
        return result;
    }

    public double[][] calculateCategoryPatternConditionalProbabilities(double[] categoryProbabilities, double[] equilibriumFrequencies, int numberOfPatterns) {
        double logLikelihood = 0.0;
        boolean patternIndex = false;
        double[][] result = new double[this.numberOfCategories_][numberOfPatterns];
        int pattern = 0;
        while (pattern < numberOfPatterns) {
            double total = 0.0;
            int cat = 0;
            while (cat < this.numberOfCategories_) {
                int state;
                double prob = 0.0;
                double[] stateArray = this.store_[cat][pattern];
                if (equilibriumFrequencies == null) {
                    state = 0;
                    while (state < this.numberOfStates_) {
                        prob += stateArray[state];
                        ++state;
                    }
                } else {
                    state = 0;
                    while (state < this.numberOfStates_) {
                        prob += equilibriumFrequencies[state] * stateArray[state];
                        ++state;
                    }
                }
                result[cat][pattern] = categoryProbabilities == null ? prob : categoryProbabilities[cat] * prob;
                ++cat;
            }
            ++pattern;
        }
        return result;
    }

    public boolean isBasedOnCachedData() {
        return this.isBasedOnCachedData_;
    }

    public void setBasedOnCachedData(boolean v) {
        this.isBasedOnCachedData_ = v;
    }
}

