/*
 * Decompiled with CFR 0.152.
 */
package pal.eval;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import pal.datatype.DataType;
import pal.eval.ConditionalProbabilityStore;
import pal.eval.LHCalculator;
import pal.eval.PatternInfo;
import pal.substmodel.SubstitutionModel;

public class CachedLHCalculator
implements LHCalculator {
    public static final LHCalculator.Factory getFactory(LHCalculator.Factory base) {
        return new SimpleFactory(base);
    }

    private static final class SimpleGenerator
    implements LHCalculator.Generator {
        private LHCalculator.Generator baseGenerator_;
        private static final long serialVersionUID = 88723342355122L;

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeByte(1);
            out.writeObject(this.baseGenerator_);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            byte version = in.readByte();
            switch (version) {
                default: 
            }
            this.baseGenerator_ = (LHCalculator.Generator)in.readObject();
        }

        public SimpleGenerator(LHCalculator.Generator baseGenerator) {
            this.baseGenerator_ = baseGenerator;
        }

        public LHCalculator.Leaf createNewLeaf(int[] patternStateMatchup, int numberOfPatterns) {
            return this.baseGenerator_.createNewLeaf(patternStateMatchup, numberOfPatterns);
        }

        public LHCalculator.Leaf createNewLeaf(int[] patternStateMatchup, int numberOfPatterns, LHCalculator.Generator parentGenerator) {
            return this.baseGenerator_.createNewLeaf(patternStateMatchup, numberOfPatterns, parentGenerator);
        }

        public LHCalculator.External createNewExternal() {
            return this.baseGenerator_.createNewExternal();
        }

        public LHCalculator.External createNewExternal(LHCalculator.Generator parentGenerator) throws IllegalArgumentException {
            return this.baseGenerator_.createNewExternal(parentGenerator);
        }

        public LHCalculator.Internal createNewInternal() {
            LHCalculator.Internal baseInternal = this.baseGenerator_.createNewInternal();
            if (this.baseGenerator_.isAllowCaching()) {
                return new InternalImpl(baseInternal);
            }
            return baseInternal;
        }

        public LHCalculator.Internal createNewInternal(LHCalculator.Generator parentGenerator) throws IllegalArgumentException {
            LHCalculator.Internal baseInternal = this.baseGenerator_.createNewInternal(parentGenerator);
            if (this.baseGenerator_.isAllowCaching()) {
                return new InternalImpl(baseInternal);
            }
            return baseInternal;
        }

        public ConditionalProbabilityStore createAppropriateConditionalProbabilityStore(boolean isForLeaf) {
            return this.baseGenerator_.createAppropriateConditionalProbabilityStore(isForLeaf);
        }

        public boolean isAllowCaching() {
            return true;
        }
    }

    private static final class SimpleFactory
    implements LHCalculator.Factory {
        private final LHCalculator.Factory base_;

        public SimpleFactory(LHCalculator.Factory base) {
            this.base_ = base;
        }

        public LHCalculator.Generator createSeries(int numberOfCategories, DataType dt) {
            return new SimpleGenerator(this.base_.createSeries(numberOfCategories, dt));
        }
    }

    private static final class InternalImpl
    implements LHCalculator.Internal {
        private final LHCalculator.Internal base_;
        private ConditionalProbabilityStore lastExtendProbabilities_;
        private ConditionalProbabilityStore lastFlatProbabilities_;
        private double lastDistance_ = -1.0;

        private InternalImpl(LHCalculator.Internal base) {
            this.base_ = base;
        }

        public final ConditionalProbabilityStore calculateExtended(double distance, SubstitutionModel model, PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilityProbabilties, ConditionalProbabilityStore rightConditionalProbabilityProbabilties, boolean modelChangedSinceLastCall, boolean childrenChanged) {
            boolean leftRightCached;
            boolean bl = leftRightCached = leftConditionalProbabilityProbabilties.isBasedOnCachedData() && rightConditionalProbabilityProbabilties.isBasedOnCachedData();
            if (leftRightCached && !modelChangedSinceLastCall && !childrenChanged && distance == this.lastDistance_) {
                return this.lastExtendProbabilities_;
            }
            this.lastDistance_ = distance;
            this.lastExtendProbabilities_ = this.base_.calculateExtended(distance, model, centerPattern, leftConditionalProbabilityProbabilties, rightConditionalProbabilityProbabilties, modelChangedSinceLastCall, childrenChanged);
            return this.lastExtendProbabilities_;
        }

        public final ConditionalProbabilityStore calculateFlat(PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilityProbabilties, ConditionalProbabilityStore rightConditionalProbabilityProbabilties, boolean childrenChanged) {
            boolean leftRightCached;
            boolean bl = leftRightCached = leftConditionalProbabilityProbabilties.isBasedOnCachedData() && rightConditionalProbabilityProbabilties.isBasedOnCachedData();
            if (leftRightCached && !childrenChanged) {
                return this.lastFlatProbabilities_;
            }
            this.lastFlatProbabilities_ = this.calculateFlat(centerPattern, leftConditionalProbabilityProbabilties, rightConditionalProbabilityProbabilties, childrenChanged);
            return this.lastFlatProbabilities_;
        }
    }
}

