/*
 * Decompiled with CFR 0.152.
 */
package pal.distance;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import pal.alignment.SitePattern;
import pal.datatype.DataType;
import pal.distance.SequencePairLikelihood;
import pal.math.UnivariateMinimum;
import pal.substmodel.SubstitutionModel;

public class PairwiseDistance
implements Serializable {
    public double distance;
    public double distanceSE;
    private int numSites;
    private int numPatterns;
    private int numStates;
    private int[] weight;
    private double jcratio;
    private boolean modelBased;
    private SitePattern sitePattern;
    private SubstitutionModel model;
    private UnivariateMinimum um;
    private SequencePairLikelihood of;
    private DataType patternDataType_;
    private static final long serialVersionUID = 4721062357793106145L;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(1);
        out.writeDouble(this.distance);
        out.writeDouble(this.distanceSE);
        out.writeInt(this.numSites);
        out.writeInt(this.numPatterns);
        out.writeInt(this.numStates);
        out.writeObject(this.weight);
        out.writeDouble(this.jcratio);
        out.writeBoolean(this.modelBased);
        out.writeObject(this.model);
        out.writeObject(this.sitePattern);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            default: 
        }
        this.distance = in.readDouble();
        this.distanceSE = in.readDouble();
        this.numSites = in.readInt();
        this.numPatterns = in.readInt();
        this.numStates = in.readInt();
        this.weight = (int[])in.readObject();
        this.jcratio = in.readDouble();
        this.modelBased = in.readBoolean();
        this.model = (SubstitutionModel)in.readObject();
        this.sitePattern = (SitePattern)in.readObject();
        this.um = new UnivariateMinimum();
        if (this.model != null) {
            this.of = new SequencePairLikelihood(this.sitePattern, this.model);
        }
        this.patternDataType_ = this.sitePattern.getDataType();
    }

    public PairwiseDistance(SitePattern sp) {
        this.updateSitePattern(sp);
    }

    public PairwiseDistance(SitePattern sp, SubstitutionModel m) {
        this(sp);
        this.modelBased = true;
        this.of = new SequencePairLikelihood(sp, m);
        this.um = new UnivariateMinimum();
    }

    public void updateModel(SubstitutionModel m) {
        if (this.of == null) {
            this.modelBased = true;
            this.of = new SequencePairLikelihood(this.sitePattern, m);
            this.um = new UnivariateMinimum();
            this.model = m;
        } else {
            this.of.updateModel(m);
        }
    }

    public void updateSitePattern(SitePattern sp) {
        this.sitePattern = sp;
        this.numSites = sp.getSiteCount();
        this.numPatterns = sp.numPatterns;
        this.numStates = sp.getDataType().getNumStates();
        this.weight = sp.weight;
        this.jcratio = ((double)this.numStates - 1.0) / (double)this.numStates;
        if (this.modelBased) {
            this.of.updateSitePattern(sp);
        }
        this.patternDataType_ = sp.getDataType();
    }

    public double getDistance(int s1, int s2) {
        return this.getDistance(this.sitePattern.pattern[s1], this.sitePattern.pattern[s2]);
    }

    public double getDistance(byte[] s1, byte[] s2) {
        double f2x;
        double dist = this.getObservedDistance(s1, s2);
        if (this.modelBased && dist != 0.0) {
            double start = 1.0 - dist / this.jcratio;
            start = start > 0.0 ? -this.jcratio * Math.log(start) : dist;
            this.of.setSequences(s1, s2);
            dist = start > 1.0 || start < 1.0E-9 ? this.um.findMinimum(this.of, 6) : this.um.findMinimum(start, this.of, 6);
        }
        this.distanceSE = this.modelBased ? (1.0 < (f2x = this.um.f2minx) ? Math.sqrt(1.0 / f2x) : 1.0) : 0.0;
        this.distance = dist;
        return dist;
    }

    private boolean isDifferent(int s1, int s2) {
        if (this.patternDataType_.isUnknownState(s1) || this.patternDataType_.isUnknownState(s2)) {
            return false;
        }
        return s1 != s2;
    }

    private double getObservedDistance(byte[] seqPat1, byte[] seqPat2) {
        int diff = 0;
        int i = 0;
        while (i < this.numPatterns) {
            if (this.isDifferent(seqPat1[i], seqPat2[i])) {
                diff += this.weight[i];
            }
            ++i;
        }
        return (double)diff / (double)this.numSites;
    }
}

