/*
 * Decompiled with CFR 0.152.
 */
package pal.distance;

import java.io.Serializable;
import pal.distance.DistanceMatrix;
import pal.misc.IdGroup;
import pal.misc.Identifier;
import pal.misc.SimpleIdGroup;

public class DistanceMatrixUtils
implements Serializable {
    public static double squaredDistance(DistanceMatrix mat1, DistanceMatrix mat2, boolean weighted) {
        int i;
        boolean aliasNeeded = false;
        if (mat1.getSize() != mat2.getSize()) {
            aliasNeeded = true;
        }
        int[] alias = null;
        if (aliasNeeded) {
            if (mat1.getSize() > mat2.getSize()) {
                DistanceMatrix temp = mat2;
                mat2 = mat1;
                mat1 = temp;
            }
            alias = new int[mat1.getSize()];
            i = 0;
            while (i < alias.length) {
                alias[i] = mat2.whichIdNumber(mat1.getIdentifier(i).getName());
                ++i;
            }
        } else {
            alias = new int[mat1.getSize()];
            i = 0;
            while (i < alias.length) {
                alias[i] = i;
                ++i;
            }
        }
        double sum = 0.0;
        double[][] mat1Distance = mat1.getDistances();
        double[][] mat2Distance = mat2.getDistances();
        int i2 = 0;
        while (i2 < mat1.getSize() - 1) {
            int ai = alias[i2];
            int j = i2 + 1;
            while (j < mat1.getSize()) {
                double diff = mat1Distance[i2][j] - mat2Distance[ai][alias[j]];
                double weight = weighted ? 1.0 / (mat1Distance[i2][j] * mat2Distance[ai][alias[j]]) : 1.0;
                sum += weight * diff * diff;
                ++j;
            }
            ++i2;
        }
        return 2.0 * sum;
    }

    public static DistanceMatrix minus(DistanceMatrix parent, int taxaToRemove) {
        int size = parent.getIdCount() - 1;
        double[][] distances = new double[size][size];
        Identifier[] ids = new Identifier[size];
        int counti = 0;
        int countj = 0;
        int i = 0;
        while (i < size) {
            if (counti == taxaToRemove) {
                ++counti;
            }
            ids[i] = parent.getIdentifier(counti);
            countj = 0;
            double[][] parentDistance = parent.getDistances();
            int j = 0;
            while (j < size) {
                if (countj == taxaToRemove) {
                    ++countj;
                }
                distances[i][j] = parentDistance[counti][countj];
                ++countj;
                ++j;
            }
            ++counti;
            ++i;
        }
        DistanceMatrix smaller = new DistanceMatrix(distances, (IdGroup)new SimpleIdGroup(ids));
        return smaller;
    }
}

