/*
 * Decompiled with CFR 0.152.
 */
package pal.distance;

import pal.alignment.Alignment;
import pal.alignment.BootstrappedAlignment;
import pal.alignment.SitePattern;
import pal.distance.AlignmentDistanceMatrix;
import pal.distance.DistanceMatrix;
import pal.substmodel.SubstitutionModel;
import pal.tree.SimulatedAlignment;
import pal.tree.Tree;
import pal.util.AlgorithmCallback;

public interface DistanceMatrixSource {
    public DistanceMatrix generateMatrix(AlgorithmCallback var1);

    public boolean isSupportsReplicates();

    public DistanceMatrix generateReplicate(AlgorithmCallback var1);

    public static final class Utils {
        public static DistanceMatrixSource build(DistanceMatrix base) {
            return new Simple(base);
        }

        public static DistanceMatrixSource buildEvolutionary(Alignment a, SubstitutionModel sm) {
            return new Evolutionary(a, sm);
        }

        public static DistanceMatrixSource buildParametric(DistanceMatrix baseMatrix, Tree baseTree, SubstitutionModel sm, int numberOfSites) {
            return new Parametric(baseMatrix, baseTree, sm, numberOfSites);
        }

        private static final class Evolutionary
        implements DistanceMatrixSource {
            Alignment alignment_;
            SubstitutionModel model_;

            public Evolutionary(Alignment alignment, SubstitutionModel model) {
                this.alignment_ = alignment;
                this.model_ = model;
            }

            public DistanceMatrix generateMatrix(AlgorithmCallback callback) {
                return new AlignmentDistanceMatrix(SitePattern.getSitePattern(this.alignment_), this.model_, callback);
            }

            public boolean isSupportsReplicates() {
                return true;
            }

            public DistanceMatrix generateReplicate(AlgorithmCallback callback) {
                return new AlignmentDistanceMatrix(SitePattern.getSitePattern(new BootstrappedAlignment(this.alignment_)), this.model_, callback);
            }
        }

        private static final class Parametric
        implements DistanceMatrixSource {
            DistanceMatrix base_;
            Tree baseTree_;
            SubstitutionModel evolutionaryModel_;
            int numberOfSites_;

            public Parametric(DistanceMatrix base, Tree baseTree, SubstitutionModel evolutionaryModel, int numberOfSites) {
                this.base_ = base;
                this.numberOfSites_ = numberOfSites;
                this.baseTree_ = baseTree;
                this.evolutionaryModel_ = evolutionaryModel;
            }

            public DistanceMatrix generateMatrix(AlgorithmCallback callback) {
                return this.base_;
            }

            public boolean isSupportsReplicates() {
                return true;
            }

            public DistanceMatrix generateReplicate(AlgorithmCallback callback) {
                SimulatedAlignment sa = new SimulatedAlignment(this.numberOfSites_, this.baseTree_, this.evolutionaryModel_);
                return new AlignmentDistanceMatrix(SitePattern.getSitePattern(sa), this.evolutionaryModel_, callback);
            }
        }

        private static final class Simple
        implements DistanceMatrixSource {
            DistanceMatrix base_;

            public Simple(DistanceMatrix base) {
                this.base_ = base;
            }

            public DistanceMatrix generateMatrix(AlgorithmCallback callback) {
                return this.base_;
            }

            public boolean isSupportsReplicates() {
                return false;
            }

            public DistanceMatrix generateReplicate(AlgorithmCallback callback) {
                throw new RuntimeException("Do not support replication");
            }
        }
    }
}

