/*
 * Decompiled with CFR 0.152.
 */
package pal.datatype;

import pal.datatype.DataType;
import pal.datatype.SimpleDataType;

public class NumericDataType
extends SimpleDataType {
    public static final DataType DEFAULT_INSTANCE = new NumericDataType();
    int numberOfNumericStates = 10000;

    public NumericDataType() {
    }

    public NumericDataType(int numberOfStates) {
        this.numberOfNumericStates = numberOfStates;
    }

    public int getNumStates() {
        return this.numberOfNumericStates;
    }

    protected boolean isUnknownStateImpl(int state) {
        return state >= this.numberOfNumericStates || state < 0;
    }

    protected int getStateImpl(char c) {
        if (c == '?') {
            return this.numberOfNumericStates;
        }
        int state = this.getNumericIndexFromNumericChar(c);
        if (state < 0 || state > this.numberOfNumericStates) {
            state = this.numberOfNumericStates;
        }
        return state;
    }

    protected char getCharImpl(int state) {
        if (state >= this.numberOfNumericStates || state < 0) {
            return '?';
        }
        return this.getNumericCharFromNumericIndex(state);
    }

    public final char getNumericCharFromNumericIndex(int index) {
        return (char)(index + 64);
    }

    public final int getNumericIndexFromNumericChar(char c) {
        return c - 64;
    }

    public String getDescription() {
        return "Numeric";
    }

    public int getTypeID() {
        return 6;
    }
}

