/*
 * Decompiled with CFR 0.152.
 */
package pal.datatype;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import pal.datatype.MolecularDataType;
import pal.datatype.SimpleDataType;
import pal.misc.Utils;

public class Nucleotides
extends SimpleDataType
implements MolecularDataType {
    public static final int A_STATE = 0;
    public static final int C_STATE = 1;
    public static final int G_STATE = 2;
    public static final int UT_STATE = 3;
    private static final long serialVersionUID = -497943046234232204L;
    private static final char[] DNA_CONVERSION_TABLE = new char[]{'A', 'C', 'G', 'T', '?'};
    private static final char[] RNA_CONVERSION_TABLE = new char[]{'A', 'C', 'G', 'T', '?'};
    boolean isRNA_;
    char[] conversionTable_;
    public static final Nucleotides DEFAULT_INSTANCE = new Nucleotides();

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(1);
        out.writeBoolean(this.isRNA_);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            default: 
        }
        this.isRNA_ = in.readBoolean();
        this.conversionTable_ = this.isRNA_ ? RNA_CONVERSION_TABLE : DNA_CONVERSION_TABLE;
    }

    public Nucleotides() {
        this(false);
    }

    public Nucleotides(boolean isRNA) {
        this.isRNA_ = isRNA;
        this.conversionTable_ = this.isRNA_ ? RNA_CONVERSION_TABLE : DNA_CONVERSION_TABLE;
    }

    public int getNumStates() {
        return 4;
    }

    protected final boolean isUnknownStateImpl(int state) {
        return state >= 4 || state < 0;
    }

    protected int getStateImpl(char c) {
        switch (c) {
            case 'A': {
                return 0;
            }
            case 'C': {
                return 1;
            }
            case 'G': {
                return 2;
            }
            case 'T': {
                return 3;
            }
            case 'U': {
                return 3;
            }
            case '?': {
                return 4;
            }
            case 'a': {
                return 0;
            }
            case 'c': {
                return 1;
            }
            case 'g': {
                return 2;
            }
            case 't': {
                return 3;
            }
            case 'u': {
                return 3;
            }
        }
        return 4;
    }

    protected char getCharImpl(int state) {
        if (state < this.conversionTable_.length && state >= 0) {
            return this.conversionTable_[state];
        }
        return '?';
    }

    public String getDescription() {
        return "nucleotide";
    }

    public int getTypeID() {
        return 0;
    }

    public final boolean isTransitionByState(int firstState, int secondState) {
        switch (firstState) {
            case 0: {
                return secondState == 2;
            }
            case 1: {
                return secondState == 3;
            }
            case 2: {
                return secondState == 0;
            }
            case 3: {
                return secondState == 1;
            }
        }
        return false;
    }

    public final boolean isTransitionByChar(char firstChar, char secondChar) {
        return this.isTransitionByState(this.getState(firstChar), this.getState(secondChar));
    }

    public int[] getNucleotideStates(int[] residueStates) {
        return Utils.getCopy(residueStates);
    }

    public int getRelavantLength(int numberOfStates) {
        return numberOfStates;
    }

    public int[] getMolecularStatesFromSimpleNucleotides(int[] nucleotideStates, int startingIndex) {
        return Utils.getCopy(nucleotideStates, startingIndex);
    }

    public int[] getMolecularStatesFromIUPACNucleotides(int[] nucleotideStates, int startingIndex) {
        return Utils.getCopy(nucleotideStates, startingIndex);
    }

    public boolean isCreatesIUPACNuecleotides() {
        return false;
    }

    public final int getNucleotideLength() {
        return 1;
    }
}

