/*
 * Decompiled with CFR 0.152.
 */
package pal.datatype;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import pal.datatype.AmbiguousDataType;
import pal.datatype.DataType;
import pal.datatype.MolecularDataType;
import pal.datatype.Nucleotides;
import pal.datatype.SimpleDataType;
import pal.misc.Utils;

public class IUPACNucleotides
extends SimpleDataType
implements MolecularDataType,
AmbiguousDataType {
    private static final char[] RNA_CONVERSION_TABLE = new char[]{'A', 'C', 'G', 'U', 'K', 'M', 'R', 'S', 'W', 'Y', 'B', 'D', 'H', 'V', 'N', '?'};
    private static final char[] DNA_CONVERSION_TABLE = new char[]{'A', 'C', 'G', 'T', 'K', 'M', 'R', 'S', 'W', 'Y', 'B', 'D', 'H', 'V', 'N', '?'};
    public static final IUPACNucleotides DEFAULT_INSTANCE = new IUPACNucleotides();
    public static final IUPACNucleotides DNA_INSTANCE = new IUPACNucleotides(false);
    public static final IUPACNucleotides RNA_INSTANCE = new IUPACNucleotides(true);
    boolean isRNA_;
    char[] conversionTable_;
    private static final long serialVersionUID = 8863411606027017687L;
    private static final boolean[] A_STATE_COMPS = new boolean[]{true, false, false, false, false, true, true, false, true, false, false, true, true, true, true, true};
    private static final boolean[] C_STATE_COMPS = new boolean[]{false, true, false, false, false, true, false, true, false, true, true, false, true, true, true, true};
    private static final boolean[] G_STATE_COMPS = new boolean[]{false, false, true, false, true, false, true, true, false, false, true, true, false, true, true, true};
    private static final boolean[] T_STATE_COMPS = new boolean[]{false, false, false, true, true, false, false, false, true, true, true, true, true, false, true, true};
    private static final boolean[][] ALL_STATE_COMPS = new boolean[][]{A_STATE_COMPS, C_STATE_COMPS, G_STATE_COMPS, T_STATE_COMPS};
    private static final int[] IUPAC_CONV = new int[]{-1, 0, 1, 5, 2, 6, 7, 13, 3, 8, 9, 12, 4, 11, 10, 14};
    private static final int[] SIMPLE_STATE_CONV = new int[]{0, 1, 2, 3, 2, 0, 0, 1, 0, 1, 1, 0, 0, 0, 0};
    private static final boolean[][] BOOLEAN_NUCLEOTIDE_STATE_AMBIGUITY;
    private static final double[][] DOUBLE_NUCLEOTIDE_STATE_AMBIGUITY;
    private static final int[][] SPECIFIC_STATE_LOOKUP;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(1);
        out.writeBoolean(this.isRNA_);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            default: 
        }
        this.isRNA_ = in.readBoolean();
        this.conversionTable_ = this.isRNA_ ? RNA_CONVERSION_TABLE : DNA_CONVERSION_TABLE;
    }

    public IUPACNucleotides() {
        this(false);
    }

    public IUPACNucleotides(boolean isRNA) {
        this.isRNA_ = isRNA;
        this.conversionTable_ = this.isRNA_ ? RNA_CONVERSION_TABLE : DNA_CONVERSION_TABLE;
    }

    public int getNumStates() {
        return 15;
    }

    protected boolean isUnknownStateImpl(int state) {
        return state >= this.getNumStates() || state < 0;
    }

    protected final int getStateImpl(char c) {
        switch (c) {
            case 'A': {
                return 0;
            }
            case 'C': {
                return 1;
            }
            case 'G': {
                return 2;
            }
            case 'T': {
                return 3;
            }
            case 'U': {
                return 3;
            }
            case 'K': {
                return 4;
            }
            case 'M': {
                return 5;
            }
            case 'R': {
                return 6;
            }
            case 'S': {
                return 7;
            }
            case 'W': {
                return 8;
            }
            case 'Y': {
                return 9;
            }
            case 'B': {
                return 10;
            }
            case 'D': {
                return 11;
            }
            case 'H': {
                return 12;
            }
            case 'V': {
                return 13;
            }
            case 'N': {
                return 14;
            }
            case 'a': {
                return 0;
            }
            case 'c': {
                return 1;
            }
            case 'g': {
                return 2;
            }
            case 't': {
                return 3;
            }
            case 'u': {
                return 3;
            }
            case 'k': {
                return 4;
            }
            case 'm': {
                return 5;
            }
            case 'r': {
                return 6;
            }
            case 's': {
                return 7;
            }
            case 'w': {
                return 8;
            }
            case 'y': {
                return 9;
            }
            case 'b': {
                return 10;
            }
            case 'd': {
                return 11;
            }
            case 'h': {
                return 12;
            }
            case 'v': {
                return 13;
            }
            case 'n': {
                return 14;
            }
        }
        return -1;
    }

    protected char getCharImpl(int state) {
        if (state < this.conversionTable_.length && state >= 0) {
            return this.conversionTable_[state];
        }
        return '?';
    }

    public String getDescription() {
        return "IUPACNucleotide";
    }

    public int getTypeID() {
        return 3;
    }

    public static final boolean isNucleotideState(int iupacState, int nucleotideState) {
        return ALL_STATE_COMPS[nucleotideState][iupacState];
    }

    public int getRecommendedUnknownState() {
        return -1;
    }

    public static final int getIUPACState(int inclusion) {
        return IUPAC_CONV[inclusion];
    }

    public static final int getIUPACState(boolean maybeA, boolean maybeC, boolean maybeG, boolean maybeT) {
        int index = 0;
        if (maybeA) {
            ++index;
        }
        if (maybeC) {
            index += 2;
        }
        if (maybeG) {
            index += 4;
        }
        if (maybeT) {
            index += 8;
        }
        return IUPAC_CONV[index];
    }

    public static final int getSimpleState(int state) {
        if (state < 0 || state >= SIMPLE_STATE_CONV.length) {
            return -1;
        }
        return SIMPLE_STATE_CONV[state];
    }

    public static final int[] getSimpleStates(int[] states) {
        int[] newStates = new int[states.length];
        int i = 0;
        while (i < states.length) {
            int state = states[i];
            newStates[i] = state < 0 || state >= SIMPLE_STATE_CONV.length ? -1 : SIMPLE_STATE_CONV[state];
            ++i;
        }
        return newStates;
    }

    public static final int[] getSimpleStates(int[] states, int startingIndex) {
        int[] newStates = new int[states.length - startingIndex];
        int i = 0;
        while (i < newStates.length) {
            int state = states[i + startingIndex];
            newStates[i] = state < 0 || state >= SIMPLE_STATE_CONV.length ? -1 : SIMPLE_STATE_CONV[state];
            ++i;
        }
        return newStates;
    }

    public String toString() {
        return this.getDescription();
    }

    public int[] getNucleotideStates(int[] residueStates) {
        return Utils.getCopy(residueStates);
    }

    public int[] getMolecularStatesFromSimpleNucleotides(int[] nucleotideStates, int startingIndex) {
        return IUPACNucleotides.getSimpleStates(nucleotideStates, startingIndex);
    }

    public final int[] getMolecularStatesFromIUPACNucleotides(int[] nucleotideStates, int startingIndex) {
        return Utils.getCopy(nucleotideStates, startingIndex);
    }

    public boolean isCreatesIUPACNuecleotides() {
        return true;
    }

    public final int getNucleotideLength() {
        return 1;
    }

    public int[] getSpecificStates(int state) {
        return SPECIFIC_STATE_LOOKUP[state];
    }

    public boolean isAmbiguous() {
        return true;
    }

    public AmbiguousDataType getAmbiguousVersion() {
        return this;
    }

    public DataType getSpecificDataType() {
        return Nucleotides.DEFAULT_INSTANCE;
    }

    public void getAmbiguity(int ambiguousState, boolean[] specificInclusion) {
        System.arraycopy(BOOLEAN_NUCLEOTIDE_STATE_AMBIGUITY[ambiguousState], 0, specificInclusion, 0, 4);
    }

    public void getAmbiguity(int ambiguousState, double[] specificInclusion) {
        System.arraycopy(DOUBLE_NUCLEOTIDE_STATE_AMBIGUITY[ambiguousState], 0, specificInclusion, 0, 4);
    }

    static {
        Nucleotides n = Nucleotides.DEFAULT_INSTANCE;
        BOOLEAN_NUCLEOTIDE_STATE_AMBIGUITY = new boolean[15][n.getNumStates()];
        DOUBLE_NUCLEOTIDE_STATE_AMBIGUITY = new double[15][n.getNumStates()];
        int[][] s = SPECIFIC_STATE_LOOKUP = (int[][])new int[15][];
        double[][] d = DOUBLE_NUCLEOTIDE_STATE_AMBIGUITY;
        boolean[][] b = BOOLEAN_NUCLEOTIDE_STATE_AMBIGUITY;
        int i = 0;
        while (i < d.length) {
            int j = 0;
            while (j < d[i].length) {
                d[i][j] = 0.0;
                b[i][j] = false;
                ++j;
            }
            ++i;
        }
        boolean A = false;
        boolean C = true;
        int G = 2;
        int T = 3;
        d[0][0] = 1.0;
        b[0][0] = true;
        s[0] = new int[]{0};
        d[1][1] = 1.0;
        b[1][1] = true;
        s[1] = new int[]{1};
        d[2][2] = 1.0;
        b[2][2] = true;
        s[2] = new int[]{2};
        d[3][3] = 1.0;
        b[3][3] = true;
        s[3] = new int[]{3};
        d[4][3] = 1.0;
        d[4][2] = 1.0;
        b[4][3] = true;
        b[4][2] = true;
        s[4] = new int[]{2, 3};
        d[5][1] = 1.0;
        d[5][0] = 1.0;
        b[5][1] = true;
        b[5][0] = true;
        s[5] = new int[]{0, 1};
        d[6][2] = 1.0;
        d[6][0] = 1.0;
        b[6][2] = true;
        b[6][0] = true;
        s[6] = new int[]{0, 2};
        d[7][2] = 1.0;
        d[7][1] = 1.0;
        b[7][2] = true;
        b[7][1] = true;
        s[7] = new int[]{1, 2};
        d[8][3] = 1.0;
        d[8][0] = 1.0;
        b[8][3] = true;
        b[8][0] = true;
        s[8] = new int[]{0, 3};
        d[9][3] = 1.0;
        d[9][1] = 1.0;
        b[9][3] = true;
        b[9][1] = true;
        s[9] = new int[]{1, 3};
        d[10][3] = 1.0;
        d[10][2] = 1.0;
        d[10][1] = 1.0;
        b[10][3] = true;
        b[10][2] = true;
        b[10][1] = true;
        s[10] = new int[]{1, 2, 3};
        d[11][3] = 1.0;
        d[11][2] = 1.0;
        d[11][0] = 1.0;
        b[11][3] = true;
        b[11][2] = true;
        b[11][0] = true;
        s[11] = new int[]{0, 2, 3};
        d[12][3] = 1.0;
        d[12][1] = 1.0;
        d[12][0] = 1.0;
        b[12][3] = true;
        b[12][1] = true;
        b[12][0] = true;
        s[12] = new int[]{0, 1, 3};
        d[13][2] = 1.0;
        d[13][1] = 1.0;
        d[13][0] = 1.0;
        b[13][2] = true;
        b[13][1] = true;
        b[13][0] = true;
        s[13] = new int[]{0, 1, 2};
        d[14][3] = 1.0;
        d[14][2] = 1.0;
        d[14][1] = 1.0;
        d[14][0] = 1.0;
        b[14][3] = true;
        b[14][2] = true;
        b[14][1] = true;
        b[14][0] = true;
        s[14] = new int[]{0, 1, 2, 3};
    }
}

