/*
 * Decompiled with CFR 0.152.
 */
package pal.datatype;

import pal.datatype.CodonTable;
import pal.datatype.CodonTableFactory;
import pal.datatype.IUPACNucleotides;
import pal.datatype.MolecularDataType;
import pal.datatype.SimpleDataType;

public class GapBalanced
extends SimpleDataType
implements MolecularDataType {
    CodonTable translationTable_;
    public static final GapBalanced DEFAULT_INSTANCE = new GapBalanced(CodonTableFactory.createUniversalTranslator());
    static final char[] CONVERSION_TABLE = new char[]{'A', 'R', 'N', 'D', 'C', 'Q', 'E', 'G', 'H', 'I', 'L', 'K', 'M', 'F', 'P', 'S', 'T', 'W', 'Y', 'V', '[', '*', ']', '?'};
    static final int LEFT_BRACKET_STATE = 20;
    static final int RIGHT_BRACKET_STATE = 22;

    public GapBalanced(CodonTable translationTable) {
        this.translationTable_ = translationTable;
    }

    public int getNumStates() {
        return 23;
    }

    public int getStateImpl(char c) {
        switch (c) {
            case 'A': {
                return 0;
            }
            case 'C': {
                return 4;
            }
            case 'D': {
                return 3;
            }
            case 'E': {
                return 6;
            }
            case 'F': {
                return 13;
            }
            case 'G': {
                return 7;
            }
            case 'H': {
                return 8;
            }
            case 'I': {
                return 9;
            }
            case 'K': {
                return 11;
            }
            case 'L': {
                return 10;
            }
            case 'M': {
                return 12;
            }
            case 'N': {
                return 2;
            }
            case 'P': {
                return 14;
            }
            case 'Q': {
                return 5;
            }
            case 'R': {
                return 1;
            }
            case 'S': {
                return 15;
            }
            case 'T': {
                return 16;
            }
            case 'V': {
                return 19;
            }
            case 'W': {
                return 17;
            }
            case 'Y': {
                return 18;
            }
            case '[': {
                return 20;
            }
            case ']': {
                return 22;
            }
            case '*': {
                return 21;
            }
            case 'a': {
                return 0;
            }
            case 'c': {
                return 4;
            }
            case 'd': {
                return 3;
            }
            case 'e': {
                return 6;
            }
            case 'f': {
                return 13;
            }
            case 'g': {
                return 7;
            }
            case 'h': {
                return 8;
            }
            case 'i': {
                return 9;
            }
            case 'k': {
                return 11;
            }
            case 'l': {
                return 10;
            }
            case 'm': {
                return 12;
            }
            case 'n': {
                return 2;
            }
            case 'p': {
                return 14;
            }
            case 'q': {
                return 5;
            }
            case 'r': {
                return 1;
            }
            case 's': {
                return 15;
            }
            case 't': {
                return 16;
            }
            case 'v': {
                return 19;
            }
            case 'w': {
                return 17;
            }
        }
        return -1;
    }

    protected char getCharImpl(int state) {
        if (state < CONVERSION_TABLE.length && state >= 0) {
            return CONVERSION_TABLE[state];
        }
        return '?';
    }

    protected final boolean isUnknownStateImpl(int state) {
        return state >= 22 || state < 0;
    }

    public String getDescription() {
        return "gap balanced";
    }

    public int getTypeID() {
        return 5;
    }

    public int[] getNucleotideStates(int[] residueStates) {
        throw new RuntimeException("NOT IMPLEMENTED YET!");
    }

    public final int[] getMolecularStatesFromIUPACNucleotides(int[] nucleotideStates, int startingIndex) {
        return this.getMolecularStatesFromSimpleNucleotides(IUPACNucleotides.getSimpleStates(nucleotideStates), startingIndex);
    }

    public final int[] getMolecularStatesFromSimpleNucleotides(int[] nucleotideStates, int startingIndex) {
        int[] residueStates = new int[nucleotideStates.length - startingIndex];
        int codonIndex = 0;
        int codonCount = 0;
        int placementIndex = -1;
        int i = 0;
        while (i < residueStates.length) {
            int n = nucleotideStates[i + startingIndex];
            if (n < 0 || n > 3) {
                residueStates[i] = -1;
            } else {
                codonIndex = codonIndex * 4 + n;
                switch (codonCount) {
                    case 0: {
                        residueStates[i] = 20;
                        codonCount = 1;
                        break;
                    }
                    case 1: {
                        placementIndex = i;
                        codonCount = 2;
                        break;
                    }
                    case 2: {
                        residueStates[i] = 22;
                        residueStates[placementIndex] = this.translationTable_.getAminoAcidStateFromCodonIndex(codonIndex);
                        codonIndex = 0;
                        codonCount = 0;
                    }
                }
            }
            ++i;
        }
        if (codonIndex != 2) {
            residueStates[placementIndex] = -1;
        }
        return residueStates;
    }

    public boolean isCreatesIUPACNuecleotides() {
        return true;
    }

    public final int getNucleotideLength() {
        return 1;
    }
}

