/*
 * Decompiled with CFR 0.152.
 */
package pal.datatype;

import pal.datatype.IUPACNucleotides;
import pal.datatype.MolecularDataType;
import pal.datatype.Nucleotides;
import pal.datatype.SimpleDataType;

public class Codons
extends SimpleDataType
implements MolecularDataType {
    public static final Codons DEFAULT_INSTANCE = new Codons();
    private static final Nucleotides NUCLEOTIDES = Nucleotides.DEFAULT_INSTANCE;
    private static final int CODON_LENGTH = 3;
    private static final int NUMBER_OF_NUCLEOTIDE_STATES = NUCLEOTIDES.getNumStates();
    private static final String[] TLA_NAMES_BY_STATE = new String[]{"AAA", "AAC", "AAG", "AAT", "ACA", "ACC", "ACG", "ACT", "AGA", "AGC", "AGG", "AGT", "ATA", "ATC", "ATG", "ATT", "CAA", "CAC", "CAG", "CAT", "CCA", "CCC", "CCG", "CCT", "CGA", "CGC", "CGG", "CGT", "CTA", "CTC", "CTG", "CTT", "GAA", "GAC", "GAG", "GAT", "GCA", "GCC", "GCG", "GCT", "GGA", "GGC", "GGG", "GGT", "GTA", "GTC", "GTG", "GTT", "TAA", "TAC", "TAG", "TAT", "TCA", "TCC", "TCG", "TCT", "TGA", "TGC", "TGG", "TGT", "TTA", "TTC", "TTG", "TTT"};
    private static final char[] STATE_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '@', '%'};
    private static final int[] CHAR_STATES = new int[256];

    public int getNumStates() {
        return 64;
    }

    public int getStateImpl(char c) {
        char ic = c;
        if (ic >= '\u0100') {
            return 64;
        }
        return CHAR_STATES[ic];
    }

    protected char getCharImpl(int state) {
        if (state >= 64 || state < 0) {
            return '?';
        }
        return STATE_CHARS[state];
    }

    public String getDescription() {
        return "codon";
    }

    protected final boolean isUnknownStateImpl(int state) {
        return state >= 64 || state < 0;
    }

    public int getTypeID() {
        return 4;
    }

    public int[] getNucleotideStates(int[] residueStates) {
        int[] result = new int[residueStates.length * 3];
        int base = 0;
        int j = 0;
        while (j < residueStates.length) {
            int index = residueStates[j];
            if (index < 0 || index >= 64) {
                result[base] = -1;
                result[base + 1] = -1;
                result[base + 2] = -1;
            } else {
                int i = 2;
                while (i >= 0) {
                    result[base + i] = index % 4;
                    index /= 4;
                    --i;
                }
            }
            base += 3;
            ++j;
        }
        return result;
    }

    public final int[] getMolecularStatesFromIUPACNucleotides(int[] nucleotideStates, int startingIndex) {
        return this.getMolecularStatesFromSimpleNucleotides(IUPACNucleotides.getSimpleStates(nucleotideStates), startingIndex);
    }

    public final int[] getMolecularStatesFromSimpleNucleotides(int[] nucleotideStates, int startingIndex) {
        int[] result = new int[(nucleotideStates.length - startingIndex) / 3];
        int base = startingIndex;
        int j = 0;
        while (j < result.length) {
            int index = 0;
            int i = 0;
            while (i < 3) {
                index *= 4;
                int state = nucleotideStates[base + i];
                if (state >= 4 || state < 0) {
                    index = -1;
                    break;
                }
                index += state;
                ++i;
            }
            result[j] = index;
            base += 3;
            ++j;
        }
        return result;
    }

    public boolean isCreatesIUPACNuecleotides() {
        return false;
    }

    public final int getNucleotideLength() {
        return 3;
    }

    public static final String getTLA(int state) {
        if (state < 0 || state >= TLA_NAMES_BY_STATE.length) {
            return "???";
        }
        return TLA_NAMES_BY_STATE[state];
    }

    public static final int getCodonIndexFromNucleotides(char[] codon) {
        if (codon.length < 3) {
            return -1;
        }
        int index = 0;
        int i = 0;
        while (i < 3) {
            index *= NUMBER_OF_NUCLEOTIDE_STATES;
            int state = NUCLEOTIDES.getState(codon[i]);
            if (state >= NUMBER_OF_NUCLEOTIDE_STATES) {
                return -1;
            }
            index += state;
            ++i;
        }
        return index;
    }

    public static final int getCodonIndexFromNucleotideStates(int[] codon) {
        return Codons.getCodonIndexFromNucleotideStates(codon, 0);
    }

    public static final int getCodonIndexFromNucleotideStates(int[] codon, int startingPosition) {
        if (codon.length - startingPosition < 3) {
            return -1;
        }
        int index = 0;
        int i = 0;
        while (i < 3) {
            index *= NUMBER_OF_NUCLEOTIDE_STATES;
            int state = codon[i + startingPosition];
            if (state >= NUMBER_OF_NUCLEOTIDE_STATES || state < 0) {
                return -1;
            }
            index += state;
            ++i;
        }
        return index;
    }

    public static final int getCodonIndexFromIUPACNucleotideStates(int[] codon) {
        return Codons.getCodonIndexFromIUPACNucleotideStates(codon, 0);
    }

    public static final int getCodonIndexFromIUPACNucleotideStates(int[] codon, int startingPosition) {
        if (codon.length - startingPosition < 3) {
            return -1;
        }
        int index = 0;
        int i = 0;
        while (i < 3) {
            index *= NUMBER_OF_NUCLEOTIDE_STATES;
            int state = codon[i + startingPosition];
            if ((state = IUPACNucleotides.getSimpleState(state)) >= NUMBER_OF_NUCLEOTIDE_STATES || state < 0) {
                return -1;
            }
            index += state;
            ++i;
        }
        return index;
    }

    public static final char[] getNucleotidesFromCodonIndex(int index) {
        char[] cs = new char[3];
        int i = 2;
        while (i >= 0) {
            cs[i] = NUCLEOTIDES.getChar(index % NUMBER_OF_NUCLEOTIDE_STATES);
            index /= NUMBER_OF_NUCLEOTIDE_STATES;
            --i;
        }
        return cs;
    }

    public static final int[] getNucleotideStatesFromCodonIndex(int codonIndex) {
        int[] cs = new int[3];
        int i = 2;
        while (i >= 0) {
            cs[i] = codonIndex % NUMBER_OF_NUCLEOTIDE_STATES;
            codonIndex /= NUMBER_OF_NUCLEOTIDE_STATES;
            --i;
        }
        return cs;
    }

    static {
        int i = 0;
        while (i < CHAR_STATES.length) {
            Codons.CHAR_STATES[i] = 64;
            ++i;
        }
        int i2 = 0;
        while (i2 < STATE_CHARS.length) {
            Codons.CHAR_STATES[Codons.STATE_CHARS[i2]] = i2;
            ++i2;
        }
    }
}

