/*
 * Decompiled with CFR 0.152.
 */
package pal.alignment;

import pal.alignment.AbstractAlignment;
import pal.alignment.Alignment;

public class ConcatenatedAlignment
extends AbstractAlignment {
    private Alignment[] alignmentList;
    private int numAlignments;
    private int[] alignmentIndex;
    private int[] siteIndex;

    public ConcatenatedAlignment(Alignment[] list) throws IllegalArgumentException {
        this.alignmentList = list;
        this.numAlignments = this.alignmentList.length;
        if (this.numAlignments == 0) {
            throw new IllegalArgumentException("NO ALIGNMENT");
        }
        this.numSeqs = this.alignmentList[0].getSequenceCount();
        this.idGroup = this.alignmentList[0];
        this.numSites = 0;
        int i = 0;
        while (i < this.numAlignments) {
            this.numSites += this.alignmentList[i].getSiteCount();
            if (this.alignmentList[i].getSequenceCount() != this.numSeqs) {
                throw new IllegalArgumentException("INCOMPATIBLE ALIGNMENTS");
            }
            ++i;
        }
        this.alignmentIndex = new int[this.numSites];
        this.siteIndex = new int[this.numSites];
        int s = 0;
        int i2 = 0;
        while (i2 < this.numAlignments) {
            int j = 0;
            while (j < this.alignmentList[i2].getSiteCount()) {
                this.alignmentIndex[s + j] = i2;
                this.siteIndex[s + j] = j;
                ++j;
            }
            s += this.alignmentList[i2].getSiteCount();
            ++i2;
        }
    }

    public char getData(int seq, int site) {
        return this.alignmentList[this.alignmentIndex[site]].getData(seq, this.siteIndex[site]);
    }
}

