/*
 * Decompiled with CFR 0.152.
 */
package pal.alignment;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import pal.alignment.Alignment;
import pal.alignment.AlignmentUtils;
import pal.datatype.DataType;
import pal.misc.IdGroup;
import pal.misc.Identifier;
import pal.misc.Report;

public abstract class AbstractAlignment
implements Alignment,
Serializable,
IdGroup,
Report {
    protected int numSeqs;
    protected int numSites;
    protected IdGroup idGroup;
    private DataType dataType;
    private static final long serialVersionUID = -5197800047652332969L;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(2);
        out.writeInt(this.numSeqs);
        out.writeInt(this.numSites);
        out.writeObject(this.idGroup);
        out.writeObject(this.dataType);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            case 1: {
                this.numSeqs = in.readInt();
                this.numSites = in.readInt();
                this.idGroup = (IdGroup)in.readObject();
                double[] frequencyDummy = (double[])in.readObject();
                this.dataType = (DataType)in.readObject();
                break;
            }
            default: {
                this.numSeqs = in.readInt();
                this.numSites = in.readInt();
                this.idGroup = (IdGroup)in.readObject();
                this.dataType = (DataType)in.readObject();
            }
        }
    }

    public abstract char getData(int var1, int var2);

    public boolean isGap(int seq, int site) {
        return this.dataType.isGapChar(this.getData(seq, site));
    }

    public void guessDataType() {
        this.dataType = AlignmentUtils.getSuitableInstance(this);
    }

    protected final char getChar(int state) {
        return this.dataType.getChar(state);
    }

    protected final int getState(char c) {
        return this.dataType.getState(c);
    }

    protected final boolean isUnknownState(int state) {
        return this.dataType.isUnknownState(state);
    }

    public final DataType getDataType() {
        return this.dataType;
    }

    public final void setDataType(DataType d) {
        this.dataType = d;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        AlignmentUtils.print(this, new PrintWriter(sw));
        return sw.toString();
    }

    public void report(PrintWriter out) {
        AlignmentUtils.report(this, out);
    }

    public int[][] getStates() {
        int[][] indices = new int[this.numSeqs][this.numSites];
        int i = 0;
        while (i < this.numSeqs) {
            boolean seqcounter = false;
            int j = 0;
            while (j < this.numSites) {
                indices[i][j] = this.dataType.getState(this.getData(i, j));
                if (indices[i][j] >= this.dataType.getNumStates()) {
                    indices[i][j] = -1;
                }
                ++j;
            }
            ++i;
        }
        return indices;
    }

    public final int getLength() {
        return this.numSites;
    }

    public final int getSequenceCount() {
        return this.numSeqs;
    }

    public final int getSiteCount() {
        return this.numSites;
    }

    public String getAlignedSequenceString(int seq) {
        char[] data = new char[this.numSites];
        int i = 0;
        while (i < this.numSites) {
            data[i] = this.getData(seq, i);
            ++i;
        }
        return new String(data);
    }

    public Identifier getIdentifier(int i) {
        return this.idGroup.getIdentifier(i);
    }

    public void setIdentifier(int i, Identifier ident) {
        this.idGroup.setIdentifier(i, ident);
    }

    public int getIdCount() {
        return this.idGroup.getIdCount();
    }

    public int whichIdNumber(String name) {
        return this.idGroup.whichIdNumber(name);
    }
}

