/*
 * Decompiled with CFR 0.152.
 */
package pal.algorithmics;

import java.util.Random;

public interface UndoableAction {
    public double doAction(double var1, double var3);

    public boolean isActionDeterministic();

    public boolean isActionSuccessful();

    public boolean undoAction();

    public static final class Utils {
        public static final UndoableAction getSimpleUniformSelection(UndoableAction[] subActions) {
            return new Multi(subActions);
        }

        public static final UndoableAction getDistributedSelection(UndoableAction[] subActions, double[] actionProportions) {
            if (subActions.length > actionProportions.length) {
                throw new IllegalArgumentException("Actions and proportion array different lengths");
            }
            return new DistributedMulti(subActions, actionProportions);
        }

        public static final UndoableAction getSimpleDesparation(UndoableAction primaryAction, UndoableAction desparateAction, double desparationLimit, int desparationInterval) {
            return new SimpleDesparation(primaryAction, desparateAction, desparationLimit, desparationInterval);
        }

        private static class DistributedMulti
        implements UndoableAction {
            private final UndoableAction[] subActions_;
            private final double[] probabilities_;
            private UndoableAction lastAction_ = null;
            private final Random random_;

            public DistributedMulti(UndoableAction[] subActions, double[] proportions) {
                this.subActions_ = subActions;
                this.probabilities_ = new double[subActions.length];
                double total = 0.0;
                int i = 0;
                while (i < subActions.length) {
                    total += proportions[i];
                    ++i;
                }
                int i2 = 0;
                while (i2 < subActions.length) {
                    this.probabilities_[i2] = proportions[i2] / total;
                    ++i2;
                }
                this.random_ = new Random();
            }

            public boolean isActionDeterministic() {
                return false;
            }

            public double doAction(double currentScore, double desparationValue) {
                double v = this.random_.nextDouble();
                double total = 0.0;
                int index = this.subActions_.length - 1;
                int i = 0;
                while (i < this.subActions_.length) {
                    if ((total += this.probabilities_[i]) > v) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                this.lastAction_ = this.subActions_[index];
                return this.lastAction_.doAction(currentScore, desparationValue);
            }

            public boolean isActionSuccessful() {
                if (this.lastAction_ != null) {
                    return this.lastAction_.isActionSuccessful();
                }
                throw new RuntimeException("Assertion error : isActionSuccessful() called when no action has been done recently");
            }

            public boolean undoAction() {
                if (this.lastAction_ != null) {
                    boolean successful = this.lastAction_.undoAction();
                    this.lastAction_ = null;
                    return successful;
                }
                throw new RuntimeException("Assertion error : undoAction() called when no action has been done recently (or has already been undone)");
            }
        }

        private static class Multi
        implements UndoableAction {
            private final UndoableAction[] subActions_;
            private UndoableAction lastAction_ = null;
            private final Random random_;

            public Multi(UndoableAction[] subActions) {
                this.subActions_ = subActions;
                this.random_ = new Random();
            }

            public double doAction(double currentScore, double desparationValue) {
                this.lastAction_ = this.subActions_[this.random_.nextInt(this.subActions_.length)];
                return this.lastAction_.doAction(currentScore, desparationValue);
            }

            public boolean isActionSuccessful() {
                if (this.lastAction_ != null) {
                    return this.lastAction_.isActionSuccessful();
                }
                throw new RuntimeException("Assertion error : isActionSuccessful() called when no action has been done recently");
            }

            public boolean isActionDeterministic() {
                return false;
            }

            public boolean undoAction() {
                if (this.lastAction_ != null) {
                    boolean successful = this.lastAction_.undoAction();
                    this.lastAction_ = null;
                    return successful;
                }
                throw new RuntimeException("Assertion error : undoAction() called when no action has been done recently (or has already been undone)");
            }
        }

        private static class SimpleDesparation
        implements UndoableAction {
            private final UndoableAction primaryAction_;
            private final UndoableAction desparateAction_;
            private final double desparationLimit_;
            private final int desparationInterval_;
            private int currentDesparateCount_ = 0;
            private UndoableAction lastAction_ = null;

            public SimpleDesparation(UndoableAction primaryAction, UndoableAction desparateAction, double desparationLimit, int desparationInterval) {
                this.primaryAction_ = primaryAction;
                this.desparateAction_ = desparateAction;
                this.desparationLimit_ = desparationLimit;
                this.desparationInterval_ = desparationInterval;
            }

            public boolean isActionDeterministic() {
                return false;
            }

            public double doAction(double currentScore, double desparationValue) {
                if (desparationValue >= this.desparationLimit_) {
                    ++this.currentDesparateCount_;
                    if (this.currentDesparateCount_ == this.desparationInterval_) {
                        this.currentDesparateCount_ = 0;
                        this.lastAction_ = this.desparateAction_;
                        desparationValue = (this.desparationLimit_ - desparationValue) / (1.0 - this.desparationLimit_);
                    } else {
                        this.lastAction_ = this.primaryAction_;
                    }
                } else {
                    this.lastAction_ = this.primaryAction_;
                    this.currentDesparateCount_ = 0;
                }
                return this.lastAction_.doAction(currentScore, desparationValue);
            }

            public boolean isActionSuccessful() {
                if (this.lastAction_ != null) {
                    return this.lastAction_.isActionSuccessful();
                }
                throw new RuntimeException("Assertion error : isActionSuccessful() called when no action has been done recently");
            }

            public boolean undoAction() {
                if (this.lastAction_ != null) {
                    boolean successful = this.lastAction_.undoAction();
                    this.lastAction_ = null;
                    return successful;
                }
                throw new RuntimeException("Assertion error : undoAction() called when no action has been done recently (or has already been undone)");
            }
        }
    }
}

