/*
 * Decompiled with CFR 0.152.
 */
package pal.algorithmics;

import pal.algorithmics.ObjectState;
import pal.algorithmics.ProbabilityIterator;
import pal.algorithmics.Ranker;
import pal.algorithmics.StoppingCriteria;
import pal.util.AlgorithmCallback;

public class SearchEngine {
    private final ProbabilityIterator.Factory probabilityIteratorFactory_;

    public SearchEngine(ProbabilityIterator.Factory probabilityIteratorFactory) {
        this.probabilityIteratorFactory_ = probabilityIteratorFactory;
    }

    public void run(AlgorithmCallback callback, double initialScore, ObjectState subject, StoppingCriteria.Factory stoppingCriteria, Ranker ranker) {
        Object bestState = subject.getStateReference();
        double score = initialScore;
        StoppingCriteria stopper = stoppingCriteria.newInstance();
        ProbabilityIterator acceptanceProbability = this.probabilityIteratorFactory_.newInstance();
        double bestScore = Double.POSITIVE_INFINITY;
        int evaluationCount = 0;
        boolean maximising = subject.isMaximiseScore();
        while (!stopper.isTimeToStop()) {
            double newScore = subject.doAction(score, stopper.getRelativeStoppingRatio());
            ++evaluationCount;
            double probability = acceptanceProbability.getNextProbability(score, newScore, maximising);
            if (ranker.isWorthAdding(newScore, maximising)) {
                ranker.add(subject.getStateReference(), newScore, maximising);
                System.out.println("Ranker best score:" + ranker.getBestScore());
                if (ranker.getBestScore() != bestScore) {
                    bestScore = ranker.getBestScore();
                    System.out.println("Best score:" + bestScore);
                }
            }
            if (!maximising && newScore <= score || maximising && newScore >= score || probability == 1.0 || Math.random() < probability) {
                score = newScore;
            } else if (!subject.undoAction()) {
                score = newScore;
            }
            stopper.newIteration(score, ranker.getBestScore(), !maximising, acceptanceProbability.isStablised(), callback);
            if (callback.isPleaseStop()) break;
        }
        callback.updateStatus("Finished:" + score);
        System.out.println("Evaluation Count:" + (evaluationCount + 1));
    }
}

