/*
 * Decompiled with CFR 0.152.
 */
package pal.algorithmics;

public class Ranker {
    private final RankedObject[] store_;
    private int numberInStore_;
    private double worstScore_;

    public Ranker(int maximumSize) {
        this.store_ = new RankedObject[maximumSize];
        this.numberInStore_ = 0;
    }

    public final Object getBestObject() {
        if (this.numberInStore_ > 0) {
            return this.store_[0].getObject();
        }
        return null;
    }

    public final double getBestScore() {
        return this.numberInStore_ == 0 ? 0.0 : this.store_[0].getScore();
    }

    public final boolean isWorthAdding(double score, boolean maximising) {
        return this.numberInStore_ != this.store_.length || this.numberInStore_ == 0 || (maximising ? score > this.worstScore_ : score < this.worstScore_);
    }

    public final Object[] getObjects() {
        Object[] result = new Object[this.numberInStore_];
        int i = 0;
        while (i < this.numberInStore_) {
            result[i] = this.store_[i].getObject();
            ++i;
        }
        return result;
    }

    public void add(Object object, double score, boolean maximising) {
        int insertionPoint = this.numberInStore_;
        if (maximising) {
            int i = 0;
            while (i < this.numberInStore_) {
                if (this.store_[i].getObject().equals(object)) {
                    this.store_[i].update(object, score);
                    return;
                }
                if (this.store_[i].hasLowerScore(score)) {
                    insertionPoint = i;
                    break;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.numberInStore_) {
                if (this.store_[i].getObject().equals(object)) {
                    this.store_[i].update(object, score);
                    return;
                }
                if (this.store_[i].hasHigherScore(score)) {
                    insertionPoint = i;
                    break;
                }
                ++i;
            }
        }
        this.insert(insertionPoint, new RankedObject(object, score));
    }

    private void insert(int insertionPoint, RankedObject ro) {
        if (insertionPoint < this.store_.length) {
            if (insertionPoint != this.numberInStore_ && insertionPoint < this.store_.length - 1) {
                if (this.store_.length == this.numberInStore_) {
                    System.arraycopy(this.store_, insertionPoint, this.store_, insertionPoint + 1, this.numberInStore_ - insertionPoint - 1);
                } else {
                    System.arraycopy(this.store_, insertionPoint, this.store_, insertionPoint + 1, this.numberInStore_ - insertionPoint);
                }
            }
            this.store_[insertionPoint] = ro;
            if (this.numberInStore_ != this.store_.length) {
                ++this.numberInStore_;
            }
            this.worstScore_ = this.store_[this.numberInStore_ - 1].getScore();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        sb.append(this.numberInStore_);
        sb.append(") ");
        int i = 0;
        while (i < this.numberInStore_) {
            sb.append(this.store_[i]);
            if (i != this.numberInStore_ - 1) {
                sb.append(", ");
            }
            ++i;
        }
        return sb.toString();
    }

    private static final class RankedObject {
        private Object object_;
        private double score_;

        public RankedObject(Object object, double score) {
            this.update(object, score);
        }

        public final boolean hasLowerScore(double otherScore) {
            return this.score_ < otherScore;
        }

        public final boolean hasHigherScore(double otherScore) {
            return this.score_ > otherScore;
        }

        public final void update(Object object, double score) {
            this.object_ = object;
            this.score_ = score;
        }

        public Object getObject() {
            return this.object_;
        }

        public double getScore() {
            return this.score_;
        }

        public String toString() {
            return "[" + this.object_ + ", " + this.score_ + "]";
        }
    }
}

