/*
 * Decompiled with CFR 0.152.
 */
package jas.util.xml.parserwrappers;

import jas.util.xml.JASDOMParser;
import jas.util.xml.parserwrappers.XMLErrorHandler;
import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JAXPDOMParser
extends JASDOMParser {
    public Document parse(Reader reader, String string) throws JASDOMParser.JASXMLException {
        return this.parse(reader, string, null);
    }

    public Document parse(Reader reader, String string, EntityResolver entityResolver) throws JASDOMParser.JASXMLException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            XMLErrorHandler xMLErrorHandler = new XMLErrorHandler(string);
            documentBuilder.setErrorHandler(xMLErrorHandler);
            if (entityResolver != null) {
                documentBuilder.setEntityResolver(entityResolver);
            }
            InputSource inputSource = new InputSource(reader);
            inputSource.setSystemId("file:/");
            Document document = documentBuilder.parse(inputSource);
            if (xMLErrorHandler.getLevel() > 1) {
                throw new SAXException("Error during XML file parsing");
            }
            return document;
        }
        catch (SAXException sAXException) {
            throw new JASDOMParser.JASXMLException("Syntax error parsing XML file", sAXException);
        }
        catch (IOException iOException) {
            throw new JASDOMParser.JASXMLException("IO error parsing XML file", iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new JASDOMParser.JASXMLException("Can not create XML parser", parserConfigurationException);
        }
    }
}

