/*
 * Decompiled with CFR 0.152.
 */
package jas.util.tree;

import jas.util.tree.SimpleNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class OrderedNode
extends SimpleNode {
    private List orderedList;
    private Comparator comp;
    public static final Comparator DEFAULT_ORDER = new Comparator(){

        public boolean equals() {
            return false;
        }

        public int compare(Object object, Object object2) {
            return 0;
        }
    };

    public OrderedNode() {
    }

    public OrderedNode(String string, String string2, int n, Object object) {
        super(string, string2, n, object);
    }

    public OrderedNode(SimpleNode simpleNode, String string, String string2, int n, Object object) {
        super(simpleNode, string, string2, n, object);
    }

    protected SimpleNode createNode(SimpleNode simpleNode, String string, String string2, int n, Object object) {
        return new OrderedNode(simpleNode, string, string2, n, object);
    }

    protected void addChild(SimpleNode simpleNode) {
        if (this.getEffectiveOrder() != null) {
            if (this.orderedList == null) {
                this.orderedList = this.createOrderedList(Collections.singleton(simpleNode));
            } else {
                int n = Collections.binarySearch(this.orderedList, simpleNode, this.getEffectiveOrder());
                System.out.println("ip=" + n);
                if (n < 0) {
                    n = -n - 1;
                }
                this.orderedList.add(n, simpleNode);
            }
        }
        super.addChild(simpleNode);
    }

    protected void removeChild(SimpleNode simpleNode) {
        super.removeChild(simpleNode);
        if (this.orderedList != null) {
            this.orderedList.remove(simpleNode);
        }
    }

    public SimpleNode getChild(int n) {
        if (this.orderedList != null) {
            return (SimpleNode)this.orderedList.get(n);
        }
        return super.getChild(n);
    }

    public int getIndexOfChild(Object object) {
        if (this.orderedList != null) {
            return Collections.binarySearch(this.orderedList, object, this.getEffectiveOrder());
        }
        return super.getIndexOfChild(object);
    }

    public int getNaturalIndex() {
        return this.getParent().children.indexOf(this);
    }

    protected List createOrderedList(Collection collection) {
        return new ArrayList(collection);
    }

    public void setOrder(Comparator comparator) {
        if (this.comp != comparator) {
            this.comp = comparator;
            this.notifyOrderChanged();
        }
    }

    public void clearOrder() {
        this.setOrder(null);
    }

    private void notifyOrderChanged() {
        this.orderChanged();
        this.treeChanged(8);
    }

    private void orderChanged() {
        Comparator comparator = this.getEffectiveOrder();
        if (comparator == null) {
            this.orderedList = null;
        } else {
            this.orderedList = this.createOrderedList(this.children == null ? Collections.EMPTY_LIST : this.children.elements());
            Collections.sort(this.orderedList, comparator);
        }
        if (this.children != null) {
            Iterator iterator = this.children.elements().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof OrderedNode)) continue;
                OrderedNode orderedNode = (OrderedNode)e;
                if (orderedNode.comp != null) continue;
                orderedNode.orderChanged();
            }
        }
    }

    public Comparator getOrder() {
        return this.comp;
    }

    private Comparator getEffectiveOrder() {
        if (this.comp != null) {
            return this.comp;
        }
        if (this.comp == DEFAULT_ORDER) {
            return null;
        }
        SimpleNode simpleNode = this.getParent();
        if (simpleNode instanceof OrderedNode) {
            return ((OrderedNode)simpleNode).getEffectiveOrder();
        }
        return null;
    }
}

