/*
 * Decompiled with CFR 0.152.
 */
package jas.util.pluginmanager;

import jas.util.JASDialog;
import jas.util.pluginmanager.PluginDownloadThread;
import jas.util.pluginmanager.PluginProperties;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class PluginDownloadProgress
extends JASDialog {
    private static JFrame frame;
    private PluginDownloadThread thread;
    private JLabel message;
    private JProgressBar progress;
    private int count;
    private int done = 1;
    private boolean canceled;
    private Object[] plugins;
    private String path;
    private Container c;

    public PluginDownloadProgress(Object[] objectArray, String string) {
        super((Frame)frame, "Download Progress", true, 4);
        this.plugins = objectArray;
        this.path = string;
        this.c = this.getContentPane();
        this.c.removeAll();
        this.c.setLayout(new BorderLayout());
        this.count = objectArray.length;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.message = new JLabel("Hello World Hello World Hello World");
        this.message.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.add("North", this.message);
        this.progress = new JProgressBar();
        this.progress.setStringPainted(true);
        jPanel.add("Center", this.progress);
        this.setCancelLabel("Stop");
        this.setCancelMnemonic('S');
        this.c.add("Center", jPanel);
        this.addWindowListener(new WindowHandler());
        this.thread = new PluginDownloadThread(this, objectArray, string);
        this.pack();
        this.show();
    }

    public void downloading(String string) {
        this.showMessage("downloading: " + string);
    }

    public void setMaximum(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PluginDownloadProgress.this.progress.setMaximum(n);
            }
        });
    }

    public void setValue(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PluginDownloadProgress.this.progress.setValue(n);
            }
        });
    }

    public void done() {
        if (this.canceled) {
            return;
        }
        if (this.done == this.count) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (PluginDownloadProgress.this.canceled) {
                        return;
                    }
                    PluginDownloadProgress.this.onSuccesfulCompletion();
                    PluginDownloadProgress.this.dispose();
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PluginDownloadProgress.this.progress.setValue(0);
                }
            });
            ++this.done;
        }
    }

    private void showMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PluginDownloadProgress.this.message.setText(string);
            }
        });
    }

    public void onCancel() {
        this.thread.stopRequest();
        this.canceled = true;
        long l = System.currentTimeMillis();
        try {
            this.thread.join(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.onCancelFileClean();
        this.dispose();
    }

    private void onCancelFileClean() {
        int n;
        Object[] objectArray = new String[]{"OK"};
        String string = "";
        File file = null;
        int n2 = 0;
        while (n2 < this.plugins.length) {
            Object object = this.plugins[n2];
            if (object instanceof PluginProperties) {
                PluginProperties pluginProperties = (PluginProperties)this.plugins[n2];
                pluginProperties.setState(0);
                string = string + " " + pluginProperties.name;
                n = 0;
                while (n < pluginProperties.getFiles().length) {
                    file = !this.path.equals("update") ? new File(this.path, pluginProperties.getFiles()[n]) : new File(pluginProperties.path, pluginProperties.getFiles()[n]);
                    try {
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        try {
                            fileOutputStream.write(null);
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {
                        System.out.println("download cancel remove: " + iOException);
                    }
                    ++n;
                }
            }
            ++n2;
        }
        int n3 = JOptionPane.showOptionDialog(this.c, "Download canceled for " + string + " plugin.", "Installing Plugins", -1, 1, null, objectArray, objectArray[0]);
        n = 0;
        n = this.path.equals("update") ? JOptionPane.showOptionDialog(this.c, "You will need to restart JAS to remove the partially downloaded plugin files. The plugins will need to be reinstalled.", "Updating Plugins", -1, 1, null, objectArray, objectArray[0]) : JOptionPane.showOptionDialog(this.c, "You will need to restart JAS to remove the partially downloaded plugin files.", "Installing Plugins", -1, 1, null, objectArray, objectArray[0]);
    }

    private void onSuccesfulCompletion() {
        Object[] objectArray = new String[]{"OK"};
        String string = "";
        int n = 0;
        while (n < this.plugins.length) {
            Object object = this.plugins[n];
            if (object instanceof PluginProperties) {
                if (this.canceled) {
                    return;
                }
                PluginProperties pluginProperties = (PluginProperties)this.plugins[n];
                pluginProperties.setState(1);
                pluginProperties.currversion = pluginProperties.latestversion;
                if (!this.path.equals("update")) {
                    pluginProperties.path = this.path;
                }
            }
            ++n;
        }
        int n2 = 0;
        if (!this.path.equals("update")) {
            n2 = JOptionPane.showOptionDialog(this.c, "Successful download. For these changes to take effect you will need to restart JAS.", "Installing Plugins", -1, 1, null, objectArray, objectArray[0]);
        } else if (this.path.equals("update")) {
            n2 = JOptionPane.showOptionDialog(this.c, "Successful download of updates.", "Updating Plugins", -1, 1, null, objectArray, objectArray[0]);
        }
    }

    class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            PluginDownloadProgress.this.thread.stopRequest();
            PluginDownloadProgress.this.dispose();
        }
    }
}

