/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.Application;
import jas.util.HelpException;
import jas.util.HelpInterface;
import java.awt.Dialog;
import java.awt.Window;
import java.net.URL;
import java.util.Enumeration;
import javax.help.DefaultHelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.Map;
import javax.swing.SwingUtilities;

class HelpInterfaceImpl
implements HelpInterface {
    private HelpSet mainHS;
    private DefaultHelpBroker mainHB;
    private final boolean debugHelp = System.getProperty("debugHelp") != null;

    HelpInterfaceImpl() throws HelpException {
        this.createHelpSet();
    }

    public void showHelpTopic(String string, Window window) {
        this.showHelpTopic(string, "TOC", window);
    }

    public void showHelpTopic(String string, String string2, Window window) {
        try {
            Map.ID iD = Map.ID.create((String)string, (HelpSet)this.mainHS);
            if (iD == null) {
                iD = this.mainHS.getHomeID();
            }
            this.mainHB.setActivationWindow(window);
            this.mainHB.setCurrentView(string2);
            this.mainHB.setCurrentID(iD);
            this.mainHB.setDisplayed(true);
        }
        catch (Exception exception) {
            Application.getApplication().error("Sorry, the help topic could not be found.");
        }
    }

    public void modalDialogOpening(final Dialog dialog) {
        if (this.debugHelp) {
            System.out.println("modelDialogOpening " + this.mainHB.isDisplayed());
        }
        if (this.mainHB.isDisplayed()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    HelpInterfaceImpl.this.mainHB.setActivationWindow((Window)dialog);
                    HelpInterfaceImpl.this.mainHB.setDisplayed(true);
                }
            });
        }
    }

    public void modalDialogClosing(Dialog dialog) {
        if (this.debugHelp) {
            System.out.println("modelDialogClosing " + this.mainHB.isDisplayed());
        }
        this.mainHB.setActivationWindow(null);
    }

    private void createHelpSet() throws HelpException {
        Enumeration enumeration = Application.getApplication().getHelpLocations();
        while (enumeration.hasMoreElements()) {
            try {
                URL uRL = (URL)enumeration.nextElement();
                if (this.debugHelp) {
                    System.out.print("Looking for hs at: " + uRL + " ... ");
                }
                this.mainHS = new HelpSet(null, uRL);
                if (!this.debugHelp) break;
                System.out.println("Success");
                break;
            }
            catch (HelpSetException helpSetException) {
                if (!this.debugHelp) continue;
                System.out.println("Failed");
            }
        }
        if (this.mainHS == null) {
            throw new HelpException("No HelpSet found");
        }
        try {
            this.mainHB = (DefaultHelpBroker)this.mainHS.createHelpBroker();
        }
        catch (Throwable throwable) {
            throw new HelpException("Could not create Help Broker", throwable);
        }
    }
}

