/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio.adaptor;

import hep.analysis.NamedObject;
import jas.job.PageAccess;
import jas.plugin.PageContext;
import jas.plugin.PageEvent;
import jas.plugin.PageListener;
import jas.swingstudio.JASPage;
import jas.swingstudio.JavaAnalysisStudio;
import jas.swingstudio.TreeAdaptor;
import jas.util.JASMenuItem;
import jas.util.OnScreenPopupMenu;
import javax.swing.JPopupMenu;

public class PageTreeAdaptor
extends TreeAdaptor
implements PageListener {
    private static JPopupMenu menu;
    private PageAccess m_page;
    private PageContext pageContext;

    public void init() {
        this.m_page = (PageAccess)this.getAssociatedObject();
    }

    protected void updateNode(int n) {
        if ((n & 0x80000) != 0) {
            this.onShow();
        }
    }

    public void onShow() {
        JASPage jASPage = this.pageContext != null ? (JASPage)this.pageContext.getPage() : new JASPage(this.m_page);
        if (this.pageContext == null) {
            this.pageContext = this.getPluginContext().installPage(this.getName(), jASPage);
            this.pageContext.addPageListener(this);
        } else {
            this.pageContext.requestShow();
        }
    }

    public void onDelete() {
        this.m_page.delete();
    }

    public void onRename() {
        this.startEditing();
    }

    public boolean stopEditing(String string) {
        try {
            this.m_page.rename(string);
            return true;
        }
        catch (NamedObject.RenameException renameException) {
            JavaAnalysisStudio.getApp().error("Illegal name", renameException);
            return false;
        }
    }

    protected boolean isEditable() {
        return true;
    }

    public void onDoubleClick() {
        this.onShow();
    }

    public void pageChanged(PageEvent pageEvent) {
        if (pageEvent.getID() == 4001) {
            this.pageContext.removePageListener(this);
            this.pageContext = null;
        }
    }

    protected JPopupMenu getPopupMenu() {
        if (menu == null) {
            menu = new OnScreenPopupMenu();
            menu.add(new JASMenuItem("Show", 'S'));
            menu.add(new JASMenuItem("Rename", 'R'));
            menu.add(new JASMenuItem("Delete", 'D'));
        }
        return menu;
    }
}

