/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio.adaptor;

import jas.hist.DataSource;
import jas.hist.JASHist;
import jas.hist.Rebinnable1DHistogramData;
import jas.hist.Rebinnable2DHistogramData;
import jas.swingstudio.JASPage;
import jas.swingstudio.JavaAnalysisStudio;
import jas.swingstudio.TreeAdaptor;
import jas.swingstudio.adaptor.OneDTreeData;
import jas.swingstudio.adaptor.ScatterTreeData;
import jas.util.JASMenuItem;
import jas.util.JASState;
import jas.util.OnScreenPopupMenu;
import javax.swing.JPopupMenu;

public class HistogramTreeAdaptor
extends TreeAdaptor {
    private static JPopupMenu menu;
    private DataSource m_data;

    protected void init() {
        DataSource dataSource = (DataSource)this.getAssociatedObject();
        if (dataSource instanceof Rebinnable1DHistogramData) {
            this.m_data = new OneDTreeData(this.getTreeItem(), (Rebinnable1DHistogramData)dataSource);
        } else if (dataSource instanceof Rebinnable2DHistogramData) {
            this.m_data = new ScatterTreeData(this.getTreeItem(), (Rebinnable2DHistogramData)dataSource);
        }
    }

    public void onShowInNewPlot() {
        JASPage jASPage = JavaAnalysisStudio.getApp().getCurrentPage();
        jASPage.addPlot();
        JASHist jASHist = jASPage.getCurrentPlot();
        jASHist.addData(this.m_data).show(true);
        JASPage.calculateTitlesAndLabels(jASHist);
        jASPage.currentPlotUpdated();
    }

    public void enableShowInNewPlot(JASState jASState) {
        jASState.setEnabled(JavaAnalysisStudio.getApp().getCurrentPage() != null);
    }

    public void onShowOnNewPage() {
        JASPage jASPage = JavaAnalysisStudio.getApp().createNewPage();
        JASHist jASHist = jASPage.getCurrentPlot();
        jASHist.addData(this.m_data).show(true);
        JASPage.calculateTitlesAndLabels(jASHist);
        jASPage.currentPlotUpdated();
    }

    public void onShow() {
        JASPage jASPage = JavaAnalysisStudio.getApp().createCurrentPage();
        if (jASPage != null) {
            JASHist jASHist = jASPage.getCurrentPlot();
            jASHist.removeAllData();
            jASHist.addData(this.m_data).show(true);
            JASPage.calculateTitlesAndLabels(jASHist);
            jASPage.currentPlotUpdated();
        }
    }

    public void onOverlay() {
        JASPage jASPage = JavaAnalysisStudio.getApp().getCurrentPage();
        JASHist jASHist = jASPage.getCurrentPlot();
        jASHist.addData(this.m_data).show(true);
        JASPage.calculateTitlesAndLabels(jASHist);
        jASPage.currentPlotUpdated();
    }

    public void enableOverlay(JASState jASState) {
        JASPage jASPage = JavaAnalysisStudio.getApp().getCurrentPage();
        if (jASPage != null) {
            JASHist jASHist = jASPage.getCurrentPlot();
            jASState.setEnabled(jASHist.getNumberOfDataSources() > 0);
        } else {
            jASState.setEnabled(false);
        }
    }

    public void onDoubleClick() {
        this.onShow();
    }

    public void onSelect() {
        JavaAnalysisStudio.getApp().setMessage(this.m_data.toString());
    }

    protected JPopupMenu getPopupMenu() {
        if (menu == null) {
            menu = new OnScreenPopupMenu();
            menu.add(new JASMenuItem("Show", 'S'));
            menu.add(new JASMenuItem("Overlay", 'O'));
            menu.add(new JASMenuItem("Show In New Plot", 'P'));
            menu.add(new JASMenuItem("Show On New Page", 'N'));
        }
        return menu;
    }
}

