/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import jas.swingstudio.JavaAnalysisStudio;
import jas.util.UserProperties;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public abstract class RecentItemsMenu
extends JMenu
implements ActionListener {
    private final UserProperties m_prop = JavaAnalysisStudio.getApp().getUserProperties();
    private final String m_lengthKey;
    private String[] m_lastItems;
    private boolean m_build = true;

    public RecentItemsMenu(String string) {
        this.m_lengthKey = string;
    }

    public final void setEnabled(String[] stringArray) {
        this.m_lastItems = stringArray;
        this.m_build = stringArray != null && stringArray.length > 0;
        this.setEnabled(this.m_build);
    }

    protected final void fireMenuSelected() {
        if (this.m_build) {
            this.removeAll();
            int n = 0;
            int n2 = Math.min(this.m_prop.getInteger(this.m_lengthKey, 4), this.m_lastItems.length);
            while (n < n2) {
                AbstractMenuItem abstractMenuItem = new AbstractMenuItem(this.toDisplayFormat(this.m_lastItems[n]), ++n);
                abstractMenuItem.addActionListener(this);
                this.add(abstractMenuItem);
            }
            this.m_build = false;
        }
        super.fireMenuSelected();
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof AbstractMenuItem) {
            AbstractMenuItem abstractMenuItem = (AbstractMenuItem)object;
            this.itemSelected(abstractMenuItem.name);
        }
    }

    protected abstract String toDisplayFormat(String var1);

    protected abstract void itemSelected(String var1);

    private class AbstractMenuItem
    extends JMenuItem {
        String name;

        AbstractMenuItem(String string, int n) {
            super(String.valueOf(n) + " " + string);
            this.name = string;
            this.setMnemonic(48 + (char)n);
        }
    }
}

