/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import jas.job.LoaderException;
import jas.loader.ClassPathLoader;
import jas.swingstudio.BuiltInCompiler;
import jas.swingstudio.ChangableContainer;
import jas.swingstudio.Closable;
import jas.swingstudio.FileError;
import jas.swingstudio.HasCommandProcessor;
import jas.swingstudio.JASClassPath;
import jas.swingstudio.JASCommandProcessor;
import jas.swingstudio.JASException;
import jas.swingstudio.JASJob;
import jas.swingstudio.JASWindowManager;
import jas.swingstudio.JavaAnalysisStudio;
import jas.swingstudio.ProgramPagePopupMenu;
import jas.swingstudio.ProgramTextArea;
import jas.util.CommandProcessor;
import jas.util.FileTypeFileFilter;
import jas.util.JASDialog;
import jas.util.JASState;
import jas.util.JASTextField;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Externalizable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import org.gjt.sp.jedit.syntax.DefaultSyntaxDocument;

final class ProgramPage
extends JScrollPane
implements ChangeListener,
DocumentListener,
HasCommandProcessor,
Externalizable,
ChangableContainer,
ActionListener,
Closable {
    static final long serialVersionUID = -4186647674998093369L;
    private DefaultSyntaxDocument d;
    private ProgramTextPage text;
    private File f;
    private String m_name;
    private boolean m_isCompiled = false;
    private boolean isChanged;
    private boolean m_hasChangedSinceLastBackup;
    private ProgramCommandProcessor commandProcessor;
    private static Timer backupTimer = null;
    private static final String backupInterval_Key = "BackupInterval";
    private static final String backupDirectory_Key = "BackupDir";
    private static final String isRunning_Key = "RunTimedBackup";
    private static final String leftMargin_Key = "left";
    private static final String rightMargin_Key = "right";
    private static final String topMargin_Key = "top";
    private static final String bottomMargin_Key = "bottom";
    private static final Vector m_instances = new Vector();
    private final Dimension m_preferredSize = new Dimension(50, 50);
    static /* synthetic */ Class class$javax$swing$JInternalFrame;
    static /* synthetic */ Class class$jas$swingstudio$JASWindowManager;

    public ProgramPage() {
        this.init(true);
        ProgramPage.setTabSizeProperty((DefaultSyntaxDocument)this.getText().getDocument(), ProgramPage.getTabSize());
    }

    ProgramPage(File file) throws FileError {
        this.init(false);
        try {
            this.text.read(new FileReader(file), (Object)file);
            this.d = (DefaultSyntaxDocument)this.text.getDocument();
            this.d.addDocumentListener(this);
            this.text.setStyles();
            this.f = file;
            this.isChanged = false;
            this.m_hasChangedSinceLastBackup = false;
            String string = file.getName();
            this.setClassName(string.substring(0, string.length() - 5));
            ProgramPage.setTabSizeProperty((DefaultSyntaxDocument)this.getText().getDocument(), ProgramPage.getTabSize());
        }
        catch (IOException iOException) {
            throw new FileError("Could not load file: " + file.getName(), iOException);
        }
    }

    public DefaultSyntaxDocument getDefaultSyntaxDocument() {
        return this.d;
    }

    String getCanonicalPath() {
        try {
            return this.f.getCanonicalPath();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void init(boolean bl) {
        if (backupTimer == null) {
            backupTimer = new Timer(ProgramPage.getBackupInterval(), new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                }
            });
            backupTimer.setInitialDelay(0);
            if (ProgramPage.timerIsRunning()) {
                backupTimer.start();
            }
        }
        this.text = new ProgramTextPage();
        this.setViewportView(this.text);
        this.text.getDocument().addDocumentListener(this);
        this.text.getCaret().addChangeListener(this);
        if (bl) {
            this.text.setStyles();
        }
        this.isChanged = false;
        this.m_hasChangedSinceLastBackup = false;
        this.commandProcessor = new ProgramCommandProcessor();
    }

    private boolean classExists() {
        try {
            ClassPathLoader classPathLoader = new ClassPathLoader(JASClassPath.create(), "ProgramLoader");
            byte[] byArray = classPathLoader.loadClassData(this.m_name);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private String getPackage() {
        String string = this.text.getText();
        int n = string.indexOf("package");
        if (n != -1) {
            char c;
            n += 7;
            while (Character.isWhitespace(string.charAt(n))) {
                ++n;
            }
            int n2 = n;
            while ((c = string.charAt(n2)) != ';' && !Character.isWhitespace(c)) {
                ++n2;
            }
            return string.substring(n, n2) + ".";
        }
        return "";
    }

    void setClassName(String string) {
        this.m_name = this.getPackage().concat(string);
    }

    static int getBackupInterval() {
        return JavaAnalysisStudio.getApp().getUserProperties().getInteger(backupInterval_Key, 300000);
    }

    static void setBackupInterval(int n) {
        JavaAnalysisStudio.getApp().getUserProperties().setInteger(backupInterval_Key, n);
        if (backupTimer != null && n != backupTimer.getDelay()) {
            backupTimer.setDelay(n);
        }
    }

    static boolean timerIsRunning() {
        return JavaAnalysisStudio.getApp().getUserProperties().getBoolean(isRunning_Key, false);
    }

    static void setTimerIsRunning(boolean bl) {
        JavaAnalysisStudio.getApp().getUserProperties().setBoolean(isRunning_Key, bl);
        if (backupTimer == null) {
            return;
        }
        if (backupTimer.isRunning()) {
            if (!bl) {
                backupTimer.stop();
            }
        } else if (bl) {
            backupTimer.start();
        }
    }

    static String getBackupDirectory() {
        return JavaAnalysisStudio.getApp().getUserProperties().getString(backupDirectory_Key, "backup" + File.separator);
    }

    static void setBackupDirectory(String string) {
        JavaAnalysisStudio.getApp().getUserProperties().setString(backupDirectory_Key, string);
    }

    public void removeNotify() {
        m_instances.removeElement(this);
        super.removeNotify();
        backupTimer.removeActionListener(this);
    }

    public void addNotify() {
        m_instances.addElement(this);
        super.addNotify();
        backupTimer.addActionListener(this);
    }

    public CommandProcessor getCommandProcessor() {
        return this.commandProcessor;
    }

    public boolean hasChanged() {
        return this.isChanged;
    }

    void setFile(File file) {
        this.f = file;
        this.isChanged = false;
        this.m_hasChangedSinceLastBackup = false;
    }

    ProgramTextArea getText() {
        return this.text;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.setChanged(true);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.setChanged(true);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.setChanged(true);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        try {
            int n = this.text.getCaretPosition();
            Rectangle rectangle = this.text.modelToView(n);
            int n2 = 1 + rectangle.y / this.text.getGraphics().getFontMetrics().getHeight();
            JavaAnalysisStudio.getApp().setMessage("Line " + n2);
        }
        catch (BadLocationException badLocationException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.commandProcessor.setChanged();
    }

    private void setChanged(boolean bl) {
        this.isChanged = this.m_hasChangedSinceLastBackup = bl;
        this.commandProcessor.setChanged();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.m_name);
        if (this.f != null) {
            if (this.isChanged) {
                this.commandProcessor.onSave();
            }
            objectOutput.writeObject(this.f);
        } else {
            objectOutput.writeObject(this.text.getText());
            objectOutput.writeBoolean(this.isChanged);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.init(false);
        this.m_name = (String)objectInput.readObject();
        Object object = objectInput.readObject();
        if (object instanceof File) {
            this.f = (File)object;
            this.text.read(new FileReader(this.f), (Object)this.f);
            this.text.getDocument().addDocumentListener(this);
            this.isChanged = false;
            this.m_hasChangedSinceLastBackup = false;
        } else {
            this.f = null;
            this.text.setText((String)object);
            this.isChanged = objectInput.readBoolean();
        }
        this.text.setStyles();
    }

    void setText(String string) {
        this.text.setText(string);
    }

    public void pageSelected(boolean bl) {
    }

    public boolean pleaseClose() throws JASException {
        try {
            if (!this.isChanged) {
                return true;
            }
            String string = this.f == null ? "Untitled" : this.f.getName();
            int n = JOptionPane.showConfirmDialog(this, "Save changes to file " + string + "?", "Save Changes?", 1, 2);
            if (n == 0) {
                return this.save();
            }
            return n == 1;
        }
        catch (IOException iOException) {
            throw new JASException("Error saving file", iOException);
        }
    }

    private synchronized boolean save() throws IOException {
        if (this.f == null) {
            return this.saveAs();
        }
        try {
            FileWriter fileWriter = new FileWriter(this.f);
            this.text.write(fileWriter);
            fileWriter.close();
            this.isChanged = false;
            this.m_hasChangedSinceLastBackup = false;
            JavaAnalysisStudio.getApp().updateRecentFiles(this.f);
            String string = this.f.getName();
            this.setClassName(string.substring(0, string.length() - 5));
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException("Could not save file (not writable?)");
        }
    }

    private synchronized boolean saveAs() throws IOException {
        JFileChooser jFileChooser = new JFileChooser(JavaAnalysisStudio.getApp().getUserProperties().getString("LastProgramPath", System.getProperty("user.home")));
        jFileChooser.setSelectedFile(new File(this.m_name.concat(".java")));
        jFileChooser.setFileFilter(new FileTypeFileFilter("java", "Java File (*.java)"));
        jFileChooser.setDialogTitle("Save Source File As...");
        if (jFileChooser.showSaveDialog(this) == 0) {
            File file = jFileChooser.getSelectedFile();
            if (!file.getName().endsWith(".java")) {
                file = new File(file.getAbsolutePath().concat(".java"));
            }
            JavaAnalysisStudio.getApp().getWindowManager().setCurrentTitle(file.getName());
            JavaAnalysisStudio.getApp().getUserProperties().setString("LastProgramPath", file.getParent());
            try {
                FileWriter fileWriter = new FileWriter(file);
                this.text.write(fileWriter);
                fileWriter.close();
                this.f = file;
                this.isChanged = false;
                this.m_hasChangedSinceLastBackup = false;
                JavaAnalysisStudio.getApp().updateRecentFiles(file);
                String string = file.getName();
                this.setClassName(string.substring(0, string.length() - 5));
                return true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IOException("Could not save file (not writable?)");
            }
        }
        return false;
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        if (!this.m_hasChangedSinceLastBackup) {
            return;
        }
        File file = new File(ProgramPage.getBackupDirectory(), (this.f == null ? String.valueOf(this.hashCode()) : this.f.getName()) + ".bk");
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            this.text.write(fileWriter);
            fileWriter.close();
            System.out.println("saved backup file " + file.getAbsolutePath());
            this.m_hasChangedSinceLastBackup = false;
        }
        catch (Exception exception) {
            ProgramPage.setTimerIsRunning(false);
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            JavaAnalysisStudio.getApp().error("Timed backup failed and has been stopped.", exception, "jobs.eventAnalysisAndGeneration.timedBackup");
        }
    }

    private static void setTabSizeProperty(DefaultSyntaxDocument defaultSyntaxDocument, int n) {
        defaultSyntaxDocument.putProperty("tabSize", new Integer(n));
    }

    public static void setTabSize(int n) {
        if (m_instances.size() == 0) {
            return;
        }
        Enumeration enumeration = m_instances.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ProgramPage programPage = (ProgramPage)enumeration.nextElement();
                ProgramPage.setTabSizeProperty((DefaultSyntaxDocument)programPage.getText().getDocument(), n);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        JavaAnalysisStudio.getApp().getUserProperties().setInteger("tabSize", n);
    }

    public static int getTabSize() {
        return JavaAnalysisStudio.getApp().getUserProperties().getInteger("tabSize", 4);
    }

    static void updateInstanceFonts() {
        if (m_instances.size() == 0) {
            return;
        }
        Font font = new Font(ProgramTextArea.getDisplayFont(), ProgramTextArea.getFontStyle(), ProgramTextArea.getFontSize());
        Enumeration enumeration = m_instances.elements();
        while (enumeration.hasMoreElements()) {
            ProgramPage programPage = (ProgramPage)enumeration.nextElement();
            programPage.getText().setFont(font);
            programPage.repaint();
        }
    }

    static void updateInstanceStyles() {
        if (m_instances.size() == 0) {
            return;
        }
        Enumeration enumeration = m_instances.elements();
        while (enumeration.hasMoreElements()) {
            ProgramPage programPage = (ProgramPage)enumeration.nextElement();
            programPage.getText().setStyles();
            programPage.repaint();
        }
    }

    static float getRightMargin() {
        return JavaAnalysisStudio.getApp().getUserProperties().getFloat(rightMargin_Key, 0.5f);
    }

    static void setRightMargin(float f) {
        JavaAnalysisStudio.getApp().getUserProperties().setFloat(rightMargin_Key, f);
    }

    static float getTopMargin() {
        return JavaAnalysisStudio.getApp().getUserProperties().getFloat(topMargin_Key, 0.5f);
    }

    static void setTopMargin(float f) {
        JavaAnalysisStudio.getApp().getUserProperties().setFloat(topMargin_Key, f);
    }

    static float getBottomMargin() {
        return JavaAnalysisStudio.getApp().getUserProperties().getFloat(bottomMargin_Key, 0.5f);
    }

    static void setBottomMargin(float f) {
        JavaAnalysisStudio.getApp().getUserProperties().setFloat(bottomMargin_Key, f);
    }

    static float getLeftMargin() {
        return JavaAnalysisStudio.getApp().getUserProperties().getFloat(leftMargin_Key, 0.5f);
    }

    static void setLeftMargin(float f) {
        JavaAnalysisStudio.getApp().getUserProperties().setFloat(leftMargin_Key, f);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public final class ProgramTextPage
    extends ProgramTextArea {
        ProgramTextPage() {
            super(true);
            this.enableEvents(16L);
            this.addKeyListener(new KL());
        }

        public void setTabSize(int n) {
            try {
                ((DefaultSyntaxDocument)ProgramPage.this.text.getDocument()).putProperty("tabSize", new Integer(2));
            }
            catch (Exception exception) {
                // empty catch block
            }
            JavaAnalysisStudio.getApp().getUserProperties().setInteger("tabSize", n);
        }

        protected void processMouseEvent(MouseEvent mouseEvent) {
            super.processMouseEvent(mouseEvent);
            if (mouseEvent.isPopupTrigger()) {
                Serializable serializable;
                Serializable serializable2;
                Container container = ProgramPage.this;
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                n2 -= ProgramPage.this.getViewport().getViewPosition().y;
                Container container2 = SwingUtilities.getAncestorOfClass(class$javax$swing$JInternalFrame == null ? (class$javax$swing$JInternalFrame = ProgramPage.class$("javax.swing.JInternalFrame")) : class$javax$swing$JInternalFrame, container);
                if (container2 != null) {
                    serializable2 = container2.getParent();
                    while (container != serializable2) {
                        serializable = container.getLocation();
                        n += ((Point)serializable).x;
                        n2 += ((Point)serializable).y;
                        container = container.getParent();
                    }
                }
                serializable2 = JavaAnalysisStudio.getApp().getJob();
                if (!ProgramPage.this.m_isCompiled && ProgramPage.this.classExists()) {
                    ProgramPage.this.m_isCompiled = true;
                }
                JavaAnalysisStudio.getApp().getCommandManager().add(ProgramPage.this.commandProcessor);
                serializable = new ProgramPagePopupMenu();
                ((ProgramPagePopupMenu)serializable).willBecomeVisible(ProgramPage.this.m_name, ProgramPage.this.m_name != null && serializable2 != null && ProgramPage.this.m_isCompiled && !((JASJob)serializable2).isLoaded(ProgramPage.this.m_name));
                JASWindowManager jASWindowManager = (JASWindowManager)SwingUtilities.getAncestorOfClass(class$jas$swingstudio$JASWindowManager == null ? (class$jas$swingstudio$JASWindowManager = ProgramPage.class$("jas.swingstudio.JASWindowManager")) : class$jas$swingstudio$JASWindowManager, this);
                if (jASWindowManager != null) {
                    jASWindowManager.modifyPopupMenu((JPopupMenu)serializable, container);
                }
                ((JPopupMenu)serializable).show(container, n, n2);
            }
        }

        void gotoLine(int n) {
            this.setCaretPosition(this.viewToModel(new Point(0, this.getGraphics().getFontMetrics().getHeight() * (n - 1))));
        }

        private void setLeadingTabsForClosingBrace(int n) {
            try {
                int n2 = n;
                Element element = this.getDocument().getDefaultRootElement();
                int n3 = element.getElementIndex(n);
                Element element2 = element.getElement(n3);
                int n4 = element2.getStartOffset();
                int n5 = element2.getEndOffset();
                int n6 = n5 - n4 - 1;
                String string = this.getDocument().getText(n4, n6);
                int n7 = 0;
                while (n7 < n - n4) {
                    if (!Character.isWhitespace(string.charAt(n7))) {
                        return;
                    }
                    ++n7;
                }
                String string2 = string.trim();
                this.getDocument().remove(n4, n6);
                this.getDocument().insertString(n4, string2, null);
                n = n4;
                this.indentLine(n);
                element2 = element.getElement(n3);
                n4 = element2.getStartOffset();
                n5 = element2.getEndOffset();
                n6 = n5 - n4 - 1;
                String string3 = this.getDocument().getText(n4, n6);
                int n8 = 0;
                while (n8 < string3.length()) {
                    Character c = new Character(string3.charAt(n8));
                    if (!c.equals(new Character('\t'))) break;
                    ++n8;
                }
                n = n4 + n8;
                if (n8 > 0) {
                    this.getDocument().remove(n - 1, 1);
                    this.setCaretPosition(n - 1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        boolean indentLine(int n) {
            String string = "{";
            String string2 = "}";
            int n2 = ProgramPage.getTabSize();
            boolean bl = false;
            try {
                char c;
                Element element = this.getDocument().getDefaultRootElement();
                int n3 = element.getElementIndex(n);
                if (n3 == 0) {
                    return false;
                }
                Element element2 = element.getElement(n3);
                Element element3 = null;
                int n4 = 0;
                int n5 = 0;
                while (--n3 >= 0) {
                    element3 = element.getElement(n3);
                    n4 = element3.getStartOffset();
                    n5 = element3.getEndOffset();
                    if (n5 - n4 > 1) break;
                }
                if (element3 == null) {
                    return false;
                }
                int n6 = element2.getStartOffset();
                int n7 = element2.getEndOffset();
                String string3 = this.getDocument().getText(n6, n7 - n6);
                String string4 = this.getDocument().getText(n4, n5 - n4);
                boolean bl2 = true;
                int n8 = 0;
                int n9 = 0;
                int n10 = 0;
                while (n10 < string4.length()) {
                    c = string4.charAt(n10);
                    switch (c) {
                        case ' ': {
                            if (!bl2) break;
                            ++n8;
                            break;
                        }
                        case '\t': {
                            if (!bl2) break;
                            n8 += n2 - n8 % n2;
                            break;
                        }
                        default: {
                            bl2 = false;
                            if (string2.indexOf(c) != -1) {
                                n9 = Math.max(n9 - 1, 0);
                                break;
                            }
                            if (string.indexOf(c) == -1) break;
                            ++n9;
                        }
                    }
                    ++n10;
                }
                c = '\u0001';
                int n11 = 0;
                int n12 = 0;
                int n13 = 0;
                int n14 = 0;
                int n15 = 0;
                while (n15 < string3.length()) {
                    char c2 = string3.charAt(n15);
                    switch (c2) {
                        case ' ': {
                            if (c == '\u0000') break;
                            ++n11;
                            ++n12;
                            break;
                        }
                        case '\t': {
                            if (c == '\u0000') break;
                            n11 += n2 - n11 % n2;
                            ++n12;
                            break;
                        }
                        default: {
                            c = '\u0000';
                            if (string2.indexOf(c2) != -1) {
                                if (n14 != 0) {
                                    --n14;
                                    break;
                                }
                                --n13;
                                break;
                            }
                            if (string.indexOf(c2) == -1) break;
                            ++n14;
                        }
                    }
                    ++n15;
                }
                if (n11 >= (n8 += (n9 + n13) * n2)) {
                    return false;
                }
                this.getDocument().remove(n6, n12);
                this.getDocument().insertString(n6, this.createWhiteSpace(n8, n2, bl), null);
                return true;
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
                return false;
            }
        }

        public String createWhiteSpace(int n, int n2, boolean bl) {
            StringBuffer stringBuffer = new StringBuffer();
            if (bl) {
                while (n-- > 0) {
                    stringBuffer.append(' ');
                }
            } else {
                int n3 = n / n2;
                while (n3-- > 0) {
                    stringBuffer.append('\t');
                }
                n3 = n % n2;
                while (n3-- > 0) {
                    stringBuffer.append(' ');
                }
            }
            return stringBuffer.toString();
        }

        class KL
        extends KeyAdapter {
            KL() {
            }

            public void keyPressed(KeyEvent keyEvent) {
                int n = ProgramTextPage.this.getSelectionStart();
                int n2 = ProgramTextPage.this.getSelectionEnd();
                boolean bl = false;
                switch (keyEvent.getKeyCode()) {
                    case 10: {
                        ProgramTextPage.this.replaceSelection("\n");
                        if (n == n2) {
                            ProgramTextPage.this.indentLine(ProgramTextPage.this.getSelectionStart());
                        }
                        keyEvent.consume();
                        break;
                    }
                    case 9: {
                        if (n == n2) {
                            bl = ProgramTextPage.this.indentLine(n);
                        }
                        if (!bl) break;
                        keyEvent.consume();
                        break;
                    }
                    default: {
                        int n3;
                        if (!new Character(keyEvent.getKeyChar()).equals(new Character('}')) || (n3 = ProgramTextPage.this.getCaretPosition()) <= 0) break;
                        ProgramTextPage.this.setLeadingTabsForClosingBrace(n3);
                        keyEvent.consume();
                    }
                }
            }
        }
    }

    private class CompileOutputProcessor
    extends Thread {
        private InputStream in;
        private OutputStream out;

        CompileOutputProcessor(InputStream inputStream, OutputStream outputStream) {
            this.in = inputStream;
            this.out = outputStream;
            this.start();
        }

        public void run() {
            try {
                byte[] byArray = new byte[4096];
                int n = this.in.read(byArray);
                while (n >= 0) {
                    this.out.write(byArray, 0, n);
                    n = this.in.read(byArray);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class ProgramCommandProcessor
    extends JASCommandProcessor {
        private final String m_showJDKWarningBox_Key = "ShowJDKWarningBox";

        private ProgramCommandProcessor() {
        }

        public void onSave() throws IOException {
            if (ProgramPage.this.save()) {
                this.setChanged();
            }
        }

        public void onSaveAs() throws IOException {
            if (ProgramPage.this.saveAs()) {
                this.setChanged();
            }
        }

        public void enableSave(JASState jASState) {
            jASState.setEnabled(ProgramPage.this.isChanged);
        }

        public void onGoToLine() {
            new JASDialog(this, JavaAnalysisStudio.getApp().getFrame(), "Go To Line..."){
                private JTextField m_line;
                private final /* synthetic */ ProgramCommandProcessor this$1;
                {
                    this.this$1 = programCommandProcessor;
                }

                protected void onOK() {
                    try {
                        ProgramPage.access$500(ProgramCommandProcessor.access$400(this.this$1)).gotoLine(Integer.parseInt(this.m_line.getText()));
                        super.onOK();
                    }
                    catch (NumberFormatException numberFormatException) {
                        JOptionPane.showMessageDialog(this, this.m_line.getText().concat(" is not a number."), "Number Format Exception", 0);
                    }
                }

                public boolean doModal() {
                    this.m_line = new JASTextField(8);
                    try {
                        this.m_line.setText(String.valueOf(1 + ProgramPage.access$500((ProgramPage)ProgramCommandProcessor.access$400((ProgramCommandProcessor)this.this$1)).modelToView((int)ProgramPage.access$500((ProgramPage)ProgramCommandProcessor.access$400((ProgramCommandProcessor)this.this$1)).getCaretPosition()).y / ProgramPage.access$500(ProgramCommandProcessor.access$400(this.this$1)).getGraphics().getFontMetrics().getHeight()));
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    Container container = this.getContentPane();
                    container.add("West", new JLabel("Enter line number: "));
                    container.add("East", this.m_line);
                    this.m_line.getDocument().addDocumentListener(this);
                    this.pack();
                    this.m_line.requestFocus();
                    return super.doModal();
                }
            }.doModal();
        }

        public void onPrint() {
            block13: {
                String string = ProgramTextArea.getPrintingFont();
                int n = ProgramTextArea.getPrintingFontStyle();
                int n2 = ProgramTextArea.getPrintingFontSize();
                float f = ProgramPage.getLeftMargin();
                float f2 = ProgramPage.getRightMargin();
                float f3 = ProgramPage.getTopMargin();
                float f4 = ProgramPage.getBottomMargin();
                PrintJob printJob = ProgramPage.this.getToolkit().getPrintJob(JavaAnalysisStudio.getApp().getFrame(), "Java Analysis Studio", null);
                try {
                    if (printJob == null) break block13;
                    Graphics graphics = printJob.getGraphics();
                    graphics.setFont(new Font(string, n, n2));
                    int n3 = printJob.getPageResolution();
                    Dimension dimension = printJob.getPageDimension();
                    int n4 = (int)(((double)f2 + 0.5) * (double)n3);
                    int n5 = (int)(f * (float)n3);
                    int n6 = (int)(((double)f4 + 0.5) * (double)n3);
                    int n7 = (int)(f3 * (float)n3);
                    String string2 = ProgramPage.this.text.getText();
                    StringBuffer stringBuffer = new StringBuffer(string2.length() * 11 / 10);
                    int n8 = string2.indexOf(9);
                    int n9 = 0;
                    while (n8 >= 0) {
                        stringBuffer.append(string2.substring(n9, n8));
                        stringBuffer.append("    ");
                        n9 = n8 + 1;
                        n8 = string2.indexOf(9, n9);
                    }
                    stringBuffer.append(string2.substring(n9));
                    String string3 = stringBuffer.toString();
                    FontMetrics fontMetrics = graphics.getFontMetrics();
                    int n10 = fontMetrics.getHeight();
                    int n11 = dimension.height - n6;
                    int n12 = dimension.width - n4 - n5;
                    int n13 = n7 + fontMetrics.getAscent();
                    if (n11 <= n7 || n12 <= 0) {
                        JOptionPane.showMessageDialog(JavaAnalysisStudio.getApp().getFrame(), "Page has negative or zero size.", "Error...", 0);
                        return;
                    }
                    int n14 = 0;
                    int n15 = 0;
                    char[] cArray = new char[100];
                    while (true) {
                        int n16;
                        int n17 = n13;
                        try {
                            while (n17 < n11) {
                                int n18;
                                char c;
                                int n19 = 0;
                                while ((c = string3.charAt(n15)) != '\n') {
                                    if ((n19 += fontMetrics.charWidth(c)) > n12) break;
                                    ++n15;
                                }
                                if (n15 == n14 && c != '\n') {
                                    ++n15;
                                }
                                if (cArray.length < (n16 = (n18 = string3.charAt(n15 - 1) == '\r' ? n15 - 1 : n15) - n14)) {
                                    cArray = new char[n16];
                                }
                                string3.getChars(n14, n18, cArray, 0);
                                graphics.drawChars(cArray, 0, n16, n5, n17);
                                if (c == '\n') {
                                    // empty if block
                                }
                                n14 = ++n15;
                                n17 += n10;
                            }
                        }
                        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                            int n20 = string3.charAt(n15 - 1) == '\r' ? n15 - 1 : n15;
                            n16 = n20 - n14;
                            if (cArray.length < n16) {
                                cArray = new char[n16];
                            }
                            string3.getChars(n14, n20, cArray, 0);
                            graphics.drawChars(cArray, 0, n16, n5, n17);
                            graphics.dispose();
                            break;
                        }
                        graphics.dispose();
                        Font font = graphics.getFont();
                        graphics = printJob.getGraphics();
                        graphics.setFont(font);
                    }
                    printJob.end();
                }
                catch (Throwable throwable) {
                    JavaAnalysisStudio.getApp().error("Error.  Print job canceled.", throwable);
                    printJob.end();
                }
            }
        }

        private PrintStream getCompilerPrintStream() {
            return new PrintStream(JavaAnalysisStudio.getApp().getOutputStream("Compiler Messages"));
        }

        public void onCompile() throws JASException, IOException {
            block16: {
                if (ProgramPage.this.f == null) {
                    throw new JASException("You must save the file before compiling it");
                }
                JavaAnalysisStudio javaAnalysisStudio = JavaAnalysisStudio.getApp();
                String string = javaAnalysisStudio.getUserProperties().getString("Compiler", "javac");
                boolean bl = javaAnalysisStudio.getUserProperties().getBoolean("UseBuiltInCompiler", true);
                if (bl || !string.startsWith("javac") || !javaAnalysisStudio.getUserProperties().getBoolean("ShowJDKWarningBox", true) || new JDKMessageBox(javaAnalysisStudio.getFrame()).doModal()) {
                    File file;
                    String string2;
                    if (ProgramPage.this.isChanged) {
                        this.onSave();
                    }
                    char c = File.pathSeparatorChar;
                    StringBuffer stringBuffer = new StringBuffer(System.getProperty("java.class.path"));
                    String string3 = javaAnalysisStudio.getExtensionLoader().getClassPath().toString();
                    if (string3.length() > 0) {
                        stringBuffer.append(c).append(string3);
                    }
                    if ((string2 = JASClassPath.create().toString()).length() > 0) {
                        stringBuffer.append(c).append(string2);
                    }
                    if ((file = new File(System.getProperty("java.home") + File.separator + "lib" + File.separator + "rt.jar")).exists()) {
                        stringBuffer.append(c).append(file.getCanonicalPath());
                    }
                    String string4 = ProgramPage.this.f.getCanonicalPath();
                    if (!bl) {
                        if (string4.indexOf(32) > -1) {
                            string4 = "\"" + string4 + "\"";
                        }
                        String[] stringArray = new String[]{"CLASSPATH=" + stringBuffer};
                        String string5 = string + " " + string4;
                        PrintStream printStream = this.getCompilerPrintStream();
                        printStream.println("----------- " + string5);
                        Process process = Runtime.getRuntime().exec(string5, stringArray);
                        CompileOutputProcessor compileOutputProcessor = new CompileOutputProcessor(process.getInputStream(), printStream);
                        CompileOutputProcessor compileOutputProcessor2 = new CompileOutputProcessor(process.getErrorStream(), printStream);
                        try {
                            int n = process.waitFor();
                            compileOutputProcessor.join();
                            compileOutputProcessor2.join();
                            printStream.println("----------- compile complete rc=" + n);
                            if (n > 0) {
                                javaAnalysisStudio.error("Compile failed rc=" + n + " (see Compiler Output window for details)");
                                break block16;
                            }
                            javaAnalysisStudio.getToolkit().beep();
                            this.reload();
                        }
                        catch (InterruptedException interruptedException) {}
                    } else {
                        try {
                            PrintStream printStream = this.getCompilerPrintStream();
                            printStream.println("----------- Compiling " + string4);
                            BuiltInCompiler builtInCompiler = new BuiltInCompiler(printStream);
                            builtInCompiler.setClassPath(stringBuffer.toString());
                            boolean bl2 = builtInCompiler.compile(string4);
                            if (bl2) {
                                printStream.println("----------- compile successful");
                                javaAnalysisStudio.getToolkit().beep();
                                this.reload();
                            } else {
                                printStream.println("----------- compile failed");
                                javaAnalysisStudio.error("Compile failed (see Compiler Output window for details)");
                            }
                        }
                        catch (Exception exception) {
                            javaAnalysisStudio.error("Unable to create built-in compiler", exception);
                        }
                    }
                }
            }
        }

        private void reload() {
            JavaAnalysisStudio javaAnalysisStudio = JavaAnalysisStudio.getApp();
            try {
                JASJob jASJob = javaAnalysisStudio.getJob();
                if (jASJob != null) {
                    jASJob.reload();
                }
                ProgramPage.this.m_isCompiled = true;
            }
            catch (LoaderException loaderException) {
                javaAnalysisStudio.error("Error reloading programs", loaderException);
            }
            catch (RemoteException remoteException) {
                javaAnalysisStudio.error("Unexpected Exception", remoteException);
            }
        }

        public void onCut() {
            ProgramPage.this.text.cut();
        }

        public void onCopy() {
            ProgramPage.this.text.copy();
        }

        public void onPaste() {
            ProgramPage.this.text.paste();
        }

        public void enableCut(JASState jASState) {
            jASState.setEnabled(ProgramPage.this.text.getSelectedText() != null);
        }

        public void enableCopy(JASState jASState) {
            jASState.setEnabled(ProgramPage.this.text.getSelectedText() != null);
        }

        public void setChanged() {
            super.setChanged();
        }

        static /* synthetic */ ProgramPage access$400(ProgramCommandProcessor programCommandProcessor) {
            return programCommandProcessor.ProgramPage.this;
        }

        private class JDKMessageBox
        extends JASDialog {
            private JCheckBox cb;

            JDKMessageBox(Frame frame) {
                super(frame, "Compile requirements", true, 13);
                Container container = this.getContentPane();
                container.setLayout(new BoxLayout(container, 1));
                container.add(new JLabel("Note:"));
                container.add(new JLabel("This option will not run unless you have"));
                container.add(new JLabel("downloaded the Java Development Kit from Sun."));
                this.cb = new JCheckBox("Show this message next time", true);
                container.add(this.cb);
                this.pack();
                this.setHelpTopic("jobs.eventAnalysisAndGeneration.compiling");
            }

            public void onOK() {
                super.onOK();
                JavaAnalysisStudio.getApp().getUserProperties().setBoolean("ShowJDKWarningBox", this.cb.isSelected());
            }
        }
    }
}

