/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import jas.job.OpenJobException;
import jas.swingstudio.JASJobAdaptor;
import jas.swingstudio.JavaAnalysisStudio;
import jas.swingstudio.TreeItemTreeNode;
import jas.util.Finishable;
import jas.util.HasHelpPage;
import jas.util.JASWizardPage;
import jas.util.tree.TreeItem;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

class OpenDataSetPage
extends JASWizardPage
implements TreeSelectionListener,
Finishable,
HasHelpPage {
    private JASJobAdaptor m_job;
    private JavaAnalysisStudio m_app;
    private JTree m_tree;
    private JScrollPane m_scrollPane = new JScrollPane();

    OpenDataSetPage() {
        super(new BorderLayout());
        this.m_scrollPane.setPreferredSize(new Dimension(300, 150));
        this.add("North", new JLabel("Select a data set to open:"));
        this.add("Center", this.m_scrollPane);
    }

    OpenDataSetPage(JASJobAdaptor jASJobAdaptor, JavaAnalysisStudio javaAnalysisStudio) {
        this();
        this.setJob(jASJobAdaptor, javaAnalysisStudio);
    }

    void setJob(JASJobAdaptor jASJobAdaptor, JavaAnalysisStudio javaAnalysisStudio) {
        this.m_job = jASJobAdaptor;
        this.m_app = javaAnalysisStudio;
    }

    public void onFinish() {
        try {
            TreePath treePath = this.m_tree.getSelectionPath();
            TreeItemTreeNode treeItemTreeNode = (TreeItemTreeNode)treePath.getLastPathComponent();
            this.m_job.openDataSource(treeItemTreeNode.getTreeItem());
            this.dispose();
        }
        catch (OpenJobException openJobException) {
            this.m_app.closeCurrentJob();
            this.m_app.setToEmptyJob();
            this.dispose();
            this.m_app.error("Could not open job", openJobException);
        }
    }

    public void beforeShowing() {
        this.m_tree = new JTree(new TreeItemTreeNode(this.m_job.listDataSources()), true);
        this.m_tree.setRootVisible(false);
        this.m_tree.addTreeSelectionListener(this);
        this.m_tree.getSelectionModel().setSelectionMode(1);
        this.m_tree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    JButton jButton;
                    TreePath treePath = OpenDataSetPage.this.m_tree.getSelectionPath();
                    if (treePath == null) {
                        return;
                    }
                    TreeItemTreeNode treeItemTreeNode = (TreeItemTreeNode)treePath.getLastPathComponent();
                    if (treeItemTreeNode.isLeaf() && (jButton = OpenDataSetPage.this.getRootPane().getDefaultButton()) != null) {
                        jButton.doClick();
                    }
                }
            }
        });
        this.m_tree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            }

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                TreePath treePath = treeExpansionEvent.getPath();
                TreeItemTreeNode treeItemTreeNode = (TreeItemTreeNode)treePath.getLastPathComponent();
                if (!treeItemTreeNode.isLeaf() && treeItemTreeNode.getChildCount() == 0) {
                    OpenDataSetPage.this.doBusy(new Runnable(this, treeItemTreeNode){
                        private final /* synthetic */ TreeItemTreeNode val$node;
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$node = treeItemTreeNode;
                        }

                        public void run() {
                            TreeItem treeItem = this.val$node.getTreeItem();
                            TreeItem[] treeItemArray = OpenDataSetPage.access$200(2.access$100(this.this$1)).getSubItems(treeItem);
                            this.val$node.addNodes(treeItemArray);
                            ((DefaultTreeModel)OpenDataSetPage.access$000(2.access$100(this.this$1)).getModel()).nodeStructureChanged(this.val$node);
                        }
                    });
                }
            }

            static /* synthetic */ OpenDataSetPage access$100(2 var0) {
                return var0.OpenDataSetPage.this;
            }
        });
        this.m_scrollPane.setViewportView(this.m_tree);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.doEnable();
    }

    protected boolean getFinishEnabled() {
        if (this.m_tree == null) {
            return false;
        }
        TreePath treePath = this.m_tree.getSelectionPath();
        if (treePath == null) {
            return false;
        }
        TreeItemTreeNode treeItemTreeNode = (TreeItemTreeNode)treePath.getLastPathComponent();
        return treeItemTreeNode.isLeaf();
    }

    public String getHelpTopic() {
        return "userInterface.newJobWizard.selectingARemoteDataSet";
    }

    static /* synthetic */ JASJobAdaptor access$200(OpenDataSetPage openDataSetPage) {
        return openDataSetPage.m_job;
    }
}

