/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import jas.swingstudio.Cut;
import jas.swingstudio.CutPropertiesDialog;
import jas.swingstudio.CutPropertiesPanel;
import jas.swingstudio.CutsManager;
import jas.swingstudio.JavaAnalysisStudio;
import jas.util.Application;
import jas.util.JASDialog;
import jas.util.JASState;
import jas.util.JASTextField;
import jas.util.ObjectFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

final class NewCutItemDialog
extends JASDialog
implements KeyListener {
    private final String[] m_cutClassNames = new String[]{"DoubleCut"};
    private CutsManager cuts;
    private Cut cut;
    private final JTextField m_nameField = new JASTextField();
    private final JComboBox m_classesBox = new JComboBox();

    NewCutItemDialog(CutsManager cutsManager) {
        super((Frame)Application.getApplication().getFrame(), "New Cut item", true, 13);
        this.cuts = cutsManager;
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        int n = 0;
        while (n < this.m_cutClassNames.length) {
            this.m_classesBox.addItem(this.m_cutClassNames[n]);
            ++n;
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        container.add((Component)new JLabel("Select a Cut subclass:"), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        container.add((Component)new JLabel("Supply a name for this cut:"), gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        container.add((Component)this.m_classesBox, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        container.add((Component)this.m_nameField, gridBagConstraints);
        this.pack();
        this.m_nameField.addKeyListener(this);
        this.setHelpTopic("userInterface.newCutDialog");
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.callEnable();
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    void clearTextField() {
        this.m_nameField.setText("");
    }

    private boolean nameIsUsed(String string) {
        Enumeration enumeration = this.cuts.elements();
        while (enumeration.hasMoreElements()) {
            if (!((Cut)enumeration.nextElement()).m_name.equals(string)) continue;
            return true;
        }
        return false;
    }

    protected void onOK() {
        String string = this.m_nameField.getText().replace(' ', '_');
        if (this.nameIsUsed(string)) {
            JOptionPane.showMessageDialog(Application.getApplication().getFrame(), "You cannot use a the same name for two cuts: " + string, "Error", 0);
        } else {
            String string2 = (String)this.m_classesBox.getSelectedItem();
            this.cut = new Cut();
            try {
                CutPropertiesPanel cutPropertiesPanel = (CutPropertiesPanel)new ObjectFactory(Class.forName("jas.cuts." + string2 + "Panel")).create();
                if (new CutSetupDialog(cutPropertiesPanel).doModal()) {
                    this.cut.m_type = string2;
                    this.cut.m_description = cutPropertiesPanel.getDescription(string);
                    if (this.cut.m_description == null) {
                        return;
                    }
                    this.cut.m_constructor = cutPropertiesPanel.getConstructor(string);
                    if (this.cut.m_constructor == null) {
                        return;
                    }
                    this.cut.m_name = string;
                    super.onOK();
                }
            }
            catch (Exception exception) {
                JavaAnalysisStudio.getApp().error("Could not load class.", exception);
            }
        }
    }

    Cut getCut() {
        return this.cut;
    }

    protected void enableOK(JASState jASState) {
        jASState.setEnabled(this.m_nameField.getText().length() > 0);
    }

    private final class CutSetupDialog
    extends JASDialog
    implements CutPropertiesDialog {
        private boolean m_changed = false;
        private CutPropertiesPanel m_panel;

        CutSetupDialog(CutPropertiesPanel cutPropertiesPanel) {
            super((Frame)Application.getApplication().getFrame(), "Cut setup");
            this.setContentPane(cutPropertiesPanel);
            this.m_panel = cutPropertiesPanel;
            cutPropertiesPanel.m_dialog = this;
            this.pack();
        }

        public void changeNotify(boolean bl) {
            if (!this.m_changed) {
                this.m_changed = true;
                this.callEnable();
            }
        }

        protected void enableOK(JASState jASState) {
            jASState.setEnabled(this.m_changed);
        }
    }
}

