/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import jas.jds.module.LocalDIM;
import jas.jds.module.NoSetupLocalDIM;
import jas.swingstudio.JASLocalJobBuilder;
import jas.swingstudio.JASRegistry;
import jas.swingstudio.JavaAnalysisStudio;
import jas.util.Finishable;
import jas.util.HasHelpPage;
import jas.util.HasNextPages;
import jas.util.JASWizardPage;
import jas.util.UserProperties;
import jas.util.WrappingTextArea;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

final class LocalJobPage
extends JASWizardPage
implements HasNextPages,
HasHelpPage,
Finishable,
ItemListener {
    private JASWizardPage[] m_nextPages;
    private JComboBox m_DIMs = new JComboBox();
    private JASLocalJobBuilder m_ljb;
    private final String m_lastLocalDIM_Key = "LastLocalDIM";
    private JavaAnalysisStudio m_app = JavaAnalysisStudio.getApp();
    private final UserProperties m_prop = this.m_app.getUserProperties();

    LocalJobPage() {
        super(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(new JLabel("Select a Data Interface Module (DIM): "));
        jPanel.add(this.m_DIMs);
        this.add("North", jPanel);
        WrappingTextArea wrappingTextArea = new WrappingTextArea("All Data Interface Modules (DIM) registered in the Local DIM registry are available as choices above.  To add or remove classes from the Local DIM registry, open the \"Option\" dialog from the \"View\" menu or from the popup menu, and select the \"Local DIM Registry\" tab.", false, this.getBackground(), new Dimension(400, 75));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(wrappingTextArea);
        this.add("Center", jPanel2);
    }

    LocalJobPage(JASLocalJobBuilder jASLocalJobBuilder) {
        this();
        this.setJobBuilder(jASLocalJobBuilder);
    }

    public void beforeShowing() {
        this.m_DIMs.addItemListener(this);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.doEnable();
    }

    public JASWizardPage[] getNextWizardPages() {
        Object object;
        LocalDIM[] localDIMArray = JASRegistry.getDIMs();
        this.m_nextPages = new JASWizardPage[localDIMArray.length];
        int n = 0;
        while (n < localDIMArray.length) {
            object = localDIMArray[n];
            this.m_nextPages[n] = object.getSetupPage();
            this.m_DIMs.addItem(object.toString());
            ++n;
        }
        try {
            object = this.m_prop.getString("LastLocalDIM", null);
            this.m_DIMs.setSelectedItem(object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.m_nextPages;
    }

    public JASWizardPage getNext() {
        int n = this.m_DIMs.getSelectedIndex();
        this.m_prop.setString("LastLocalDIM", (String)this.m_DIMs.getSelectedItem());
        JASWizardPage jASWizardPage = this.m_nextPages[n];
        LocalDIM localDIM = JASRegistry.getDIM(n);
        localDIM.setLocalJobBuilder(this.m_ljb);
        this.m_ljb.setDIM(localDIM);
        return jASWizardPage;
    }

    public void onFinish() {
        int n = this.m_DIMs.getSelectedIndex();
        this.m_prop.setString("LastLocalDIM", (String)this.m_DIMs.getSelectedItem());
        LocalDIM localDIM = JASRegistry.getDIM(n);
        localDIM.setLocalJobBuilder(this.m_ljb);
        this.m_ljb.setDIM(localDIM);
        ((NoSetupLocalDIM)localDIM).finish();
        this.dispose();
    }

    void setJobBuilder(JASLocalJobBuilder jASLocalJobBuilder) {
        this.m_ljb = jASLocalJobBuilder;
    }

    protected boolean getNextEnabled() {
        if (this.m_DIMs.getSelectedIndex() < 0) {
            return false;
        }
        return this.m_nextPages[this.m_DIMs.getSelectedIndex()] != null;
    }

    protected boolean getFinishEnabled() {
        if (this.m_DIMs.getSelectedIndex() < 0) {
            return false;
        }
        return this.m_nextPages[this.m_DIMs.getSelectedIndex()] == null;
    }

    public String getHelpTopic() {
        return "userInterface.newJobWizard.selectingALocalDataInterfaceModule";
    }
}

