/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import hep.analysis.EventSource;
import hep.analysis.PeerSupport;
import hep.analysis.peer.AnalysisApplication;
import hep.analysis.peer.JobPeer;
import jas.jds.module.LocalDIM;
import jas.jds.module.ModuleException;
import jas.job.AbstractJob;
import jas.job.AnalysisException;
import jas.job.JobJob;
import jas.job.LoaderException;
import jas.job.OpenJobException;
import jas.plugin.RunEvent;
import jas.plugin.RunListener;
import jas.swingstudio.JASJob;
import jas.swingstudio.JavaAnalysisStudio;
import jas.swingstudio.Job;
import jas.swingstudio.LocalClassLoader;
import jas.util.tree.SimpleNodeListener;
import jas.util.tree.TreeItem;
import java.io.EOFException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;

class LocalJob
extends AbstractJob
implements Job,
AnalysisApplication,
Serializable {
    private Vector m_runListeners = new Vector();
    private transient JavaAnalysisStudio m_app = JavaAnalysisStudio.getApp();
    private transient JASJob m_jasJob;
    private transient int m_maxEvents = 0;
    private transient BoundedRangeModel m_progress;
    private Vector m_loaded = new Vector();
    private int m_changes = 0;
    private LocalDIM m_DIM;
    private String m_dataSource;
    private String m_dataSetName;
    private String m_jobName;

    LocalJob(JASJob jASJob, String string) {
        super(string);
        this.m_jasJob = jASJob;
        this.m_progress = new DefaultBoundedRangeModel();
        this.m_app.setModel(this.m_progress);
        PeerSupport.setAnalysisApplication((AnalysisApplication)this);
        this.setHepAnalysisJob(new hep.analysis.Job(string));
        this.m_jobName = string;
        this.setClassLoader(new LocalClassLoader());
        this.getTreeRoot().addNodeListener(new SimpleNodeListener(){

            public void treeChanged(TreeItem treeItem) {
                if ((treeItem.flags & 2) != 0) {
                    LocalJob.this.m_jasJob.deleteNode(treeItem);
                } else {
                    LocalJob.this.m_jasJob.addNode(treeItem);
                }
                LocalJob.this.m_jasJob.updateTree();
            }
        });
    }

    LocalJob(JASJob jASJob, String string, LocalDIM localDIM, String string2) {
        this(jASJob, string);
        this.m_DIM = localDIM;
        this.m_dataSource = string2;
    }

    public hep.analysis.Job currentJob() {
        return this.getHepAnalysisJob();
    }

    public JobPeer createJobPeer(String string, hep.analysis.Job job) {
        return new JobJob(this);
    }

    public boolean open() throws ModuleException {
        if (this.m_DIM != null) {
            EventSource eventSource = this.m_DIM.openDataSet(this.m_dataSource);
            if (eventSource != null) {
                this.setEventSource(eventSource);
            }
            return true;
        }
        return false;
    }

    public boolean isLoaded(String string) {
        return this.m_loaded.contains(string);
    }

    public void reopen(ObjectInputStream objectInputStream, JASJob jASJob) throws OpenJobException {
        this.m_app = JavaAnalysisStudio.getApp();
        if (this.m_DIM != null) {
            this.m_DIM.setLocalJobBuilder(this.m_app.getLocalJobBuilder());
        }
        this.setClassLoader(new LocalClassLoader());
        this.m_jasJob = jASJob;
        this.m_progress = new DefaultBoundedRangeModel();
        this.m_app.setModel(this.m_progress);
        PeerSupport.setAnalysisApplication((AnalysisApplication)this);
        this.setHepAnalysisJob(new hep.analysis.Job(this.m_jobName));
        this.getTreeRoot().addNodeListener(new SimpleNodeListener(){

            public void treeChanged(TreeItem treeItem) {
                if ((treeItem.flags & 2) != 0) {
                    LocalJob.this.m_jasJob.deleteNode(treeItem);
                } else {
                    LocalJob.this.m_jasJob.addNode(treeItem);
                }
                LocalJob.this.m_jasJob.updateTree();
            }
        });
        Enumeration enumeration = this.m_loaded.elements();
        try {
            boolean bl;
            int n;
            String string;
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                super.loadObject(string);
            }
            if (this.m_DIM != null && (string = this.m_DIM.openDataSet(this.m_dataSource)) != null) {
                this.setEventSource((EventSource)string);
            }
            try {
                n = objectInputStream.readInt();
                bl = objectInputStream.readBoolean();
            }
            catch (EOFException eOFException) {
                n = 0;
                bl = false;
            }
            if (bl) {
                this.go(0);
            } else if (n > 0) {
                this.go(n);
            }
        }
        catch (Exception exception) {
            throw new OpenJobException(exception);
        }
    }

    public void save() {
    }

    public void loadObject(String string) throws LoaderException {
        super.loadObject(string);
        this.m_loaded.addElement(string);
    }

    public Class loadClientClass(String string) throws ClassNotFoundException {
        return this.m_app.getExtensionLoader().loadClass(string);
    }

    public OutputStream getLogStream() {
        return this.m_app.getOutputStream("Log Messages");
    }

    public OutputStream getErrorStream() {
        return this.m_app.getOutputStream("Error Messages");
    }

    public void reload() {
        this.setClassLoader(new LocalClassLoader());
        super.unloadAll();
        Enumeration enumeration = this.m_loaded.elements();
        try {
            while (enumeration.hasMoreElements()) {
                super.loadObject((String)enumeration.nextElement());
            }
        }
        catch (LoaderException loaderException) {
            this.m_app.error("Could not reload", loaderException);
        }
    }

    public void unloadAll() {
        this.setClassLoader(new LocalClassLoader());
        super.unloadAll();
        this.m_loaded.removeAllElements();
    }

    public void sendMessage(String string) {
        JavaAnalysisStudio.getApp().setMessage(string);
    }

    protected void reportError(AnalysisException analysisException) {
        JavaAnalysisStudio.getApp().error("Error running remote analysis (see Error Message window for details)");
    }

    public void notifyInfo() {
        this.m_jasJob.setCommandChanged();
        this.m_maxEvents = this.eventsTotal() > 0 ? this.eventsTotal() : 100;
        this.m_progress.setMaximum(this.m_maxEvents);
        this.m_progress.setValue(this.eventsAnalyzed());
        if (!this.m_runListeners.isEmpty()) {
            this.fireRunListeners(new RunEvent(this, this.isRunning() ? 3000 : 2999));
        }
    }

    public void notifyInfo(int n) {
        int n2 = n;
        if (n2 > this.m_maxEvents) {
            this.m_maxEvents *= 3;
            this.m_progress.setMaximum(this.m_maxEvents);
        }
        this.m_progress.setValue(n2);
    }

    public boolean isChanged() {
        return this.m_changes > 0;
    }

    public void addRunListener(RunListener runListener) {
        this.m_runListeners.addElement(runListener);
    }

    public void removeRunListener(RunListener runListener) {
        this.m_runListeners.removeElement(runListener);
    }

    private void fireRunListeners(RunEvent runEvent) {
        Enumeration enumeration = this.m_runListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((RunListener)enumeration.nextElement()).runStateChanged(runEvent);
        }
    }

    protected Thread createEventLoopThread(Runnable runnable) {
        Thread thread = super.createEventLoopThread(runnable);
        thread.setPriority(thread.getPriority() - 1);
        return thread;
    }
}

