/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import jas.jds.interfaces.Version;
import jas.swingstudio.JavaAnalysisStudio;
import jas.util.HasHelpPage;
import jas.util.HasNextPages;
import jas.util.JASDialog;
import jas.util.JASEditableComboBox;
import jas.util.JASWizardPage;
import jas.util.SpinBox;
import jas.util.UserProperties;
import jas.util.WrappingTextArea;
import jas.util.layout.PnutsLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

abstract class JDSWizard
extends JASWizardPage
implements HasNextPages,
HasHelpPage {
    int m_port = 1099;
    String m_service = Version.getService();
    boolean m_useRMIDefaults = true;
    InetAddress m_rmiIP;
    JASEditableComboBox m_server;
    private String[] m_lastServers;
    private final String m_lastServers_Key = "Servers";
    JavaAnalysisStudio m_app = JavaAnalysisStudio.getApp();
    final UserProperties m_prop = this.m_app.getUserProperties();
    static /* synthetic */ Class class$java$awt$Frame;

    JDSWizard() {
        super(new PnutsLayout("cols=2,expand=y"));
        String[] stringArray = new String[]{"sldnt0.slac.stanford.edu"};
        this.m_lastServers = this.m_prop.getStringArray("Servers", stringArray);
        this.m_server = new JASEditableComboBox(this.m_lastServers, true);
        JButton jButton = new JButton("Advanced Connection Options..."){

            public void fireActionPerformed(ActionEvent actionEvent) {
                AdvancedConnectDialog advancedConnectDialog = new AdvancedConnectDialog((Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = JDSWizard.class$("java.awt.Frame")) : class$java$awt$Frame, this));
                advancedConnectDialog.doModal();
            }
        };
        WrappingTextArea wrappingTextArea = new WrappingTextArea("Enter the name of a server that is running the Java Data Server code for Java Analysis Studio.  The server sldnt0.slac.stanford.edu is normally available for testing and contains some sample datasets. If your computer is running the Java Data Server code and you wish to access data on your computer, leave the text field blank.", false, this.getBackground(), new Dimension(400, 100));
        this.add(new JLabel("Server Name:"));
        this.add((Component)this.m_server, "halign=fill,expand=x");
        this.add((Component)jButton, "colspan=2,halign=right");
    }

    public String getHelpTopic() {
        return "userInterface.newJobWizard.selectingAJavaDataServer";
    }

    public void beforeShowing() {
        this.m_server.requestFocus();
    }

    void saveLastServer() {
        this.m_prop.setStringArray("Servers", UserProperties.updateStringArray(this.m_lastServers, this.m_server.getText()));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class AdvancedConnectDialog
    extends JASDialog
    implements ActionListener {
        private SpinBox portField;
        private JTextField serviceField;
        private JCheckBox rmiDefault;
        private JComboBox rmiIPAddress;
        private JLabel rmiIPLabel;

        AdvancedConnectDialog(Frame frame) {
            super(frame, "Advanced Connection Options...", true, 13);
            InetAddress[] inetAddressArray;
            Serializable serializable;
            this.setHelpTopic("userInterface.newJobWizard.advancedOptionsDialog");
            try {
                serializable = InetAddress.getLocalHost();
                inetAddressArray = InetAddress.getAllByName(((InetAddress)serializable).getHostName());
            }
            catch (UnknownHostException unknownHostException) {
                inetAddressArray = null;
            }
            this.portField = new SpinBox(JDSWizard.this.m_port, 1, 9999);
            this.serviceField = new JTextField(JDSWizard.this.m_service, 20);
            this.rmiDefault = new JCheckBox("Use RMI Defaults", JDSWizard.this.m_useRMIDefaults);
            this.rmiDefault.addActionListener(this);
            this.rmiIPAddress = new JComboBox<InetAddress>(inetAddressArray);
            this.rmiIPLabel = new JLabel("IP Address");
            if (JDSWizard.this.m_rmiIP != null) {
                this.rmiIPAddress.setSelectedItem(JDSWizard.this.m_rmiIP);
            }
            this.actionPerformed(null);
            serializable = new JPanel(new PnutsLayout(2, 2, 2));
            ((JComponent)serializable).setBorder(BorderFactory.createTitledBorder("Remote RMI Options"));
            ((Container)serializable).add(new JLabel("RMI Registry Port"), "halign=right");
            ((Container)serializable).add(this.portField, "halign=left");
            ((Container)serializable).add(new JLabel("Service Name"), "halign=right");
            ((Container)serializable).add(this.serviceField, "halign=left");
            JPanel jPanel = new JPanel(new PnutsLayout(2, 2, 2));
            jPanel.setBorder(BorderFactory.createTitledBorder("Local RMI Options"));
            jPanel.add((Component)this.rmiDefault, "colspan=2,halign=left");
            jPanel.add(this.rmiIPLabel);
            jPanel.add((Component)this.rmiIPAddress, "halign=left");
            JPanel jPanel2 = new JPanel(new PnutsLayout("cols=1,halign=fill"));
            jPanel2.add((Component)serializable);
            jPanel2.add(jPanel);
            this.setContentPane(jPanel2);
            this.pack();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = !this.rmiDefault.isSelected();
            this.rmiIPAddress.setEnabled(bl);
            this.rmiIPLabel.setEnabled(bl);
        }

        public void onOK() {
            JDSWizard.this.m_port = this.portField.getValue();
            JDSWizard.this.m_service = this.serviceField.getText();
            JDSWizard.this.m_useRMIDefaults = this.rmiDefault.isSelected();
            JDSWizard.this.m_rmiIP = (InetAddress)this.rmiIPAddress.getSelectedItem();
            if (!JDSWizard.this.m_useRMIDefaults) {
                System.getProperties().put("java.rmi.server.hostname", JDSWizard.this.m_rmiIP.getHostAddress());
            } else {
                System.getProperties().remove("java.rmi.server.hostname");
            }
            super.onOK();
        }
    }
}

