/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import hep.analysis.NamedObject;
import jas.hist.DataSource;
import jas.jds.interfaces.RemotePlotAccess;
import jas.job.PlotAccess;
import jas.swingstudio.JASRebinAdaptor;
import jas.swingstudio.JavaAnalysisStudio;
import jas.util.rmi.RMIDestination;
import jas.util.rmi.RMIEventDelivery;
import java.rmi.RemoteException;

class JASPlotAccessAdaptor
implements PlotAccess {
    private boolean gotConstraints = false;
    private double[] constraints;
    private RemotePlotAccess m_remote;
    private RMIEventDelivery m_ed;
    private JavaAnalysisStudio app = JavaAnalysisStudio.getApp();

    public JASPlotAccessAdaptor(RemotePlotAccess remotePlotAccess, RMIEventDelivery rMIEventDelivery) {
        this.m_remote = remotePlotAccess;
        this.m_ed = rMIEventDelivery;
    }

    public void delete() {
        try {
            this.m_remote.delete();
        }
        catch (RemoteException remoteException) {
            this.app.error("Network Error", remoteException);
        }
    }

    public void rename(String string) throws NamedObject.RenameException {
        try {
            this.m_remote.rename(string);
        }
        catch (RemoteException remoteException) {
            this.app.error("Network Error", remoteException);
        }
    }

    public int getNDataSources() {
        try {
            return this.m_remote.getNDataSources();
        }
        catch (RemoteException remoteException) {
            this.app.error("Network Error", remoteException);
            return 0;
        }
    }

    public DataSource getData(int n) {
        try {
            RMIDestination rMIDestination = this.m_ed.getRMIDestination();
            return JASRebinAdaptor.getAdaptor(this.m_remote.getData(n, rMIDestination), this.m_ed, rMIDestination);
        }
        catch (RemoteException remoteException) {
            this.app.error("Network Error", remoteException);
            return null;
        }
    }

    public boolean isConstrained() {
        try {
            if (!this.gotConstraints) {
                this.constraints = this.m_remote.getConstraints();
                this.gotConstraints = true;
            }
            return this.constraints != null;
        }
        catch (RemoteException remoteException) {
            this.app.error("Network Error", remoteException);
            return false;
        }
    }

    public double getX() {
        return this.constraints[0];
    }

    public double getY() {
        return this.constraints[1];
    }

    public double getWidth() {
        return this.constraints[2];
    }

    public double getHeight() {
        return this.constraints[3];
    }
}

