/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import jas.swingstudio.JASConsoleDocumentUtilities;
import jas.swingstudio.JASConsoleScrollPane;
import jas.swingstudio.JASConsoleTabbedPane;
import java.io.IOException;
import java.io.Writer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class JASConsoleDocumentWriter
extends Writer {
    private String theScrollPaneName;
    private Document theDocument;
    private AttributeSet theAttributeSet;
    private JASConsoleTabbedPane theTabbedPane;

    public JASConsoleDocumentWriter(Document document, AttributeSet attributeSet, String string, JASConsoleTabbedPane jASConsoleTabbedPane) {
        this.theDocument = document;
        this.theAttributeSet = attributeSet;
        this.theScrollPaneName = string;
        this.theTabbedPane = jASConsoleTabbedPane;
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        this.write(new String(cArray, n, n2));
    }

    public void write(String string, int n, int n2) throws IOException {
        this.write(string.substring(n, n2));
    }

    public void write(String string) throws IOException {
        if (this.theDocument == null) {
            throw new IOException("Writer was closed");
        }
        try {
            int n = this.theTabbedPane.indexOfTab(this.theScrollPaneName);
            if (n != -1) {
                this.theTabbedPane.setSelectedIndex(n);
            } else {
                JASConsoleScrollPane jASConsoleScrollPane = this.theTabbedPane.getSelectedConsoleScrollPane();
                JASConsoleScrollPane jASConsoleScrollPane2 = new JASConsoleScrollPane(this.theScrollPaneName, this.theTabbedPane);
                this.theTabbedPane.addTab(this.theScrollPaneName, jASConsoleScrollPane2);
                n = this.theTabbedPane.indexOfTab(this.theScrollPaneName);
                this.theTabbedPane.setSelectedIndex(n);
                jASConsoleScrollPane2.getTheTextArea().setDocument(this.theDocument);
                jASConsoleScrollPane2.setOutputAttributes(this.theAttributeSet);
            }
            this.theDocument.insertString(this.theDocument.getLength(), string, this.theAttributeSet);
            this.appendToLog(string);
            JASConsoleDocumentUtilities.trimDoc(this.theDocument);
            this.theTabbedPane.getSelectedConsoleScrollPane().scrollToEnd();
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException.getMessage());
        }
    }

    public void flush() throws IOException {
        if (this.theDocument == null) {
            throw new IOException("Writer was closed");
        }
    }

    public void close() throws IOException {
        this.theDocument = null;
    }

    private void appendToLog(String string) {
        JASConsoleScrollPane jASConsoleScrollPane = this.theTabbedPane.getSelectedConsoleScrollPane();
        if (jASConsoleScrollPane != null && jASConsoleScrollPane.getTheTextArea().isLoggingOn()) {
            try {
                jASConsoleScrollPane.getTheTextArea().getLogWriter().write(string);
                jASConsoleScrollPane.getTheTextArea().getLogWriter().flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

