/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import jas.swingstudio.JASList;
import jas.swingstudio.JASListModel;
import jas.util.JASIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class JASAddRemovePanel
extends JPanel
implements ListSelectionListener,
ActionListener {
    private JASListModel model;
    private JList list;
    private String addText;
    private JButton up = new JButton(JASIcon.create(this, "images/up.gif"));
    private JButton down = new JButton(JASIcon.create(this, "images/down.gif"));
    private JButton delete = new JButton(JASIcon.create(this, "images/delete.gif"));
    private JButton add = new JButton(JASIcon.create(this, "images/new2.gif"));

    JASAddRemovePanel(JASList jASList, String string, String string2, String string3, ListCellRenderer listCellRenderer) {
        this(jASList, string, string2, string3);
        this.list.setCellRenderer(listCellRenderer);
    }

    JASAddRemovePanel(JASList jASList, String string, String string2, String string3) {
        super(new BorderLayout());
        if (string2 != null) {
            this.setBorder(BorderFactory.createTitledBorder(string2));
        }
        this.model = new JASListModel(jASList);
        this.list = new JList(this.model);
        this.addText = string3;
        Box box = Box.createVerticalBox();
        box.add(this.up);
        box.add(this.down);
        box.add(this.delete);
        box.add(this.add);
        this.up.addActionListener(this);
        this.down.addActionListener(this);
        this.delete.addActionListener(this);
        this.add.addActionListener(this);
        Insets insets = new Insets(0, 0, 0, 0);
        this.up.setMargin(insets);
        this.down.setMargin(insets);
        this.delete.setMargin(insets);
        this.add.setMargin(insets);
        this.up.setToolTipText("Move item up");
        this.down.setToolTipText("Move item down");
        this.delete.setToolTipText("Delete item");
        this.add.setToolTipText("New item");
        this.list.addListSelectionListener(this);
        if (string != null) {
            this.add((Component)new JLabel(string), "North");
        }
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.setPreferredSize(new Dimension(100, 40));
        this.add((Component)jScrollPane, "Center");
        this.add((Component)box, "East");
        this.setSensitive();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int n = this.list.getSelectedIndex();
        if (object == this.up) {
            this.model.swap(n, n - 1);
            this.list.setSelectedIndex(n - 1);
        } else if (object == this.down) {
            this.model.swap(n, n + 1);
            this.list.setSelectedIndex(n + 1);
        } else if (object == this.delete) {
            this.model.delete(n);
        } else if (object == this.add) {
            Object object2 = this.add(this.addText);
            if (object2 instanceof Object[]) {
                Object[] objectArray = (Object[])object2;
                int n2 = 0;
                while (n2 < objectArray.length) {
                    this.model.add(objectArray[n2]);
                    ++n2;
                }
            } else if (object2 != null) {
                this.model.add(object2);
            }
        }
        this.setSensitive();
    }

    protected Object add(String string) {
        return JOptionPane.showInputDialog(this, (Object)string);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.setSensitive();
    }

    private void setSensitive() {
        boolean bl = this.isEnabled();
        int n = this.list.getSelectedIndex();
        this.delete.setEnabled(bl && n >= 0);
        this.up.setEnabled(bl && n > 0);
        this.down.setEnabled(bl && n >= 0 && n < this.model.getSize() - 1);
        this.add.setEnabled(bl);
        this.list.setEnabled(bl);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.setSensitive();
    }

    public void update() {
        this.model.update();
    }

    void addListDataListener(ListDataListener listDataListener) {
        this.model.addListDataListener(listDataListener);
    }

    void setModel(JASList jASList) {
        this.model = new JASListModel(jASList);
        this.list.setModel(this.model);
    }
}

