/*
 * Decompiled with CFR 0.152.
 */
package jas.server;

import hep.analysis.Job;
import hep.analysis.PeerSupport;
import hep.analysis.peer.AnalysisApplication;
import hep.analysis.peer.JobPeer;
import jas.jds.JDSJob;
import jas.jds.RMIProtocol;
import jas.jds.RMIWebServer;
import jas.jds.interfaces.PluginEvent;
import jas.job.JobJob;
import jas.server.HistogramServerException;
import jas.server.MessageEvent;
import jas.server.MessageListener;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;

public class HistogramServer
implements AnalysisApplication {
    private Vector m_listeners = new Vector();
    private Vector m_plugins = new Vector();
    private JDSJob m_job;

    public HistogramServer(String string) throws HistogramServerException {
        this(string, new String[0]);
    }

    public HistogramServer(String string, String[] stringArray) throws HistogramServerException {
        PeerSupport.setAnalysisApplication((AnalysisApplication)this);
        Job job = new Job(string);
        try {
            String[] stringArray2 = new String[]{"."};
            RMIWebServer.main(stringArray2);
            RMIProtocol.main(stringArray);
        }
        catch (Exception exception) {
            throw new HistogramServerException("Cataclysmic error during HistogramServer initialization", exception);
        }
    }

    public JobPeer createJobPeer(String string, Job job) {
        String string2;
        String string3;
        if (this.m_job != null) {
            throw new HistogramServerException("Job creation not allowed", null);
        }
        this.m_job = new JDSJob(string, job){

            public void close() {
                this.setState("Disconnected");
            }

            public void receiveMessage(Object object) {
                HistogramServer.this.fireMessageReceived(new MessageEvent(this, object));
            }

            public void listItems() {
                super.listItems();
                Enumeration enumeration = HistogramServer.this.m_plugins.elements();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    this.notifyObservers(new PluginEvent(string));
                }
            }
        };
        try {
            string3 = System.getProperty("user.name");
        }
        catch (Exception exception) {
            string3 = "unknown";
        }
        try {
            string2 = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            string2 = "unknown";
        }
        this.m_job.setOwner(string3, string2);
        return new JobJob(this.m_job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void fireMessageReceived(MessageEvent messageEvent) {
        if (!this.m_listeners.isEmpty()) {
            Enumeration enumeration;
            Object object;
            Vector vector = this.m_listeners;
            synchronized (vector) {
                object = (Vector)this.m_listeners.clone();
                enumeration = ((Vector)object).elements();
            }
            while (enumeration.hasMoreElements()) {
                object = (MessageListener)enumeration.nextElement();
                object.messageReceived(messageEvent);
            }
        }
    }

    public void addPlugin(String string) {
        this.m_plugins.addElement(string);
    }

    public void addMessageListener(MessageListener messageListener) {
        this.m_listeners.addElement(messageListener);
    }

    public void removeMessageListener(MessageListener messageListener) {
        this.m_listeners.removeElement(messageListener);
    }

    public Job currentJob() {
        return this.m_job.getHepAnalysisJob();
    }

    public OutputStream getLogStream() {
        return this.m_job.getLogStream();
    }
}

