/*
 * Decompiled with CFR 0.152.
 */
package jas.plot;

import jas.plot.PrintHelper;
import jas.util.border.ShadowBorder;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class PlotComponent
extends JComponent {
    public static final int OTHER = -1;
    public static final int NONE = 0;
    public static final int BEVEL_IN = 1;
    public static final int BEVEL_OUT = 2;
    public static final int ETCHED = 3;
    public static final int LINE = 4;
    public static final int SHADOW = 5;
    private boolean paintBackground;

    public PlotComponent() {
    }

    public PlotComponent(LayoutManager layoutManager) {
        this.setLayout(layoutManager);
    }

    public void paintComponent(Graphics graphics) {
        if (this.paintBackground && !PrintHelper.isPrinting()) {
            Insets insets = this.getInsets();
            graphics.setColor(this.getBackground());
            graphics.fillRect(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.paintBackground = color != null;
    }

    public boolean isPaintingBackground() {
        return this.paintBackground;
    }

    public void setBorderType(int n) {
        this.setBorder(PlotComponent.createBorder(n));
    }

    public int getBorderType() {
        return PlotComponent.getBorderType(this.getBorder());
    }

    static Border createBorder(int n) {
        switch (n) {
            case 1: {
                return BorderFactory.createLoweredBevelBorder();
            }
            case 2: {
                return BorderFactory.createRaisedBevelBorder();
            }
            case 3: {
                return BorderFactory.createEtchedBorder();
            }
            case 5: {
                return ShadowBorder.createShadowBorder();
            }
            case 4: {
                return BorderFactory.createLineBorder(Color.black);
            }
        }
        return null;
    }

    static int getBorderType(Border border) {
        if (border == null) {
            return 0;
        }
        if (border == BorderFactory.createLoweredBevelBorder()) {
            return 1;
        }
        if (border == BorderFactory.createRaisedBevelBorder()) {
            return 2;
        }
        if (border == BorderFactory.createEtchedBorder()) {
            return 3;
        }
        if (border instanceof LineBorder) {
            return 4;
        }
        if (border instanceof ShadowBorder) {
            return 5;
        }
        return -1;
    }
}

