/*
 * Decompiled with CFR 0.152.
 */
package jas.plot;

import jas.plot.AxisLabel;
import jas.plot.AxisType;
import jas.plot.CoordinateTransformation;
import jas.plot.DoubleCoordinateTransformation;
import jas.plot.DoubleNumberFormatter;
import jas.plot.PlotGraphics;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class DoubleAxis
extends AxisType
implements DoubleCoordinateTransformation {
    private final StringBuffer b = new StringBuffer();
    private final double log10 = Math.log(10.0);
    private final int majorTickLength = 5;
    private final int minorTickLength = 3;
    private final int maxCharsPerLabel = 5;
    private final int minSpaceBetweenLabels = 3;
    private final int minNumberOfDivisions = 1;
    private int nDivisions = 0;
    private double data_min = 0.0;
    private double data_max = 1.0;
    private double plot_min = 0.0;
    private double plot_max = 1.0;
    private AxisLabel[] labels;
    private double[] minorTickPositions;
    private boolean logarithmic;
    private int scale_power;
    private boolean useSuggestedRange = false;
    private boolean tryForNewLabelsOnExpansion;
    private boolean hideMinorTicks = false;

    public DoubleAxis() {
        this(false);
    }

    public DoubleAxis(boolean bl) {
        this.logarithmic = bl;
    }

    public void setLogarithmic(boolean bl) {
        if (this.logarithmic != bl) {
            this.labelsValid = false;
            this.logarithmic = bl;
            if (this.axis != null) {
                this.axis.revalidate();
            }
        }
    }

    public boolean isLogarithmic() {
        return this.logarithmic;
    }

    public void setUseSuggestedRange(boolean bl) {
        if (this.useSuggestedRange != bl) {
            this.labelsValid = false;
            this.useSuggestedRange = bl;
            if (this.axis != null) {
                this.axis.revalidate();
            }
        }
    }

    public boolean getUseSuggestedRange() {
        return this.useSuggestedRange;
    }

    public void setMin(double d) {
        if (this.data_min != d) {
            this.labelsValid = false;
            this.data_min = d;
            this.plot_min = d;
            if (this.axis != null) {
                this.axis.revalidate();
            }
        }
    }

    public void setMax(double d) {
        if (this.data_max != d) {
            this.labelsValid = false;
            this.data_max = d;
            this.plot_max = d;
            if (this.axis != null) {
                this.axis.revalidate();
            }
        }
    }

    public double getPlotMin() {
        return this.plot_min;
    }

    public double getPlotMax() {
        return this.plot_max;
    }

    public double getDataMin() {
        return this.data_min;
    }

    public double getDataMax() {
        return this.data_max;
    }

    private int stringWidth(FontMetrics fontMetrics, String string) {
        if (string.startsWith("e")) {
            return fontMetrics.stringWidth(string) + fontMetrics.stringWidth("10") - fontMetrics.charWidth('e');
        }
        return fontMetrics.stringWidth(string);
    }

    private int round(double d, boolean bl) {
        block3: {
            double d2;
            block2: {
                d2 = Math.round(d);
                if (d == d2) break block2;
                double d3 = Math.abs(d - d2);
                double d4 = d != 0.0 ? 1.0E-4 * Math.abs(d) : 1.0E-6;
                if (!(d3 < d4)) break block3;
            }
            return (int)d2;
        }
        return bl ? (int)Math.floor(d) : (int)Math.ceil(d);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean areEqual(double d, double d2) {
        if (d == d2) return true;
        double d3 = Math.abs(d2 - d);
        double d4 = d != 0.0 ? 1.0E-4 * d : 1.0E-6;
        if (!(d3 < Math.abs(d4))) return false;
        return true;
    }

    private int charsReq(int n) {
        if (n < 0) {
            return -n + 2;
        }
        return n + 1;
    }

    private void createNewLabels(int n) {
        this.labelsValid = true;
        double d = this.data_max == 0.0 ? 0.0 : Math.log(Math.abs(this.data_max)) / this.log10;
        int n2 = (int)Math.floor(d);
        this.scale_power = 0;
        if (n2 >= 5) {
            this.scale_power = n2;
        } else if (n2 <= -5) {
            this.scale_power = n2;
        }
        DoubleNumberFormatter doubleNumberFormatter = new DoubleNumberFormatter(this.scale_power);
        if (this.logarithmic) {
            double d2 = this.data_min == 0.0 ? 0.0 : Math.log(Math.abs(this.data_min)) / this.log10;
            int n3 = this.round(d2, this.useSuggestedRange);
            int n4 = this.round(d, !this.useSuggestedRange);
            int n5 = n4 - n3 + 1;
            if (n5 < (this.useSuggestedRange ? 3 : 2)) {
                this.tryForNewLabelsOnExpansion = true;
                this.minorTickPositions = null;
                int n6 = (int)Math.floor(Math.log(this.data_max - this.data_min) / this.log10) - (n > 40 ? 2 : 1);
                if (this.scale_power > 0 || n6 < 0) {
                    doubleNumberFormatter.setFractionDigits(this.scale_power - n6);
                } else {
                    doubleNumberFormatter.setFractionDigits(0);
                }
                double d3 = Math.pow(10.0, n6);
                this.nDivisions = Math.max(n, 2);
                if (this.useSuggestedRange) {
                    this.plot_min = Math.floor(this.data_min / d3) * d3;
                    this.plot_max = Math.ceil(this.data_max / d3) * d3;
                    d2 = Math.log(this.plot_min) / this.log10;
                    d = Math.log(this.plot_max) / this.log10;
                    this.labels = new AxisLabel[this.nDivisions];
                } else {
                    this.plot_min = this.data_min;
                    this.plot_max = this.data_max;
                    double d4 = Math.ceil(Math.pow(10.0, d) / d3) * d3;
                    this.labels = d4 < this.data_max || this.areEqual(d4, this.data_max) ? new AxisLabel[this.nDivisions] : new AxisLabel[this.nDivisions - 1];
                }
                int n7 = 0;
                while (n7 < this.labels.length) {
                    double d5 = Math.ceil(Math.pow(10.0, (double)n7 * (d - d2) / (double)(this.nDivisions - 1) + d2) / d3) * d3;
                    this.labels[n7] = new AxisLabel();
                    this.labels[n7].text = doubleNumberFormatter.format(d5);
                    this.labels[n7].position = (Math.log(d5) / this.log10 - d2) / (d - d2);
                    ++n7;
                }
            } else {
                int n8;
                int n9;
                int n10;
                this.scale_power = 0;
                int n11 = n5;
                int n12 = 1;
                if (this.useSuggestedRange) {
                    d2 = n3;
                    d = n4;
                    this.plot_min = Math.pow(10.0, n3);
                    this.plot_max = Math.pow(10.0, n4);
                } else {
                    this.plot_min = this.data_min;
                    this.plot_max = this.data_max;
                }
                if (n5 > n && n > 1) {
                    this.tryForNewLabelsOnExpansion = true;
                    while (n12 + 1 < n5 && n5 / n12 >= n - 1) {
                        ++n12;
                    }
                    if (n12 != 1) {
                        n11 = n5 / n12;
                        if (this.useSuggestedRange) {
                            n10 = (n4 - n3) % n12;
                            if (n10 != 0) {
                                this.plot_max = Math.pow(10.0, n4 += n12 - n10);
                                d = n4;
                            }
                            ++n11;
                        }
                        if (n3 + n11 * n12 <= n4) {
                            ++n11;
                        }
                    }
                } else {
                    this.tryForNewLabelsOnExpansion = false;
                }
                this.nDivisions = n11;
                this.labels = new AxisLabel[n11];
                if (this.charsReq(n3) > 5 || this.charsReq(n4) > 5) {
                    n10 = n3;
                    n9 = 0;
                    while (n9 < n11) {
                        this.labels[n9] = new AxisLabel();
                        this.labels[n9].text = "e".concat(String.valueOf(n10));
                        this.labels[n9].position = ((double)n10 - d2) / (d - d2);
                        n10 += n12;
                        ++n9;
                    }
                } else if (n3 >= 0) {
                    this.b.setLength(0);
                    this.b.append('1');
                    n10 = 0;
                    while (n10 < n3) {
                        this.b.append('0');
                        ++n10;
                    }
                    n9 = 0;
                    while (n9 < n11) {
                        this.labels[n9] = new AxisLabel();
                        this.labels[n9].text = this.b.toString();
                        this.labels[n9].position = ((double)(n9 * n12 + n3) - d2) / (d - d2);
                        n8 = 0;
                        while (n8 < n12) {
                            this.b.append('0');
                            ++n8;
                        }
                        ++n9;
                    }
                } else if (n4 < 0) {
                    this.b.setLength(0);
                    this.b.append("0.1");
                    n10 = n4;
                    while (n10 > -1) {
                        this.b.insert(2, '0');
                        --n10;
                    }
                    n9 = n11 - 1;
                    while (n9 >= 0) {
                        this.labels[n9] = new AxisLabel();
                        this.labels[n9].text = this.b.toString();
                        this.labels[n9].position = ((double)(n9 * n12 + n3) - d2) / (d - d2);
                        n8 = 0;
                        while (n8 < n12) {
                            this.b.insert(2, '0');
                            ++n8;
                        }
                        --n9;
                    }
                } else {
                    n10 = n3;
                    n9 = 0;
                    while (n9 < n11) {
                        this.b.setLength(0);
                        if (n10 < 0) {
                            this.b.append("0.");
                            n8 = -1;
                            while (n8 > n10) {
                                this.b.append('0');
                                --n8;
                            }
                            this.b.append('1');
                        } else {
                            this.b.append('1');
                            n8 = 0;
                            while (n8 < n10) {
                                this.b.append('0');
                                ++n8;
                            }
                        }
                        this.labels[n9] = new AxisLabel();
                        this.labels[n9].text = this.b.toString();
                        this.labels[n9].position = ((double)n10 - d2) / (d - d2);
                        n10 += n12;
                        ++n9;
                    }
                }
                if (n12 == 1) {
                    double d6 = this.areEqual(n3, d2) ? this.plot_min : Math.pow(10.0, n3 - 1);
                    double d7 = this.plot_min / d6;
                    double d8 = Math.ceil(d7);
                    int n13 = d8 > d7 ? (int)d8 : (int)d8 + 1;
                    int n14 = (n4 - n3) * 8;
                    if (!this.useSuggestedRange) {
                        n14 += (int)((Math.pow(10.0, n3) - this.data_min) / Math.pow(10.0, n3 - 1));
                        n14 += (int)((this.data_max - Math.pow(10.0, n4)) / Math.pow(10.0, n4));
                    }
                    this.minorTickPositions = new double[n14];
                    int n15 = 0;
                    while (n15 < n14) {
                        if (n13 > 9) {
                            n13 = 2;
                            d6 *= 10.0;
                        }
                        this.minorTickPositions[n15] = (Math.log((double)n13 * d6) / this.log10 - d2) / (d - d2);
                        ++n13;
                        ++n15;
                    }
                } else {
                    this.minorTickPositions = null;
                    n10 = Math.min(6, n12);
                    while (n10 > 1) {
                        if (n12 % n10 == 0) {
                            n9 = n12 / n10;
                            n8 = (n10 - 1) * (n4 - n3) / n12;
                            int n16 = n3 + n9;
                            this.minorTickPositions = new double[n8];
                            int n17 = 0;
                            while (n17 < n8) {
                                if ((n16 - n3) % n12 == 0) {
                                    n16 += n9;
                                }
                                this.minorTickPositions[n17] = ((double)n16 - d2) / (d - d2);
                                n16 += n9;
                                ++n17;
                            }
                            break;
                        }
                        --n10;
                    }
                }
            }
        } else {
            double d9;
            int n18;
            int n19;
            int n20;
            int n21;
            this.tryForNewLabelsOnExpansion = true;
            this.minorTickPositions = null;
            double d10 = this.data_max - this.data_min;
            double d11 = Math.floor(Math.log(d10) / this.log10) - 1.0;
            int n22 = 0;
            if (this.scale_power > 0) {
                n22 = this.scale_power - (int)d11;
            } else if (d11 < -0.5) {
                n22 = this.scale_power - (int)d11;
            }
            double d12 = Math.pow(10.0, d11);
            int n23 = this.round(this.data_min / d12, this.useSuggestedRange);
            int n24 = this.round(this.data_max / d12, !this.useSuggestedRange);
            if (this.useSuggestedRange) {
                this.plot_min = (double)n23 * d12;
                this.plot_max = (double)n24 * d12;
            } else {
                this.plot_min = this.data_min;
                this.plot_max = this.data_max;
            }
            int n25 = n24 - n23;
            int n26 = 1;
            if (n25 < n) {
                float f = (float)n25 / (float)n;
                n21 = 0;
                if (f < 0.5f) {
                    int[] nArray = new int[]{2, 4, 5, 10, 20};
                    n20 = 0;
                    while (n20 < nArray.length) {
                        n19 = nArray[n20];
                        if (!((double)(f * (float)n19) <= 1.0)) break;
                        n21 = 1;
                        n26 = n19;
                        ++n20;
                    }
                }
                if (n21 != 0) {
                    n18 = this.useSuggestedRange ? n25 * n26 : n25 * n26 + (int)((this.plot_max / d12 - (double)n24) * (double)n26);
                    if (d11 < 0.5 || this.scale_power > 0) {
                        ++n22;
                    }
                    if (!(n26 != 4 && n26 != 20 || !(d11 < 1.5) && this.scale_power <= 0)) {
                        ++n22;
                    }
                } else {
                    n18 = Math.max(n25, 1);
                }
            } else if (n25 > n) {
                n18 = 1;
                int[] nArray = new int[]{2, 5, 10, 20, 25, 50};
                n21 = 0;
                while (n21 < nArray.length) {
                    int n27 = n25 / nArray[n21];
                    if (n27 <= n) {
                        n26 = nArray[n21];
                        n18 = n27;
                        if (this.useSuggestedRange) {
                            n20 = 0;
                            if (n23 % n26 != 0) {
                                n23 -= n23 % n26;
                                this.plot_min = (double)n23 * d12;
                                n20 = 1;
                            }
                            if (n24 % n26 != 0) {
                                n24 += n26 - n24 % n26;
                                this.plot_max = (double)n24 * d12;
                                n20 = 1;
                            }
                            if (n20 != 0) {
                                n18 = (n24 - n23) / n26;
                            }
                        }
                        if (n26 >= 10 && n26 != 25 && n22 > 0) {
                            --n22;
                        }
                        if (n23 % n26 != 0) {
                            int n28 = n20 = n23 > 0 ? n26 - n23 % n26 : -n23 % n26;
                            if (n20 > n24 - (n24 - n23) / n26 * n26 - n23) {
                                --n18;
                            }
                            n23 += n20;
                        }
                        break;
                    }
                    ++n21;
                }
            } else {
                n18 = Math.max(n25, 1);
            }
            double d13 = (double)n23 * d12;
            double d14 = d9 = n25 < n ? d12 / (double)n26 : d12 * (double)n26;
            if (n25 < n && d13 - d9 >= this.plot_min) {
                n19 = (int)((d13 - d9) / d9);
                d13 -= (double)n19 * d9;
                n18 += n19;
            }
            this.labels = new AxisLabel[n18 + 1];
            this.nDivisions = n18;
            doubleNumberFormatter.setFractionDigits(n22);
            n19 = 0;
            while (n19 < this.labels.length) {
                double d15 = d13 + (double)n19 * d9;
                this.labels[n19] = new AxisLabel();
                this.labels[n19].text = doubleNumberFormatter.format(d15);
                this.labels[n19].position = (d15 - this.plot_min) / (this.plot_max - this.plot_min);
                ++n19;
            }
        }
    }

    private int calculateMaxNDivisions(FontMetrics fontMetrics, int n) {
        int n2 = this.axis.getAxisOrientation() == 2 ? n / (fontMetrics.charWidth('5') * 5 + 3) : n / (fontMetrics.getHeight() + 3);
        return Math.max(1, n2);
    }

    private int getPowerOffset(FontMetrics fontMetrics) {
        return fontMetrics.getAscent() / 2;
    }

    void assumeAxisLength(int n) {
        Font font = this.axis.getFont();
        FontMetrics fontMetrics = this.axis.getToolkit().getFontMetrics(font);
        int n2 = this.calculateMaxNDivisions(fontMetrics, n);
        if (!this.labelsValid || this.labels == null || this.nDivisions < 2 || this.nDivisions > n2 || this.tryForNewLabelsOnExpansion && this.nDivisions < n2 / 2) {
            this.createNewLabels(n2);
        }
        this.hideMinorTicks = this.minorTickPositions == null || this.nDivisions > n2 / 3;
        int n3 = (int)((1.0 - this.labels[this.labels.length - 1].position) * (double)n);
        if (this.axis.getAxisOrientation() == 1) {
            this.spaceRequirements.width = this.longestStringLength(fontMetrics, this.labels) + 7;
            this.spaceRequirements.flowPastEnd = fontMetrics.getMaxAscent() - fontMetrics.getAscent() / 2 - n3;
            if (this.logarithmic && this.labels[0].text.startsWith("e")) {
                this.spaceRequirements.width += fontMetrics.stringWidth("10") - fontMetrics.charWidth('e');
                this.spaceRequirements.flowPastEnd += fontMetrics.getHeight() / 2;
            }
            if (this.scale_power != 0) {
                this.spaceRequirements.width = Math.max(fontMetrics.stringWidth("x10") + fontMetrics.stringWidth(String.valueOf(this.scale_power)), this.spaceRequirements.width);
                this.spaceRequirements.flowPastEnd += 3;
                if (this.spaceRequirements.flowPastEnd < 0) {
                    this.spaceRequirements.flowPastEnd = 0;
                }
                this.spaceRequirements.flowPastEnd += fontMetrics.getHeight() / 2 + fontMetrics.getAscent();
            } else if (this.spaceRequirements.flowPastEnd < 0) {
                this.spaceRequirements.flowPastEnd = 0;
            }
            int n4 = this.isLogarithmic() && this.labels[0].text.startsWith("e") ? fontMetrics.getHeight() / 2 + fontMetrics.getAscent() : fontMetrics.getAscent();
            this.spaceRequirements.height = Math.max(n4 / 2 - (int)(this.labels[0].position * (double)n), 0);
        } else {
            this.spaceRequirements.width = Math.max(this.stringWidth(fontMetrics, this.labels[0].text) / 2 - (int)(this.labels[0].position * (double)n), 0);
            this.spaceRequirements.flowPastEnd = this.stringWidth(fontMetrics, this.labels[this.labels.length - 1].text) / 2 - n3;
            int n5 = this.isLogarithmic() && this.labels[0].text.startsWith("e") ? fontMetrics.getHeight() / 2 + fontMetrics.getMaxAscent() + fontMetrics.getDescent() : fontMetrics.getMaxAscent() + fontMetrics.getDescent();
            this.spaceRequirements.height = n5 + 7;
            if (this.scale_power != 0) {
                this.spaceRequirements.height = Math.max(fontMetrics.getHeight() / 2 + fontMetrics.getAscent() + this.getPowerOffset(fontMetrics), this.spaceRequirements.height);
                this.spaceRequirements.flowPastEnd += 3;
                if (this.spaceRequirements.flowPastEnd < 0) {
                    this.spaceRequirements.flowPastEnd = 0;
                }
                this.spaceRequirements.flowPastEnd += fontMetrics.stringWidth("x10") + fontMetrics.stringWidth(String.valueOf(this.scale_power));
            } else if (this.spaceRequirements.flowPastEnd < 0) {
                this.spaceRequirements.flowPastEnd = 0;
            }
        }
    }

    public CoordinateTransformation getCoordinateTransformation() {
        return this;
    }

    void paintAxis(PlotGraphics plotGraphics, double d, double d2, double d3, Color color, Color color2, Color color3) {
        block20: {
            double d4;
            int n;
            boolean bl = this.axis.getAxisOrientation() == 2;
            boolean bl2 = !bl && this.axis.onLeftSide;
            double d5 = bl ? d : d2;
            double d6 = bl ? d + d3 : d2 - d3;
            FontMetrics fontMetrics = plotGraphics.getFontMetrics();
            int n2 = fontMetrics.getHeight();
            int n3 = fontMetrics.getAscent();
            int n4 = fontMetrics.getMaxAscent();
            if (this.labels == null) {
                return;
            }
            if (this.logarithmic) {
                n = this.labels[0].text.startsWith("e");
                int n5 = 0;
                while (n5 < this.labels.length) {
                    double d7;
                    String string = this.labels[n5].text;
                    String string2 = null;
                    if (n != 0) {
                        string2 = string.substring(1);
                        string = "10";
                        d4 = fontMetrics.stringWidth(string) + fontMetrics.stringWidth(string2);
                    } else {
                        d4 = fontMetrics.stringWidth(string);
                    }
                    double d8 = d5 + (double)((int)(this.labels[n5].position * (d6 - d5)));
                    if (bl) {
                        plotGraphics.setColor(color2);
                        plotGraphics.drawLine(d8, d2 + 5.0, d8, d2 - 5.0);
                        d7 = d2 + (double)n4 + 7.0;
                        d8 -= d4 / 2.0;
                        plotGraphics.setColor(color);
                        if (n != 0) {
                            plotGraphics.drawString(string2, d8 + (double)fontMetrics.stringWidth(string), d7);
                            d7 += (double)(n2 / 2);
                        }
                        plotGraphics.drawString(string, d8, d7);
                    } else {
                        plotGraphics.setColor(color2);
                        plotGraphics.drawLine(d - 5.0, d8, d + 5.0, d8);
                        d7 = bl2 ? d - d4 - 7.0 : d + 7.0;
                        d8 += (double)(n3 / 2);
                        plotGraphics.setColor(color);
                        if (n != 0) {
                            plotGraphics.drawString(string2, d7 + (double)fontMetrics.stringWidth(string), d8 - (double)(n2 / 2));
                        }
                        plotGraphics.drawString(string, d7, d8);
                    }
                    ++n5;
                }
            } else {
                n = 0;
                while (n < this.labels.length) {
                    String string = this.labels[n].text;
                    double d9 = d5 + this.labels[n].position * (d6 - d5);
                    if (bl) {
                        plotGraphics.setColor(color2);
                        plotGraphics.drawLine(d9, d2 + 5.0, d9, d2 - 5.0);
                        d4 = d2 + (double)n4 + 7.0;
                        plotGraphics.setColor(color);
                        plotGraphics.drawString(string, d9 - (double)(fontMetrics.stringWidth(string) / 2), d4);
                    } else {
                        plotGraphics.setColor(color2);
                        plotGraphics.drawLine(d - 5.0, d9, d + 5.0, d9);
                        d4 = bl2 ? d - (double)fontMetrics.stringWidth(string) - 7.0 : d + 7.0;
                        plotGraphics.setColor(color);
                        plotGraphics.drawString(string, d4, d9 + (double)(n3 / 2));
                    }
                    ++n;
                }
            }
            if (this.scale_power != 0) {
                plotGraphics.setColor(color);
                String string = String.valueOf(this.scale_power);
                if (bl) {
                    double d10 = d2 + (double)n3 + (double)this.getPowerOffset(fontMetrics);
                    double d11 = this.axis.getSize().width - 3 - fontMetrics.stringWidth(string);
                    plotGraphics.drawString("x10", d11 - (double)fontMetrics.stringWidth("x10"), d10 + (double)(n2 / 2));
                    plotGraphics.drawString(string, d11, d10);
                } else {
                    double d12 = n3 + 3;
                    double d13 = bl2 ? d - (double)fontMetrics.stringWidth(string) : d;
                    plotGraphics.drawString("x10", bl2 ? d13 - (double)fontMetrics.stringWidth("x10") : d13, d12 + (double)(n2 / 2));
                    plotGraphics.drawString(string, bl2 ? d13 : d13 + (double)fontMetrics.stringWidth("x10"), d12);
                }
            }
            if (this.hideMinorTicks || this.minorTickPositions == null || this.minorTickPositions.length == 0) break block20;
            plotGraphics.setColor(color3);
            if (bl) {
                int n6 = 0;
                while (n6 < this.minorTickPositions.length) {
                    double d14 = d5 + (double)((int)(this.minorTickPositions[n6] * (d6 - d5)));
                    plotGraphics.drawLine(d14, d2 + 3.0, d14, d2 - 3.0);
                    ++n6;
                }
            } else {
                int n7 = 0;
                while (n7 < this.minorTickPositions.length) {
                    double d15 = d5 + (double)((int)(this.minorTickPositions[n7] * (d6 - d5)));
                    plotGraphics.drawLine(d - 3.0, d15, d + 3.0, d15);
                    ++n7;
                }
            }
        }
    }

    int getMajorTickMarkLength() {
        return 5;
    }

    public double convert(double d) {
        int n = this.axis.getMinLocation();
        int n2 = this.axis.getMaxLocation();
        if (this.logarithmic) {
            double d2 = Math.log(this.plot_min) / this.log10;
            double d3 = Math.log(this.plot_max) / this.log10;
            d = d > 0.0 ? Math.log(d) / this.log10 : d2;
            double d4 = (d - d2) / (d3 - d2);
            return (double)n + d4 * (double)(n2 - n);
        }
        double d5 = (d - this.plot_min) / (this.plot_max - this.plot_min);
        return (double)n + d5 * (double)(n2 - n);
    }

    public double unConvert(double d) {
        int n = this.axis.getMinLocation();
        int n2 = this.axis.getMaxLocation();
        double d2 = (d - (double)n) / (double)(n2 - n);
        if (this.logarithmic) {
            double d3 = Math.log(this.plot_min) / this.log10;
            double d4 = Math.log(this.plot_max) / this.log10;
            return this.plot_min + d2 * (d4 - d3);
        }
        return this.plot_min + d2 * (this.plot_max - this.plot_min);
    }

    public double getIntersection() {
        return this.plot_min;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeBoolean(this.logarithmic);
        objectOutput.writeBoolean(this.useSuggestedRange);
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        this.logarithmic = objectInput.readBoolean();
        this.useSuggestedRange = objectInput.readBoolean();
    }
}

