/*
 * Decompiled with CFR 0.152.
 */
package jas.job;

import hep.analysis.NamedObject;
import hep.analysis.Page;
import hep.analysis.Plot;
import hep.analysis.peer.PagePeer;
import jas.hep.PartitionAdapter;
import jas.hist.DataSource;
import jas.job.JobFolder;
import jas.job.PageAccess;
import jas.job.PlotAccess;
import jas.util.tree.SimpleNode;
import java.util.Enumeration;

final class JobPage
extends SimpleNode
implements PagePeer,
PageAccess {
    private Page m_page;

    public JobPage(Page page, JobFolder jobFolder) {
        super(jobFolder, page.getName(), "page", 0, null);
        this.m_page = page;
    }

    public Object getObject() {
        return this;
    }

    public void show() {
        this.treeChanged(524288);
    }

    public void addNotify(Plot plot) {
    }

    public void removeNotify(Plot plot) {
    }

    public void clearNotify() {
    }

    public void delete() {
        this.m_page.delete();
    }

    public void rename(String string) throws NamedObject.RenameException {
        this.m_page.rename(string);
    }

    public int getNPlots() {
        return this.m_page.getNPlots();
    }

    public PlotAccess getPlot(int n) {
        Enumeration enumeration = this.m_page.plots();
        int n2 = 0;
        while (n2 < n) {
            enumeration.nextElement();
            ++n2;
        }
        return new PagePlotAccess(enumeration.nextElement());
    }

    private class PagePlotAccess
    implements PlotAccess {
        private Plot plot;
        private Page.ConstrainedPlot constrainedPlot;

        PagePlotAccess(Object object) {
            if (object instanceof Page.ConstrainedPlot) {
                this.constrainedPlot = (Page.ConstrainedPlot)object;
                this.plot = this.constrainedPlot.getPlot();
            } else {
                this.plot = (Plot)object;
            }
        }

        public void delete() {
            this.plot.delete();
        }

        public void rename(String string) throws NamedObject.RenameException {
            this.plot.rename(string);
        }

        public int getNDataSources() {
            return this.plot.getNHistograms();
        }

        public DataSource getData(int n) {
            return PartitionAdapter.create(this.plot.getHistogram(n));
        }

        public boolean isConstrained() {
            return this.constrainedPlot != null;
        }

        public double getX() {
            return this.constrainedPlot.getX();
        }

        public double getY() {
            return this.constrainedPlot.getY();
        }

        public double getWidth() {
            return this.constrainedPlot.getWidth();
        }

        public double getHeight() {
            return this.constrainedPlot.getHeight();
        }
    }
}

