/*
 * Decompiled with CFR 0.152.
 */
package jas.job;

import hep.analysis.Histogram;
import hep.analysis.NamedObject;
import hep.analysis.Partition;
import hep.analysis.partition.PartitionFactory;
import hep.analysis.peer.HistogramPeer;
import jas.hep.PartitionAdapter;
import jas.hist.DataSource;
import jas.hist.HasSlices;
import jas.hist.HistogramUpdate;
import jas.hist.Rebinnable1DHistogramData;
import jas.hist.Rebinnable2DHistogramData;
import jas.hist.util.ScatterSliceAdapter;
import jas.hist.util.SliceAdapter;
import jas.hist.util.SliceEvent;
import jas.hist.util.SliceListener;
import jas.job.HistogramAccess;
import jas.job.JobFolder;
import jas.job.JobSlice;
import jas.util.tree.SimpleNode;

final class JobHistogram
extends SimpleNode
implements HistogramPeer,
HistogramAccess {
    private static final HistogramUpdate hReset = new HistogramUpdate(16, true);
    private Histogram m_hist;

    public JobHistogram(Histogram histogram, JobFolder jobFolder) {
        super(jobFolder, histogram.getName(), "histogramAccess", 0, null);
        this.m_hist = histogram;
    }

    public void partitionNotify() {
        this.treeChanged(0x100000);
    }

    public Object getObject() {
        return this;
    }

    public void clearPartition() {
        Partition partition = this.m_hist.getPartition();
        if (partition == null) {
            return;
        }
        partition.destroy();
    }

    public void delete() {
        this.m_hist.delete();
    }

    public void clear() {
        Partition partition = this.m_hist.getPartition();
        if (partition != null) {
            partition.clear();
        }
    }

    public void show() {
        this.treeChanged(524288);
    }

    public void rename(String string) throws NamedObject.RenameException {
        this.m_hist.rename(string);
        if (this.canSetClearOnRewind()) {
            this.setClearOnRewind(false);
        }
    }

    public void setClearOnRewind(boolean bl) {
        this.m_hist.setClearOnRewind(bl);
    }

    public boolean isClearOnRewind() {
        return this.m_hist.isClearOnRewind();
    }

    public boolean canSetClearOnRewind() {
        SimpleNode simpleNode = this.getParent();
        if (simpleNode instanceof HistogramAccess) {
            HistogramAccess histogramAccess = (HistogramAccess)((Object)simpleNode);
            return histogramAccess.isClearOnRewind() && histogramAccess.canSetClearOnRewind();
        }
        return false;
    }

    public String getDescription() {
        return this.m_hist.toString();
    }

    public DataSource getData() {
        Partition partition = this.m_hist.getPartition();
        if (partition instanceof PartitionFactory) {
            return null;
        }
        DataSource dataSource = PartitionAdapter.create(partition, this.m_hist.getName());
        if (dataSource instanceof Rebinnable2DHistogramData && !(dataSource instanceof HasSlices)) {
            dataSource = new ScatterSliceAdapter((Rebinnable2DHistogramData)dataSource);
        }
        if (dataSource instanceof SliceAdapter) {
            ((SliceAdapter)((Object)dataSource)).addSliceListener(new SliceListener(){

                public void sliceAdded(SliceEvent sliceEvent) {
                    HasSlices hasSlices = (HasSlices)sliceEvent.getSource();
                    Rebinnable1DHistogramData rebinnable1DHistogramData = hasSlices.getSlice(sliceEvent.getIndex());
                    new JobSlice(rebinnable1DHistogramData, JobHistogram.this);
                }

                public void sliceRemoved(SliceEvent sliceEvent) {
                    HasSlices hasSlices = (HasSlices)sliceEvent.getSource();
                    Rebinnable1DHistogramData rebinnable1DHistogramData = hasSlices.getSlice(sliceEvent.getIndex());
                    SimpleNode simpleNode = JobHistogram.this.findChild(rebinnable1DHistogramData.getTitle());
                    simpleNode.destroy();
                }
            });
        }
        return dataSource;
    }
}

