/*
 * Decompiled with CFR 0.152.
 */
package jas.jds.module;

import jas.jds.module.LocalDIM2;
import jas.jds.module.LocalJobBuilder;
import jas.util.Finishable;
import jas.util.HasHelpPage;
import jas.util.JASWizardPage;
import jas.util.OpenLocalFilePanel;
import java.awt.BorderLayout;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public abstract class BasicLocalDIM
implements LocalDIM2 {
    private FileFilter fileFilter;
    transient LocalJobBuilder m_ljb;

    public BasicLocalDIM(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
    }

    public BasicLocalDIM(String string, String string2) {
        this(new BasicFileFilter(string, string2));
    }

    public JASWizardPage getSetupPage() {
        return new BasicWizardPage();
    }

    public void setLocalJobBuilder(LocalJobBuilder localJobBuilder) {
        this.m_ljb = localJobBuilder;
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public String toString() {
        return this.fileFilter.getDescription();
    }

    public String getHelpTopic() {
        return "builtInModules.BasicLocalDIM";
    }

    private static class BasicFileFilter
    extends FileFilter {
        private String description;
        private String filetype;

        BasicFileFilter(String string, String string2) {
            this.description = string;
            this.filetype = string2;
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(this.filetype);
        }

        public String getDescription() {
            return this.description;
        }
    }

    class BasicWizardPage
    extends JASWizardPage
    implements Finishable,
    HasHelpPage {
        OpenLocalFilePanel m_filePanel;

        BasicWizardPage() {
            super(new BorderLayout());
            this.m_filePanel = new OpenLocalFilePanel(false, false, BasicLocalDIM.this.getClass().getName(), BasicLocalDIM.this.fileFilter);
            this.add("North", this.m_filePanel);
        }

        public void onFinish() {
            String string = this.m_filePanel.getText();
            if (string.length() == 0) {
                JOptionPane.showMessageDialog(this, "You must enter a file name.", "Error...", 0);
                return;
            }
            BasicLocalDIM.this.m_ljb.createJob(string);
            this.m_filePanel.saveState();
            this.dispose();
        }

        public String getHelpTopic() {
            return BasicLocalDIM.this.getHelpTopic();
        }
    }
}

