/*
 * Decompiled with CFR 0.152.
 */
package jas.jds;

import hep.analysis.EventData;
import jas.hist.DataSource;
import jas.hist.HasScatterPlotData;
import jas.hist.Rebinnable1DHistogramData;
import jas.hist.Rebinnable2DHistogramData;
import jas.jds.JDSJob;
import jas.jds.Remote2DRebinAdaptor;
import jas.jds.RemoteEventSourceFolderAdaptor;
import jas.jds.RemoteHistogramAccessAdaptor;
import jas.jds.RemotePageAccessAdaptor;
import jas.jds.RemotePlotAccessAdaptor;
import jas.jds.RemoteRebinAdaptor;
import jas.jds.RemoteScatterAdaptor;
import jas.jds.interfaces.RemoteClassLoader;
import jas.jds.interfaces.RemoteJob;
import jas.jds.interfaces.RemoteJobInfo;
import jas.jds.module.AnnotatedEventSource;
import jas.jds.module.ServerRegistry;
import jas.job.EventSourceFolder;
import jas.job.HistogramAccess;
import jas.job.LoaderException;
import jas.job.PageAccess;
import jas.job.PlotAccess;
import jas.util.rmi.RMIDestination;
import jas.util.rmi.RMIEventQueue;
import jas.util.rmi.RemoteEventReceiver;
import jas.util.tree.TreeItem;
import java.rmi.RemoteException;
import java.rmi.server.RemoteObject;
import java.rmi.server.UnicastRemoteObject;
import java.rmi.server.Unreferenced;
import java.util.Vector;

class RemoteJobAdaptor
extends UnicastRemoteObject
implements RemoteJob,
Unreferenced {
    private JDSJob m_job;
    private Vector m_remoteObservers = new Vector();
    private static final Class[] noArgc = new Class[0];
    private static final Object[] noArgs = new Object[0];
    private RMIEventQueue m_eq;

    RemoteJobAdaptor(JDSJob jDSJob, RemoteEventReceiver remoteEventReceiver, RMIDestination rMIDestination, RemoteClassLoader remoteClassLoader) throws RemoteException {
        this.m_job = jDSJob;
        this.m_eq = new RMIEventQueue(remoteEventReceiver);
        jDSJob.addObserver(this.m_eq.setEventSource(rMIDestination));
        jDSJob.setRemoteLoader(remoteClassLoader);
    }

    public TreeItem[] listItems() {
        this.m_job.listItems();
        return null;
    }

    public RemoteObject getItem(TreeItem treeItem, RMIDestination rMIDestination) throws RemoteException {
        Object object = this.m_job.getItem(treeItem);
        if (object instanceof DataSource) {
            return this.getDataSourceAdaptor((DataSource)object, rMIDestination);
        }
        if (object instanceof AnnotatedEventSource) {
            try {
                Object object2 = ((AnnotatedEventSource)object).getItem(treeItem);
                if (object2 instanceof DataSource) {
                    return this.getDataSourceAdaptor((DataSource)object, rMIDestination);
                }
                if (object2 instanceof EventSourceFolder) {
                    return new RemoteEventSourceFolderAdaptor((EventSourceFolder)object2);
                }
            }
            catch (Exception exception) {}
        } else {
            if (object instanceof HistogramAccess) {
                return new RemoteHistogramAccessAdaptor((HistogramAccess)object, this, rMIDestination);
            }
            if (object instanceof PageAccess) {
                return new RemotePageAccessAdaptor((PageAccess)object, this, rMIDestination);
            }
            if (object instanceof PlotAccess) {
                return new RemotePlotAccessAdaptor((PlotAccess)object, this, rMIDestination);
            }
        }
        return null;
    }

    RemoteObject getDataSourceAdaptor(DataSource dataSource, RMIDestination rMIDestination) throws RemoteException {
        if (dataSource instanceof Rebinnable1DHistogramData) {
            RemoteRebinAdaptor remoteRebinAdaptor = new RemoteRebinAdaptor((Rebinnable1DHistogramData)dataSource, this.m_eq, rMIDestination);
            this.m_remoteObservers.addElement(remoteRebinAdaptor);
            return remoteRebinAdaptor;
        }
        if (dataSource instanceof Rebinnable2DHistogramData) {
            Remote2DRebinAdaptor remote2DRebinAdaptor = dataSource instanceof HasScatterPlotData ? new RemoteScatterAdaptor((Rebinnable2DHistogramData)dataSource, this.m_eq, rMIDestination) : new Remote2DRebinAdaptor((Rebinnable2DHistogramData)dataSource, this.m_eq, rMIDestination);
            this.m_remoteObservers.addElement(remote2DRebinAdaptor);
            return remote2DRebinAdaptor;
        }
        return null;
    }

    public RemoteJobInfo getJobInfo() {
        return this.m_job.getJobInfo();
    }

    public TreeItem[] listDataSources() {
        return ServerRegistry.listDatasets();
    }

    public TreeItem[] getSubItems(TreeItem treeItem) {
        return ServerRegistry.getSubItems(treeItem);
    }

    public void openDataSource(TreeItem treeItem) {
        this.m_job.openDataSource(treeItem);
    }

    public void closeDataset(TreeItem treeItem) {
        this.m_job.closeDataset(treeItem);
    }

    public void setEventSource(TreeItem treeItem) {
        this.m_job.setEventSource(treeItem);
    }

    public void receiveMessage(Object object, Object object2, Object object3) {
        this.m_job.receiveMessage(object3);
    }

    public String getEventDataClass(TreeItem treeItem) {
        System.out.println("Returning " + this.m_job.getEventDataClass(treeItem).getName());
        return this.m_job.getEventDataClass(treeItem).getName();
    }

    public void unreferenced() {
        if (this.m_job != null) {
            this.close();
        }
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        runtime.runFinalization();
    }

    public void loadRemoteObject(String string) throws LoaderException {
        this.m_job.loadObject(string);
    }

    public void unloadAll() {
        this.m_job.unloadAll();
    }

    public EventData getEvent() {
        return this.m_job.getEvent();
    }

    public void run() {
        this.m_job.rewind();
        this.m_job.go(0);
    }

    public void go() {
        this.m_job.go(0);
    }

    public void go(int n) {
        this.m_job.go(n);
    }

    public void step() {
        this.m_job.go(1);
    }

    public void restart() {
        this.m_job.rewind();
    }

    public void stop() {
        this.m_job.stop();
    }

    public void kill() {
        this.m_job.kill();
    }

    public void setPersistent(boolean bl) {
        this.m_job.setPersistent(bl);
    }

    public void close() {
        this.m_eq.dispose();
        this.m_job.close();
        this.m_job = null;
    }

    public String getRemoteCodeBase() {
        return System.getProperty("java.rmi.server.codebase");
    }
}

