/*
 * Decompiled with CFR 0.152.
 */
package jas.jds;

import jas.hist.HasSlices;
import jas.hist.HasStatistics;
import jas.hist.HasStyle;
import jas.hist.JASHistStyle;
import jas.hist.Rebinnable2DHistogramData;
import jas.hist.Statistics;
import jas.jds.RemoteRebinAdaptor;
import jas.jds.RemoteSliceAdaptor;
import jas.jds.SerializableStatistics;
import jas.jds.interfaces.Remote2DHistogramInfo;
import jas.jds.interfaces.RemoteObserver;
import jas.jds.interfaces.RemoteRebinnable1DHistogramData;
import jas.jds.interfaces.RemoteRebinnable2DHistogramData;
import jas.jds.interfaces.RemoteSliceParameters;
import jas.job.HistogramAccess;
import jas.util.rmi.RMIDestination;
import jas.util.rmi.RMIEventQueue;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Observable;

class Remote2DRebinAdaptor
extends UnicastRemoteObject
implements RemoteRebinnable2DHistogramData {
    protected Rebinnable2DHistogramData m_hist;
    private RemoteObserver m_obs;
    private RMIEventQueue m_eq;

    Remote2DRebinAdaptor(Rebinnable2DHistogramData rebinnable2DHistogramData, RMIEventQueue rMIEventQueue, RMIDestination rMIDestination) throws RemoteException {
        if (rebinnable2DHistogramData instanceof Observable) {
            ((Observable)((Object)rebinnable2DHistogramData)).addObserver(rMIEventQueue.setEventSource(rMIDestination));
        }
        this.m_hist = rebinnable2DHistogramData;
        this.m_eq = rMIEventQueue;
    }

    public double[][][] remoteRebin(int n, double d, double d2, int n2, double d3, double d4, boolean bl, boolean bl2, boolean bl3) throws RemoteException {
        return this.m_hist.rebin(n, d, d2, n2, d3, d4, bl, bl2, bl3);
    }

    public Remote2DHistogramInfo getRemoteInfo() {
        Remote2DHistogramInfo remote2DHistogramInfo = new Remote2DHistogramInfo();
        this.fillInfo(remote2DHistogramInfo);
        return remote2DHistogramInfo;
    }

    protected void fillInfo(Remote2DHistogramInfo remote2DHistogramInfo) {
        remote2DHistogramInfo.m_title = this.m_hist.getTitle();
        remote2DHistogramInfo.m_xAxis.m_min = this.m_hist.getXMin();
        remote2DHistogramInfo.m_xAxis.m_max = this.m_hist.getXMax();
        remote2DHistogramInfo.m_xAxis.m_bins = this.m_hist.getXBins();
        remote2DHistogramInfo.m_xAxis.m_axisType = this.m_hist.getXAxisType();
        remote2DHistogramInfo.m_yAxis.m_min = this.m_hist.getYMin();
        remote2DHistogramInfo.m_yAxis.m_max = this.m_hist.getYMax();
        remote2DHistogramInfo.m_yAxis.m_bins = this.m_hist.getYBins();
        remote2DHistogramInfo.m_yAxis.m_axisType = this.m_hist.getYAxisType();
        remote2DHistogramInfo.m_isRebinnable = this.m_hist.isRebinnable();
    }

    public String[] getRemoteXAxisLabels() {
        return this.m_hist.getXAxisLabels();
    }

    public String[] getRemoteYAxisLabels() {
        return this.m_hist.getYAxisLabels();
    }

    public String getDescription() {
        return this.m_hist.toString();
    }

    public void delete() {
        ((HistogramAccess)((Object)this.m_hist)).delete();
    }

    public Statistics getStatistics() {
        if (this.m_hist instanceof HasStatistics) {
            Statistics statistics = ((HasStatistics)((Object)this.m_hist)).getStatistics();
            if (statistics instanceof Serializable) {
                return statistics;
            }
            return new SerializableStatistics(statistics);
        }
        return null;
    }

    public int getNSlices() {
        return this.m_hist instanceof HasSlices ? ((HasSlices)((Object)this.m_hist)).getNSlices() : 0;
    }

    public RemoteSliceParameters getSliceParameters(int n) throws RemoteException {
        return new RemoteSliceAdaptor(((HasSlices)((Object)this.m_hist)).getSliceParameters(n));
    }

    public RemoteRebinnable1DHistogramData getSlice(int n, RMIDestination rMIDestination) throws RemoteException {
        return new RemoteRebinAdaptor(((HasSlices)((Object)this.m_hist)).getSlice(n), this.m_eq, rMIDestination);
    }

    public boolean canAddRemoveSlices() {
        return this.m_hist instanceof HasSlices ? ((HasSlices)((Object)this.m_hist)).canAddRemoveSlices() : false;
    }

    public int addSlice(double d, double d2, double d3, double d4, double d5) {
        return ((HasSlices)((Object)this.m_hist)).addSlice(d, d2, d3, d4, d5);
    }

    public void removeSlice(int n) {
        ((HasSlices)((Object)this.m_hist)).removeSlice(n);
    }

    public JASHistStyle getStyle() {
        if (this.m_hist instanceof HasStyle) {
            return ((HasStyle)((Object)this.m_hist)).getStyle();
        }
        return null;
    }
}

