/*
 * Decompiled with CFR 0.152.
 */
package jas.jds;

import jas.jds.ConfigException;
import jas.swingstudio.JavaAnalysisStudio;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;

class ConfigFileReader {
    private int m_quoteChar = 34;
    private File file;
    private FileReader fr;
    private StreamTokenizer in;

    ConfigFileReader(String string) throws ConfigException {
        try {
            this.file = new File(JavaAnalysisStudio.resolveSymbols(string));
            this.fr = new FileReader(this.file);
            this.in = new StreamTokenizer(this.fr);
            this.in.resetSyntax();
            this.in.wordChars(33, 255);
            this.in.whitespaceChars(0, 32);
            this.in.commentChar(62);
            this.in.quoteChar(this.m_quoteChar);
            this.in.eolIsSignificant(true);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ConfigException("Cannot open config file: " + string, fileNotFoundException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readConfigFile() throws ConfigException {
        try {
            while (true) {
                if (this.in.nextToken() == -1) {
                    this.fr.close();
                    return;
                }
                if (this.in.ttype == 10) continue;
                if (this.in.ttype != -3) {
                    throw new ConfigReadException("Syntax error");
                }
                String string = this.in.sval.toLowerCase();
                if (string.equals("dataserver")) {
                    this.readDataServer();
                    continue;
                }
                if (string.equals("job")) {
                    this.readJob();
                    continue;
                }
                if (string.equals("protocol")) {
                    this.readProtocol();
                    continue;
                }
                if (!string.equals("accessmanager")) throw new ConfigReadException("Unknown keyword " + string, null);
                this.readAccessManager();
            }
        }
        catch (IOException iOException) {
            throw new ConfigReadException("Error reading config file", iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void readJob() throws ConfigException, IOException {
        if (this.in.nextToken() != -3) {
            throw new ConfigReadException("Missing job name");
        }
        String string = this.in.sval;
        try {
            Class<?> clazz = Class.forName(string);
            Vector<String> vector = new Vector<String>();
            while (this.in.nextToken() != 10) {
                if (this.in.ttype == -1) break;
                if (this.in.ttype != -3 && this.in.ttype != this.m_quoteChar) continue;
                vector.addElement(JavaAnalysisStudio.resolveSymbols(this.in.sval));
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            Class[] classArray = new Class[]{objectArray.getClass()};
            Method method = clazz.getMethod("main", classArray);
            Object[] objectArray2 = new Object[]{objectArray};
            method.invoke(null, objectArray2);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigReadException("Could not load job: " + string, classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ConfigReadException("Couldn't find a static void main method in: " + string, noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ConfigReadException("main is not public in: " + string, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ConfigReadException("Invocation Target Exception in: " + string, invocationTargetException.getTargetException());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void readDataServer() throws ConfigException, IOException {
        if (this.in.nextToken() != -3) {
            throw new ConfigReadException("Missing dataserver name");
        }
        String string = this.in.sval;
        try {
            Class<?> clazz = Class.forName(string);
            Vector<String> vector = new Vector<String>();
            while (this.in.nextToken() != 10) {
                if (this.in.ttype == -1) break;
                if (this.in.ttype != -3 && this.in.ttype != this.m_quoteChar) continue;
                vector.addElement(JavaAnalysisStudio.resolveSymbols(this.in.sval));
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            Class[] classArray = new Class[]{objectArray.getClass()};
            Method method = clazz.getMethod("main", classArray);
            Object[] objectArray2 = new Object[]{objectArray};
            method.invoke(null, objectArray2);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigReadException("Could not load dataserver: " + string, classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ConfigReadException("Couldn't find a static void main method in: " + string, noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ConfigReadException("main is not public in: " + string, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ConfigReadException("Invocation Target Exception in: " + string, invocationTargetException.getTargetException());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void readProtocol() throws ConfigException, IOException {
        if (this.in.nextToken() != -3) {
            throw new ConfigReadException("Missing protocol class");
        }
        String string = this.in.sval;
        try {
            Class<?> clazz = Class.forName(string);
            Vector<String> vector = new Vector<String>();
            while (this.in.nextToken() != 10) {
                if (this.in.ttype == -1) break;
                if (this.in.ttype != -3 && this.in.ttype != this.m_quoteChar) continue;
                vector.addElement(JavaAnalysisStudio.resolveSymbols(this.in.sval));
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            Class[] classArray = new Class[]{objectArray.getClass()};
            Method method = clazz.getMethod("main", classArray);
            Object[] objectArray2 = new Object[]{objectArray};
            method.invoke(null, objectArray2);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigReadException("Could not load protocol: " + string, classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ConfigReadException("Couldn't find a static void main method in: " + string, noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ConfigReadException("main is not public in: " + string, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ConfigReadException("Invocation Target Exception in: " + string, invocationTargetException.getTargetException());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void readAccessManager() throws ConfigException, IOException {
        if (this.in.nextToken() != -3) {
            throw new ConfigReadException("Missing protocol class");
        }
        String string = this.in.sval;
        try {
            Class<?> clazz = Class.forName(string);
            Vector<String> vector = new Vector<String>();
            while (this.in.nextToken() != 10) {
                if (this.in.ttype == -1) break;
                if (this.in.ttype != -3 && this.in.ttype != this.m_quoteChar) continue;
                vector.addElement(JavaAnalysisStudio.resolveSymbols(this.in.sval));
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            Class[] classArray = new Class[]{objectArray.getClass()};
            Method method = clazz.getMethod("main", classArray);
            Object[] objectArray2 = new Object[]{objectArray};
            method.invoke(null, objectArray2);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigReadException("Could not load AccessManager: " + string, classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ConfigReadException("Couldn't find a static void main method in: " + string, noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ConfigReadException("main is not public in: " + string, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ConfigReadException("Invocation Target Exception in: " + string, invocationTargetException.getTargetException());
        }
    }

    private class ConfigReadException
    extends ConfigException {
        private int line;
        private String fileName;

        ConfigReadException(String string) {
            super(string, null);
            this.line = ConfigFileReader.this.in.lineno();
            this.fileName = ConfigFileReader.this.file.getName();
        }

        ConfigReadException(String string, Throwable throwable) {
            super(string, throwable);
            this.line = ConfigFileReader.this.in.lineno();
            this.fileName = ConfigFileReader.this.file.getName();
        }

        public String getMessage() {
            String string = "Error occured while reading file: " + this.fileName + " at line " + this.line + "\n\t";
            return string + super.getMessage();
        }
    }
}

