/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.ComponentNodeTraverser;
import jas.hist.FormatNodeTraverser;
import jas.hist.StatisticsBlock;
import jas.hist.XMLPrintWriter;
import jas.util.xml.XMLNodeTraverser;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class StatsNodeTraverser
extends ComponentNodeTraverser {
    private Vector selected;
    private StatisticsBlock stats;

    StatsNodeTraverser() {
    }

    void traverse(Node node, StatisticsBlock statisticsBlock) throws XMLNodeTraverser.BadXMLException {
        this.stats = statisticsBlock;
        super.traverse(node, statisticsBlock);
        if (this.selected != null) {
            Object[] objectArray = new String[this.selected.size()];
            this.selected.copyInto(objectArray);
            statisticsBlock.setSelectedEntries((String[])objectArray);
        }
    }

    protected void handleElement(Element element, String string) throws XMLNodeTraverser.BadXMLException {
        if (string.equals("statsEntry")) {
            if (this.selected == null) {
                this.selected = new Vector();
            }
            this.selected.addElement(element.getAttribute("name"));
        } else if (string.equals("format")) {
            FormatNodeTraverser formatNodeTraverser = new FormatNodeTraverser(element);
            this.stats.setFormat(formatNodeTraverser.getFormat());
        } else {
            super.handleElement(element, string);
        }
    }

    protected void handleAttributeNode(Attr attr, String string, String string2) throws XMLNodeTraverser.BadXMLException {
        if (string.equals("showTitles")) {
            this.stats.setShowTitles(XMLPrintWriter.convertStringToShowTitle(string2));
        } else if (string.equals("alignment")) {
            this.stats.setSplitStringAlign(XMLPrintWriter.convertStringToAlignment(string2));
        } else {
            super.handleAttributeNode(attr, string, string2);
        }
    }
}

