/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.SaveAsGIF;
import jas.hist.SaveAsPlotML;
import jas.hist.SaveAsPlugin;
import jas.util.Application;
import jas.util.JASDialog;
import jas.util.JASState;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class SaveAsDialog
extends JASDialog
implements ActionListener {
    private static Vector list;
    private static Properties props;
    private JButton browse = new JButton("Browse...");
    private JButton advanced = new JButton("Options...");
    private JTextField file = new JTextField(40);
    private JComboBox type;
    private Component component;
    static /* synthetic */ Class class$java$awt$Frame;

    public static void register(SaveAsPlugin saveAsPlugin) {
        list.addElement(saveAsPlugin);
        saveAsPlugin.restoreOptions(props);
    }

    public SaveAsDialog(Component component) {
        super((Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = SaveAsDialog.class$("java.awt.Frame")) : class$java$awt$Frame, component), "Save As...");
        Object object;
        this.component = component;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)this.file, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.browse, gridBagConstraints);
        Vector<SaveAsPlugin> vector = new Vector<SaveAsPlugin>();
        int n = 0;
        while (n < list.size()) {
            object = (SaveAsPlugin)list.elementAt(n);
            if (object.supportsClass(component)) {
                vector.addElement((SaveAsPlugin)object);
            }
            ++n;
        }
        this.type = new JComboBox(vector);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.type, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.advanced, gridBagConstraints);
        this.getContentPane().add((Component)jPanel, "Center");
        object = System.getProperty("user.home") + File.separator + "plot.xxx";
        String string = props.getProperty("jas.hist.saveAsType");
        if (string != null) {
            int n2 = 0;
            while (n2 < vector.size()) {
                SaveAsPlugin saveAsPlugin = (SaveAsPlugin)vector.elementAt(n2);
                if (saveAsPlugin.getFileFilter().getDescription().equals(string)) {
                    this.type.setSelectedItem(saveAsPlugin);
                    break;
                }
                ++n2;
            }
        }
        object = props.getProperty("jas.hist.saveAsFile", (String)object);
        File file = new File((String)object);
        file = this.currentType().adjustFilename(file);
        this.file.setText(file.toString());
        this.browse.addActionListener(this);
        this.advanced.addActionListener(this);
        this.advanced.setEnabled(this.currentType().hasOptions());
        this.type.setRenderer(new SaveAsRenderer());
        this.type.addActionListener(this);
        this.file.getDocument().addDocumentListener(this);
    }

    private SaveAsPlugin currentType() {
        return (SaveAsPlugin)this.type.getSelectedItem();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.browse) {
            JFileChooser jFileChooser = new JFileChooser(this.file.getText());
            jFileChooser.setFileFilter(this.currentType().getFileFilter());
            if (jFileChooser.showDialog(this, "Select") == 0) {
                this.file.setText(jFileChooser.getSelectedFile().toString());
            }
        } else if (object == this.advanced) {
            Properties properties = new Properties();
            this.currentType().saveOptions(properties);
            JPanel jPanel = this.currentType().getOptionsPanel();
            int n = JOptionPane.showConfirmDialog(this, jPanel, "Options for " + this.currentType().getFileFilter().getDescription(), 2, -1);
            if (n != 0) {
                this.currentType().restoreOptions(properties);
            }
        } else if (object == this.type) {
            this.advanced.setEnabled(this.currentType().hasOptions());
            File file = new File(this.file.getText());
            File file2 = this.currentType().adjustFilename(file);
            if (!file.equals(file2)) {
                this.file.setText(file2.toString());
            }
        }
    }

    protected void onOK() {
        try {
            int n;
            File file = new File(this.file.getText());
            if (file.exists() && (n = JOptionPane.showConfirmDialog(this, "Replace existing file?")) != 0) {
                return;
            }
            SaveAsPlugin saveAsPlugin = this.currentType();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            saveAsPlugin.saveAs(this.component, bufferedOutputStream, file, this);
            ((OutputStream)bufferedOutputStream).close();
            super.onOK();
            props.put("jas.hist.saveAsFile", this.file.getText());
            props.put("jas.hist.saveAsType", this.currentType().getFileFilter().getDescription());
            saveAsPlugin.saveOptions(props);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, iOException);
        }
    }

    protected void enableOK(JASState jASState) {
        jASState.setEnabled(this.file.getText().length() > 0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string;
        list = new Vector();
        Application application = Application.getApplication();
        props = application != null ? application.getUserProperties() : new Properties();
        String string2 = props.getProperty(string = "org.freehep.graphics2d.exportchooser.EPS_PSExportFileType.EmbedFonts");
        if (string2 == null) {
            props.setProperty(string, "Embed unknown as Type3");
        }
        SaveAsDialog.register(new SaveAsPlotML());
        SaveAsDialog.register(new SaveAsGIF());
    }

    private class SaveAsRenderer
    extends DefaultListCellRenderer {
        private SaveAsRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof SaveAsPlugin) {
                this.setText(((SaveAsPlugin)object).getFileFilter().getDescription());
            }
            return this;
        }
    }
}

