/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.Basic1DFunction;
import jas.hist.DataRenderer;
import jas.hist.FitUpdate;
import jas.hist.Fittable1DFunction;
import jas.hist.Fitter;
import jas.hist.FitterFactory;
import jas.hist.FitterRegistry;
import jas.hist.FunctionAdvancedOptions;
import jas.hist.FunctionFactory;
import jas.hist.FunctionFactoryError;
import jas.hist.FunctionRegistry;
import jas.hist.InvalidFunctionParameter;
import jas.hist.JASHist;
import jas.hist.JASHist1DFunctionData;
import jas.hist.JASHist1DHistogramData;
import jas.hist.JASHistData;
import jas.hist.JASHistPropDataStyle;
import jas.hist.JASHistPropFunctionStyle;
import jas.hist.XYDataSource;
import jas.util.JASIcon;
import jas.util.JASTextField;
import jas.util.PropertyPage;
import jas.util.PropertySite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

class JASHistPropFunctions
extends PropertyPage
implements ListSelectionListener,
PropertySite {
    private JASHistPropFunctionStyle m_propStyle;
    private JASHistPropDataStyle m_dataStyle;
    private ParamManager m_paramManager;
    private FitManager m_fitManager;
    private boolean m_init = false;
    private JASHist1DFunctionData m_selected;
    private JList m_list;
    private DefaultListModel m_listModel;
    private TextField m_value;
    private JASHist m_jHist;
    private NumberFormat format = NumberFormat.getInstance();
    private JButton advanced;
    private ListNameChangeListener m_listNameChangeListener = new ListNameChangeListener();
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;

    public JASHistPropFunctions() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        this.m_listModel = new DefaultListModel();
        this.m_list = new JList(this.m_listModel);
        this.m_list.setCellRenderer(DataRenderer.createRenderer());
        this.m_list.addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.m_list);
        jScrollPane.setPreferredSize(new Dimension(100, 120));
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton("Add...");
        jButton.addActionListener(new AddButtonListener());
        jButton.setMnemonic('d');
        jPanel2.add(jButton);
        JButton jButton2 = new JButton("Remove");
        jButton2.addActionListener(new RemoveButtonListener());
        jButton2.setMnemonic('R');
        jPanel2.add(jButton2);
        jPanel.add((Component)jPanel2, "South");
        this.add((Component)jPanel, "West");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        this.m_propStyle = new JASHistPropFunctionStyle();
        this.m_propStyle.setPropertySite(this);
        jPanel4.add(this.m_propStyle);
        this.m_dataStyle = new JASHistPropDataStyle();
        this.m_dataStyle.setPropertySite(this);
        jPanel4.add(this.m_dataStyle);
        this.advanced = new JButton("Advanced options...");
        this.advanced.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    FunctionAdvancedOptions functionAdvancedOptions = (FunctionAdvancedOptions)((Object)JASHistPropFunctions.this.m_selected.getFunction());
                    Container container = JASHistPropFunctions.this;
                    while (!(container instanceof Frame)) {
                        container = container.getParent();
                    }
                    functionAdvancedOptions.openAdvancedDialog((Frame)container, JASHistPropFunctions.this.m_jHist);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.advanced.setMnemonic('v');
        jPanel4.add(this.advanced);
        jPanel3.add((Component)jPanel4, "North");
        jPanel3.setBorder(BorderFactory.createTitledBorder("Function"));
        this.m_paramManager = new ParamManager();
        jPanel3.add((Component)this.m_paramManager, "Center");
        this.m_fitManager = new FitManager();
        jPanel3.add((Component)this.m_fitManager, "South");
        this.add((Component)jPanel3, "Center");
        this.updateAdvanced();
    }

    public String getHelpTopic() {
        return "functionsAndFilters.functions";
    }

    public synchronized void doDataExchange(boolean bl, Object object) {
        if (!this.m_init) {
            JASHist jASHist = (JASHist)object;
            Enumeration enumeration = jASHist.get1DFunctions();
            while (enumeration.hasMoreElements()) {
                JASHist1DFunctionData jASHist1DFunctionData = (JASHist1DFunctionData)enumeration.nextElement();
                this.m_listModel.addElement(jASHist1DFunctionData);
                Basic1DFunction basic1DFunction = jASHist1DFunctionData.getFunction();
                if (!(basic1DFunction instanceof FunctionAdvancedOptions)) continue;
                basic1DFunction.addObserver(this.m_listNameChangeListener);
            }
            if (this.m_listModel.size() > 0) {
                this.m_selected = (JASHist1DFunctionData)this.m_listModel.elementAt(0);
                this.m_list.setSelectedValue(this.m_selected, true);
            } else {
                this.m_selected = null;
            }
            this.m_jHist = jASHist;
            this.m_fitManager.init(jASHist);
            this.m_init = true;
        }
        if (this.m_selected != null) {
            this.m_propStyle.doDataExchange(bl, this.m_selected.getStyle());
            this.m_dataStyle.doDataExchange(bl, this.m_selected);
            this.m_paramManager.doDataExchange(bl, this.m_selected.getFunction());
            this.m_fitManager.setFunction(this.m_selected);
        }
        this.setChanged(false);
        this.updateAdvanced();
    }

    private synchronized void addFunction(JASHist1DFunctionData jASHist1DFunctionData) {
        this.m_selected = jASHist1DFunctionData;
        this.m_listModel.addElement(jASHist1DFunctionData);
        this.m_list.setSelectedValue(jASHist1DFunctionData, true);
        this.doDataExchange(true, this.m_jHist);
    }

    private synchronized void removeFunction() {
        this.m_selected.delete();
        this.m_listModel.removeElement(this.m_selected);
        this.doDataExchange(true, this.m_jHist);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!this.m_init) {
            return;
        }
        this.doDataExchange(true, this.m_jHist);
        if (this.m_listModel.getSize() > 0) {
            this.m_selected = (JASHist1DFunctionData)this.m_list.getSelectedValue();
            this.doDataExchange(false, this.m_jHist);
            this.updateAdvanced();
        }
    }

    private void updateAdvanced() {
        this.advanced.setEnabled(this.m_selected != null && this.m_selected.getFunction() instanceof FunctionAdvancedOptions);
    }

    public void callEnable() {
        this.setChanged(true);
    }

    protected void deactivate() {
        this.m_paramManager.deactivate();
        this.m_fitManager.deactivate();
    }

    public JASHist getHist() {
        return this.m_jHist;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ListNameChangeListener
    implements Observer {
        private ListNameChangeListener() {
        }

        public void update(Observable observable, Object object) {
            JASHistPropFunctions.this.m_list.repaint();
        }
    }

    private class FitManager
    extends JPanel
    implements Observer,
    ItemListener {
        private Fittable1DFunction m_function;
        private JASHist1DFunctionData m_fd;
        private JLabel m_state;
        private JCheckBox m_fit;
        private JComboBox m_choice;
        private JComboBox m_fitterChoice;
        private JLabel m_chi2;
        private FitWatcher m_fitWatcher;
        private Icon[] states = new Icon[5];

        FitManager() {
            this.states[1] = JASIcon.create(this, "tick.gif");
            this.states[2] = JASIcon.create(this, "cross.gif");
            this.states[0] = JASIcon.create(this, "running.gif");
            this.states[3] = this.states[1];
            this.states[4] = this.states[2];
            JPanel jPanel = new JPanel();
            this.m_state = new JLabel(this.states[1]);
            jPanel.add(this.m_state);
            this.m_chi2 = new JLabel(this, " "){
                private final /* synthetic */ FitManager this$1;
                {
                    this.this$1 = fitManager;
                }

                public Dimension getPreferredSize() {
                    Dimension dimension = super.getPreferredSize();
                    dimension.width = 100;
                    return dimension;
                }
            };
            this.m_chi2.setIcon(JASIcon.create(this, "chi2.gif"));
            jPanel.add(this.m_chi2);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add("North", jPanel);
            JProgressBar jProgressBar = new JProgressBar();
            this.m_fitWatcher = new FitWatcher(jProgressBar.getModel());
            jPanel2.add("Center", jProgressBar);
            JPanel jPanel3 = new JPanel();
            jPanel3.add(new JLabel("Using"));
            this.m_fitterChoice = new JComboBox();
            this.m_fitterChoice.addItemListener(this);
            jPanel3.add(this.m_fitterChoice);
            JPanel jPanel4 = new JPanel();
            jPanel4.add(new JLabel("Data"));
            this.m_choice = new JComboBox();
            jPanel4.add(this.m_choice);
            JPanel jPanel5 = new JPanel(new GridLayout(0, 1));
            jPanel5.add(jPanel3);
            jPanel5.add(jPanel4);
            this.setLayout(new BorderLayout());
            this.m_fit = new JCheckBox("Fit");
            this.m_fit.addActionListener(new FitNowHandler());
            this.m_fit.setMnemonic('F');
            this.setBorder(BorderFactory.createTitledBorder("Fit"));
            this.add("North", this.m_fit);
            this.add("West", jPanel5);
            this.add("Center", jPanel2);
            this.setEnabled(false);
        }

        void init(JASHist jASHist) {
            Object object;
            Enumeration enumeration = jASHist.getDataSources();
            if (enumeration.hasMoreElements()) {
                this.m_choice.setRenderer(DataRenderer.createRenderer());
                this.m_choice.addItemListener(this);
            } else {
                this.m_choice.setEnabled(false);
            }
            while (enumeration.hasMoreElements()) {
                object = (JASHist1DHistogramData)enumeration.nextElement();
                this.m_choice.addItem(((JASHist1DHistogramData)object).getFittableDataSource());
            }
            enumeration = FitterRegistry.instance().elements();
            while (enumeration.hasMoreElements()) {
                object = (FitterFactory)enumeration.nextElement();
                this.m_fitterChoice.addItem(object);
            }
            this.m_fitterChoice.setSelectedItem(FitterRegistry.instance().getDefaultFitterFactory());
        }

        void setFunction(JASHist1DFunctionData jASHist1DFunctionData) {
            if (this.m_function != null) {
                this.m_function.deleteObserver(this);
            }
            this.m_fitWatcher.clearFit();
            if (jASHist1DFunctionData != null && jASHist1DFunctionData.getFunction() instanceof Fittable1DFunction && this.m_choice.getItemCount() > 0 && this.m_fitterChoice.getItemCount() > 0) {
                this.m_fd = jASHist1DFunctionData;
                this.m_function = (Fittable1DFunction)jASHist1DFunctionData.getFunction();
                this.m_function.addObserver(this);
                Fitter fitter = this.m_function.getFit();
                if (fitter != null) {
                    this.m_fitWatcher.setFit(fitter);
                }
                this.update();
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
                this.m_function = null;
                this.m_fd = null;
            }
        }

        private void update() {
            Fitter fitter = this.m_function.getFit();
            this.m_fit.setSelected(fitter != null);
            if (fitter != null) {
                this.m_chi2.setText(JASHistPropFunctions.this.format.format(fitter.getChiSquared()));
                this.m_choice.setSelectedItem(fitter.getData());
            }
        }

        public void update(Observable observable, Object object) {
            if (observable == this.m_function) {
                this.update();
            }
        }

        void deactivate() {
            this.setFunction(null);
        }

        public void setEnabled(boolean bl) {
            this.m_fit.setEnabled(bl);
            this.m_choice.setEnabled(bl);
            this.m_fitterChoice.setEnabled(bl);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
        }

        private class FitWatcher
        implements Observer {
            private BoundedRangeModel model;
            private Fitter m_fitter;

            FitWatcher(BoundedRangeModel boundedRangeModel) {
                boundedRangeModel.setMinimum(0);
                boundedRangeModel.setMaximum(100);
                this.model = boundedRangeModel;
                this.clearFit();
            }

            void setFit(Fitter fitter) {
                this.m_fitter = fitter;
                this.m_fitter.addObserver(this);
                FitManager.this.m_state.setEnabled(true);
                FitManager.this.m_state.repaint();
                FitManager.this.m_chi2.setEnabled(true);
                FitManager.this.m_chi2.repaint();
            }

            Fitter clearFit() {
                Fitter fitter = this.m_fitter;
                if (fitter != null) {
                    fitter.deleteObserver(this);
                    this.m_fitter = null;
                }
                FitManager.this.m_state.setEnabled(false);
                FitManager.this.m_state.repaint();
                FitManager.this.m_chi2.setEnabled(false);
                FitManager.this.m_chi2.repaint();
                return fitter;
            }

            public void update(Observable observable, Object object) {
                if (object instanceof FitUpdate) {
                    FitUpdate fitUpdate = (FitUpdate)object;
                    int n = fitUpdate.getState();
                    if (n == 5) {
                        this.clearFit();
                    } else {
                        this.model.setValue(fitUpdate.getPercent());
                        FitManager.this.m_state.setIcon(FitManager.this.states[n]);
                        if (n == 2) {
                            Container container = JASHistPropFunctions.this;
                            while (!(container instanceof Frame)) {
                                container = container.getParent();
                            }
                            JOptionPane.showMessageDialog(container, fitUpdate.getReason(), "Fit error...", 0);
                        }
                    }
                }
            }
        }

        private class FitNowHandler
        implements ActionListener {
            private FitNowHandler() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (FitManager.this.m_fit.isSelected()) {
                    FitterFactory fitterFactory = (FitterFactory)FitManager.this.m_fitterChoice.getSelectedItem();
                    Fitter fitter = fitterFactory.createFitter();
                    fitter.setFunction(FitManager.this.m_function);
                    XYDataSource xYDataSource = (XYDataSource)FitManager.this.m_choice.getSelectedItem();
                    fitter.setData(xYDataSource);
                    FitManager.this.m_fitWatcher.setFit(fitter);
                    fitter.start();
                } else {
                    FitManager.this.m_fitWatcher.clearFit().dispose();
                }
            }
        }
    }

    private class ParamManager
    extends JPanel {
        private JTable m_table;
        private Basic1DFunction m_f = null;
        private ParamTableModel m_model;

        ParamManager() {
            this.setLayout(new BorderLayout());
            this.m_model = new ParamTableModel();
            this.m_table = new JTable(this.m_model);
            this.m_table.setAutoCreateColumnsFromModel(false);
            TableColumn tableColumn = this.m_table.getColumn("Value");
            tableColumn.setCellRenderer(new ParamCellRenderer());
            tableColumn.setCellEditor(new DefaultCellEditor(new JTextField("")));
            JScrollPane jScrollPane = new JScrollPane(this.m_table);
            jScrollPane.setPreferredSize(new Dimension(350, 100));
            this.add("Center", jScrollPane);
        }

        void doDataExchange(boolean bl, Basic1DFunction basic1DFunction) {
            if (this.m_f != basic1DFunction) {
                this.m_model.setFunction(basic1DFunction);
                this.m_f = basic1DFunction;
            }
        }

        void deactivate() {
            this.m_model.deactivate();
            this.m_f = null;
        }

        private class FitHeaderRenderer
        implements TableCellRenderer {
            private TableCellRenderer m_renderer;
            private JTable m_table;

            FitHeaderRenderer(JTable jTable, TableCellRenderer tableCellRenderer) {
                this.m_table = jTable;
                this.m_renderer = tableCellRenderer;
            }

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (jTable == null) {
                    jTable = this.m_table;
                }
                return this.m_renderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
        }

        private class ParamCellRenderer
        implements TableCellRenderer {
            private JASTextField text = new JASTextField();
            private Color f = this.text.getForeground();
            private Color b = this.text.getBackground();

            private ParamCellRenderer() {
            }

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (object != null) {
                    this.text.setText(object.toString());
                }
                if (bl) {
                    this.text.setBackground(UIManager.getColor("textHighlight"));
                    this.text.setForeground(UIManager.getColor("textHighlightText"));
                } else {
                    this.text.setBackground(this.b);
                    this.text.setForeground(this.f);
                }
                this.text.setScrollOffset(0);
                return this.text;
            }
        }
    }

    private class ParamTableModel
    extends AbstractTableModel
    implements Observer {
        private String[] columns = new String[]{"Parameter", "Value", "Fit", "Error"};
        private Basic1DFunction f = null;

        ParamTableModel() {
            JASHistPropFunctions.this.format.setMaximumFractionDigits(6);
        }

        void setFunction(Basic1DFunction basic1DFunction) {
            if (basic1DFunction != null) {
                basic1DFunction.deleteObserver(this);
            }
            this.f = basic1DFunction;
            basic1DFunction.addObserver(this);
            this.fireTableChanged(new TableModelEvent(this, -1));
        }

        void deactivate() {
            if (this.f != null) {
                this.f.deleteObserver(this);
            }
        }

        public void update(Observable observable, Object object) {
            if (observable == this.f) {
                this.fireTableChanged(new TableModelEvent(this, -1));
            }
        }

        public int getRowCount() {
            if (this.f == null) {
                return 0;
            }
            String[] stringArray = this.f.getParameterNames();
            return stringArray == null ? 0 : stringArray.length;
        }

        public int getColumnCount() {
            return this.columns.length;
        }

        public Object getValueAt(int n, int n2) {
            Fittable1DFunction fittable1DFunction;
            Fitter fitter;
            if (n2 == 0) {
                return this.f.getParameterNames()[n];
            }
            if (n2 == 1) {
                return JASHistPropFunctions.this.format.format(this.f.getParameterValues()[n]);
            }
            if (n2 == 2) {
                boolean bl = this.f instanceof Fittable1DFunction ? ((Fittable1DFunction)this.f).getIncludeParametersInFit()[n] : false;
                return new Boolean(bl);
            }
            if (n2 == 3 && this.f instanceof Fittable1DFunction && (fitter = (fittable1DFunction = (Fittable1DFunction)this.f).getFit()) != null) {
                boolean[] blArray = fittable1DFunction.getIncludeParametersInFit();
                if (!blArray[n]) {
                    return "Not in fit";
                }
                int n3 = 0;
                int n4 = 0;
                while (n3 < n) {
                    if (blArray[n3]) {
                        ++n4;
                    }
                    ++n3;
                }
                return JASHistPropFunctions.this.format.format(fitter.getParameterSigmas()[n4]);
            }
            return null;
        }

        public String getColumnName(int n) {
            return this.columns[n];
        }

        public Class getColumnClass(int n) {
            if (n == 2) {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = JASHistPropFunctions.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            if (n == 1) {
                return class$java$lang$String == null ? (class$java$lang$String = JASHistPropFunctions.class$("java.lang.String")) : class$java$lang$String;
            }
            return super.getColumnClass(n);
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 2 || n2 == 1;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 1) {
                try {
                    double d = Double.valueOf((String)object);
                    this.f.setParameter(n, d);
                }
                catch (InvalidFunctionParameter invalidFunctionParameter) {
                    JASHistPropFunctions.this.getToolkit().beep();
                }
                catch (NumberFormatException numberFormatException) {
                    JASHistPropFunctions.this.getToolkit().beep();
                }
            } else if (n2 == 2) {
                if (this.f instanceof Fittable1DFunction) {
                    boolean bl = (Boolean)object;
                    ((Fittable1DFunction)this.f).setIncludeParameterInFit(n, bl);
                } else {
                    JASHistPropFunctions.this.getToolkit().beep();
                }
            }
        }
    }

    private class RemoveButtonListener
    implements ActionListener {
        private RemoveButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JASHistPropFunctions.this.removeFunction();
        }
    }

    private class AddButtonListener
    implements ActionListener {
        private AddButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FunctionRegistry functionRegistry = FunctionRegistry.instance();
            Container container = JASHistPropFunctions.this;
            while (!(container instanceof Frame)) {
                container = container.getParent();
            }
            FunctionFactory functionFactory = functionRegistry.chooseFunction((Frame)container);
            if (functionFactory != null) {
                try {
                    Basic1DFunction basic1DFunction = functionFactory.createFunction(JASHistPropFunctions.this.m_jHist);
                    JASHistData jASHistData = JASHistPropFunctions.this.m_jHist.addData(basic1DFunction);
                    jASHistData.show(true);
                    JASHistPropFunctions.this.addFunction((JASHist1DFunctionData)jASHistData);
                    if (basic1DFunction instanceof FunctionAdvancedOptions) {
                        basic1DFunction.addObserver(JASHistPropFunctions.this.m_listNameChangeListener);
                    }
                }
                catch (FunctionFactoryError functionFactoryError) {
                    functionFactoryError.printStackTrace();
                }
            }
        }
    }
}

