/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.FixedHeightPanel;
import jas.hist.JASHistAxis;
import jas.util.DateChooser;
import jas.util.JASTextField;
import jas.util.JTextFieldBinding;
import jas.util.PropertyBinding;
import jas.util.PropertyPage;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import tablelayout.TableLayout;

final class JASHistPropAxis
extends PropertyPage
implements ActionListener {
    private JASTextField min;
    private JASTextField max;
    private JButton t1;
    private JButton t2;
    private int m_axisType;
    private JASTextField m_bins;
    private JASTextField m_binw;
    private JPanel m_binsPanel;
    private JPanel m_rangePanel;
    private JComboBox m_binwUnits;
    private JLabel m_type;
    private JCheckBox m_zero;
    private JCheckBox m_log;
    private JCheckBox m_showOverflow;
    private String[] types = new String[]{"", "Numeric", "String", "Date/Time"};
    private boolean init = false;

    public JASHistPropAxis() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.createTopPanel());
        this.add(this.createRangePanel());
        this.add(this.createBinsPanel());
        this.add(Box.createVerticalGlue());
    }

    private JPanel createTopPanel() {
        JASTextField jASTextField = new JASTextField(20);
        this.m_log = new JCheckBox("Logarithmic");
        this.m_log.setMnemonic('L');
        this.m_type = new JLabel();
        this.addBinding(new PropertyBinding(jASTextField, "Label"));
        this.addBinding(new PropertyBinding(this.m_log, "logarithmic"));
        FixedHeightPanel fixedHeightPanel = new FixedHeightPanel(new TableLayout());
        fixedHeightPanel.add("0 0 rw", new JLabel("Label:"));
        fixedHeightPanel.add("0 1 rw", new JLabel("Type:"));
        fixedHeightPanel.add("1 0 2", jASTextField);
        fixedHeightPanel.add("1 1", this.m_type);
        fixedHeightPanel.add("2 1", this.m_log);
        return fixedHeightPanel;
    }

    private JPanel createRangePanel() {
        this.min = new JASTextField(15);
        this.max = new JASTextField(15);
        JCheckBox jCheckBox = new JCheckBox("Automatic");
        jCheckBox.setMnemonic('u');
        this.m_zero = new JCheckBox("Allow Suppressed Zero");
        this.m_zero.setMnemonic('Z');
        this.t1 = new JButton("...");
        this.t2 = new JButton("...");
        this.addBinding(new PropertyBinding(jCheckBox, "RangeAutomatic"));
        this.addBinding(new PropertyBinding(this.m_zero, "AllowSuppressedZero"));
        this.t1.addActionListener(this);
        this.t2.addActionListener(this);
        FixedHeightPanel fixedHeightPanel = new FixedHeightPanel(new TableLayout());
        fixedHeightPanel.setBorder(new TitledBorder("Range"));
        fixedHeightPanel.add("0 0 rw", new JLabel("Min:"));
        fixedHeightPanel.add("0 1 rw", new JLabel("Max:"));
        fixedHeightPanel.add("1 0 h", this.min);
        fixedHeightPanel.add("1 1 h", this.max);
        fixedHeightPanel.add("2 0 w", this.t1);
        fixedHeightPanel.add("2 1 w", this.t2);
        fixedHeightPanel.add("3 0 lW", jCheckBox);
        fixedHeightPanel.add("3 1 lW", this.m_zero);
        this.m_rangePanel = fixedHeightPanel;
        return fixedHeightPanel;
    }

    private JPanel createBinsPanel() {
        this.m_bins = new JASTextField(10);
        this.m_binw = new JASTextField(10);
        this.m_binwUnits = new JComboBox();
        this.m_binwUnits.addItem("Default Units");
        this.m_binwUnits.addItem("Seconds");
        this.m_binwUnits.addItem("Minutes");
        this.m_binwUnits.addItem("Hours");
        this.m_binwUnits.addItem("Days");
        this.m_binwUnits.addItem("Weeks");
        this.m_binwUnits.addItem("Years");
        this.m_showOverflow = new JCheckBox("Under/Overflow");
        FixedHeightPanel fixedHeightPanel = new FixedHeightPanel(new FlowLayout(0));
        fixedHeightPanel.setBorder(new TitledBorder("Binning"));
        fixedHeightPanel.add(new JLabel("Bins:"));
        fixedHeightPanel.add(this.m_bins);
        fixedHeightPanel.add(new JLabel("Bin Width:"));
        fixedHeightPanel.add(this.m_binw);
        fixedHeightPanel.add(this.m_binwUnits);
        fixedHeightPanel.add(this.m_showOverflow);
        this.m_binsPanel = fixedHeightPanel;
        return fixedHeightPanel;
    }

    public void doDataExchange(boolean bl, Object object) {
        JASHistAxis jASHistAxis = (JASHistAxis)object;
        this.m_axisType = jASHistAxis.getAxisType();
        if (!this.init) {
            this.init = true;
            if (this.m_axisType != 2) {
                this.addBinding(new PropertyBinding(new MinMaxFieldBinding(this.min), "MinObject"));
                this.addBinding(new PropertyBinding(new MinMaxFieldBinding(this.max), "MaxObject"));
                this.addBinding(new PropertyBinding(this.m_bins, "Bins", jASHistAxis.isBinned() ? (byte)7 : 0));
                this.addBinding(new PropertyBinding(new BinWidthFieldBinding(this.m_binw), "BinWidth"));
                this.addBinding(new PropertyBinding(this.m_showOverflow, "ShowOverflows"));
            }
        }
        if (!bl) {
            boolean bl2 = jASHistAxis.isBinned();
            this.m_binsPanel.setEnabled(bl2);
            bl2 = this.m_axisType != 2;
            this.m_rangePanel.setEnabled(bl2);
            this.m_log.setEnabled(bl2);
            this.m_zero.setEnabled(bl2 &= jASHistAxis.getRangeAutomatic());
            bl2 = this.m_axisType == 3;
            this.t1.setEnabled(bl2);
            this.t2.setEnabled(bl2);
            this.m_type.setText(this.types[this.m_axisType]);
        }
        super.doDataExchange(bl, object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Date date;
        DateChooser dateChooser;
        Container container = this;
        while (!(container instanceof Frame)) {
            container = container.getParent();
        }
        if (actionEvent.getSource() == this.t1) {
            Date date2 = new Date(this.min.getText());
            DateChooser dateChooser2 = new DateChooser((Frame)container, date2);
            if (dateChooser2.doModal()) {
                this.min.setText(dateChooser2.getDate().toString());
            }
        } else if (actionEvent.getSource() == this.t2 && (dateChooser = new DateChooser((Frame)container, date = new Date(this.max.getText()))).doModal()) {
            this.max.setText(dateChooser.getDate().toString());
        }
    }

    private final class BinWidthFieldBinding
    extends JTextFieldBinding
    implements ActionListener {
        private boolean conversionIndexIsDefault = true;
        private int conversionIndex;
        private double[] conversion = new double[]{1.0, 1.0, 60.0, 3600.0, 86400.0, 604800.0, 3.1536E7};

        BinWidthFieldBinding(JASTextField jASTextField) {
            super(jASTextField, (byte)1);
            JASHistPropAxis.this.m_binwUnits.addActionListener(this);
        }

        protected String setValue(Object object) {
            if (JASHistPropAxis.this.m_axisType == 3) {
                double d = (Double)object;
                if (this.conversionIndexIsDefault) {
                    int n = 1;
                    while (++n != this.conversion.length && !(d / this.conversion[n] < 1.0)) {
                    }
                    this.conversionIndex = n - 1;
                }
                JASHistPropAxis.this.m_binwUnits.setEnabled(true);
                JASHistPropAxis.this.m_binwUnits.setSelectedIndex(this.conversionIndex);
                return String.valueOf(d / this.conversion[this.conversionIndex]);
            }
            this.conversionIndex = 0;
            JASHistPropAxis.this.m_binwUnits.setEnabled(false);
            JASHistPropAxis.this.m_binwUnits.setSelectedIndex(this.conversionIndex);
            return object.toString();
        }

        protected Object getValue(String string, Class clazz) {
            double d = Double.valueOf(string);
            return new Double(d *= this.conversion[this.conversionIndex]);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = JASHistPropAxis.this.m_binwUnits.getSelectedIndex();
            if (n == this.conversionIndex) {
                return;
            }
            String string = JASHistPropAxis.this.m_binw.getText();
            double d = Double.valueOf(string);
            d *= this.conversion[this.conversionIndex];
            this.conversionIndex = n;
            JASHistPropAxis.this.m_binw.setText(String.valueOf(d /= this.conversion[this.conversionIndex]));
            this.conversionIndexIsDefault = false;
        }
    }

    private final class MinMaxFieldBinding
    extends JTextFieldBinding {
        MinMaxFieldBinding(JASTextField jASTextField) {
            super(jASTextField);
        }

        protected Object getValue(String string, Class clazz) {
            if (JASHistPropAxis.this.m_axisType == 3) {
                return new Date(string);
            }
            return new Double(string);
        }
    }
}

