/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.Basic1DFunction;
import jas.hist.FunctionValueUndefined;
import jas.hist.JASHist1DFunctionData;
import jas.hist.JASHist1DFunctionStyle;
import jas.hist.OverlayWithHandles;
import jas.plot.CoordinateTransformation;
import jas.plot.DoubleCoordinateTransformation;
import jas.plot.PlotGraphics;

class JASHistFunctionOverlay
extends OverlayWithHandles {
    private JASHist1DFunctionStyle style;
    private JASHist1DFunctionData source;
    private double xmin;
    private double xmax;

    JASHistFunctionOverlay(JASHist1DFunctionData jASHist1DFunctionData, JASHist1DFunctionStyle jASHist1DFunctionStyle) {
        super(jASHist1DFunctionData.getDataSource());
        this.source = jASHist1DFunctionData;
        this.style = jASHist1DFunctionStyle;
    }

    void setXRange(double d, double d2) {
        this.xmin = d;
        this.xmax = d2;
    }

    public void paint(PlotGraphics plotGraphics) {
        CoordinateTransformation coordinateTransformation = this.container.getXTransformation();
        CoordinateTransformation coordinateTransformation2 = this.container.getYTransformation(this.source.getYAxis());
        Basic1DFunction basic1DFunction = (Basic1DFunction)this.source.getDataSource();
        if (coordinateTransformation instanceof DoubleCoordinateTransformation && coordinateTransformation2 instanceof DoubleCoordinateTransformation) {
            DoubleCoordinateTransformation doubleCoordinateTransformation = (DoubleCoordinateTransformation)coordinateTransformation;
            DoubleCoordinateTransformation doubleCoordinateTransformation2 = (DoubleCoordinateTransformation)coordinateTransformation2;
            plotGraphics.setTransformation(doubleCoordinateTransformation, doubleCoordinateTransformation2);
            double d = (this.xmax - this.xmin) / (doubleCoordinateTransformation.convert(this.xmax) - doubleCoordinateTransformation.convert(this.xmin));
            double d2 = this.xmin;
            double d3 = Double.NEGATIVE_INFINITY;
            plotGraphics.setColor(this.style.getLineColor());
            double d4 = this.xmin;
            while (d4 < this.xmax) {
                try {
                    double d5 = basic1DFunction.valueAt(d4);
                    if (d3 != Double.NEGATIVE_INFINITY) {
                        plotGraphics.drawLine(d2, d3, d4, d5);
                    }
                    d3 = d5;
                    d2 = d4;
                }
                catch (FunctionValueUndefined functionValueUndefined) {
                    d3 = Double.NEGATIVE_INFINITY;
                }
                d4 += d;
            }
            super.paint(plotGraphics);
        }
    }
}

