/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.JASHistStyle;
import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class JASHist2DHistogramStyle
extends JASHistStyle
implements Serializable {
    public static final int STYLE_BOX = 0;
    public static final int STYLE_ELLIPSE = 1;
    public static final int STYLE_COLORMAP = 2;
    public static final int STYLE_3DLEGOPLOT = 3;
    public static final int STYLE_3DSURFACEPLOT = 4;
    public static final int COLORMAP_WARM = 0;
    public static final int COLORMAP_COOL = 1;
    public static final int COLORMAP_THERMAL = 2;
    public static final int COLORMAP_RAINBOW = 3;
    public static final int COLORMAP_GRAYSCALE = 4;
    public static final int COLORMAP_USERDEFINED = 5;
    static final Color[] lineColors = new Color[]{Color.blue, Color.red, Color.darkGray, new Color(0, 145, 0)};
    static final Color[] overflowColors = new Color[lineColors.length];
    static int n;
    static final int[] histStyles;
    static final int[] colorMapSchemes;
    private int m2D_dataHistStyles;
    private int m2D_dataColorMapScheme;
    private Color m2D_shapeColor;
    private Color m2D_overFlowBinColor;
    private Color m2D_startDataColor;
    private Color m2D_endDataColor;
    private boolean m2D_dataOverFlow;
    private boolean m2D_dataShowPlot;
    private boolean m2D_invertColorRange;
    private boolean m2d_logZ;
    static final long serialVersionUID = 5704864807779848936L;

    static final int getHistStyle(String string) {
        if (string.equals("STYLE_BOX")) {
            return 0;
        }
        if (string.equals("STYLE_ELLIPSE")) {
            return 1;
        }
        if (string.equals("STYLE_COLORMAP")) {
            return 2;
        }
        System.out.println("Unrecognized style " + string + ". Using STYLE_BOX instead.");
        return 0;
    }

    static final int getColorMapScheme(String string) {
        if (string.equals("COLORMAP_WARM")) {
            return 0;
        }
        if (string.equals("COLORMAP_COOL")) {
            return 1;
        }
        if (string.equals("COLORMAP_THERMAL")) {
            return 2;
        }
        if (string.equals("COLORMAP_RAINBOW")) {
            return 3;
        }
        if (string.equals("COLORMAP_GRAYSCALE")) {
            return 4;
        }
        if (string.equals("COLORMAP_USERDEFINED")) {
            return 5;
        }
        System.out.println("Unrecognized color map " + string + ". Using COLORMAP_WARM instead.");
        return 0;
    }

    static final String getHistStyleName(int n) {
        String[] stringArray = new String[]{"STYLE_BOX", "STYLE_ELLIPSE", "STYLE_COLORMAP"};
        return stringArray[n];
    }

    static final String getColorMapSchemeName(int n) {
        String[] stringArray = new String[]{"COLORMAP_WARM", "COLORMAP_COOL", "COLORMAP_THERMAL", "COLORMAP_RAINBOW", "COLORMAP_GRAYSCALE", "COLORMAP_USERDEFINED"};
        return stringArray[n];
    }

    public JASHist2DHistogramStyle() {
        this.initTransientData();
        this.m2D_dataOverFlow = false;
        this.m2D_dataHistStyles = histStyles[0];
        this.m2D_dataColorMapScheme = colorMapSchemes[0];
        this.m2D_shapeColor = lineColors[n];
        this.m2D_overFlowBinColor = overflowColors[n++];
        if (n == lineColors.length) {
            n = 0;
        }
        this.m2D_startDataColor = new Color(255, 255, 255);
        this.m2D_endDataColor = new Color(0, 0, 0);
        this.m2D_dataShowPlot = true;
    }

    public int getHistStyle() {
        return this.m2D_dataHistStyles;
    }

    public void setHistStyle(int n) {
        this.m2D_dataHistStyles = n;
        this.changeNotify();
    }

    public int getColorMapScheme() {
        return this.m2D_dataColorMapScheme;
    }

    public void setColorMapScheme(int n) {
        this.m2D_dataColorMapScheme = n;
        this.changeNotify();
    }

    public Color getShapeColor() {
        return this.m2D_shapeColor;
    }

    public void setShapeColor(Color color) {
        this.m2D_shapeColor = color;
        this.changeNotify();
    }

    public Color getOverflowBinColor() {
        return this.m2D_overFlowBinColor;
    }

    public void setOverflowBinColor(Color color) {
        this.m2D_overFlowBinColor = color;
        this.changeNotify();
    }

    public Color getStartDataColor() {
        return this.m2D_startDataColor;
    }

    public void setStartDataColor(Color color) {
        this.m2D_startDataColor = color;
        this.changeNotify();
    }

    public Color getEndDataColor() {
        return this.m2D_endDataColor;
    }

    public void setEndDataColor(Color color) {
        this.m2D_endDataColor = color;
        this.changeNotify();
    }

    public boolean getShowOverflow() {
        return this.m2D_dataOverFlow;
    }

    public void setShowOverflow(boolean bl) {
        this.m2D_dataOverFlow = bl;
        this.changeNotify();
    }

    public boolean getLogZ() {
        return this.m2d_logZ;
    }

    public void setLogZ(boolean bl) {
        this.m2d_logZ = bl;
        this.changeNotify();
    }

    public boolean getShowPlot() {
        return this.m2D_dataShowPlot;
    }

    public void setShowPlot(boolean bl) {
        this.m2D_dataShowPlot = bl;
        this.changeNotify();
    }

    protected void changeNotify() {
        super.changeNotify();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initTransientData();
    }

    private void initTransientData() {
    }

    static {
        int n = 0;
        while (n < lineColors.length) {
            JASHist2DHistogramStyle.overflowColors[n] = lineColors[n].darker();
            ++n;
        }
        JASHist2DHistogramStyle.n = 0;
        histStyles = new int[]{0, 1, 2};
        colorMapSchemes = new int[]{0, 1, 2, 3, 4, 5};
    }
}

