/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.BinnedDataManager;
import jas.hist.DataManagerException;
import jas.hist.DataSource;
import jas.hist.JASHist;
import jas.hist.JASHistData;
import jas.hist.Rebinnable1DHistogramData;
import jas.hist.StatisticsBlock;
import jas.hist.XYDataSource;
import jas.plot.DataArea;
import jas.plot.DoubleAxis;
import jas.plot.Legend;

final class IntegerDataManager
extends BinnedDataManager {
    private DoubleAxis xAxis = new DoubleAxis();
    private int targetBins;

    IntegerDataManager(JASHist jASHist, DataArea dataArea, Legend legend, StatisticsBlock statisticsBlock, int n) {
        super(jASHist, dataArea, legend, statisticsBlock, n);
        DoubleAxis doubleAxis = new DoubleAxis();
        doubleAxis.setUseSuggestedRange(true);
        this.xm.setDataManager(this, true, this.xAxis);
        this.ym[0].setDataManager(this, false, doubleAxis);
        new BinnedDataManager.DoubleAxisListener(this.xm);
        this.xm.setBins(n);
        this.targetBins = n;
    }

    JASHistData add(DataSource dataSource) {
        XYDataSource xYDataSource;
        Rebinnable1DHistogramData rebinnable1DHistogramData;
        if (dataSource instanceof Rebinnable1DHistogramData ? (rebinnable1DHistogramData = (Rebinnable1DHistogramData)dataSource).getAxisType() != 4 : (xYDataSource = (XYDataSource)dataSource).getAxisType() != 4) {
            throw new DataManagerException("Incompatible data type for axis");
        }
        return super.add(dataSource);
    }

    protected void calcMinMaxBins(double d, double d2) {
        int n = (int)(1.0 + (d2 - d) / (double)this.targetBins);
        int n2 = (int)(1.0 + (d2 - d) / (double)n);
        this.xLow = d - 0.5;
        this.xHigh = this.xLow + (double)(n * n2);
        double d3 = this.xAxis.getPlotMin();
        double d4 = this.xAxis.getPlotMax();
        if (this.xLow != d3 || this.xHigh != d4) {
            this.xm.setBins(n2);
            this.xAxis.setMin(this.xLow);
            this.xAxis.setMax(this.xHigh);
            this.xAxis.getAxis().invalidate();
        }
    }
}

