/*
 * Decompiled with CFR 0.152.
 */
package jas.hep;

import hep.analysis.Style;
import hep.analysis.partition.Abstract1DPartition;
import jas.hep.PartitionAdapter;
import jas.hist.CustomOverlay;
import jas.hist.HasStyle;
import jas.hist.JASHist1DHistogramStyle;
import jas.hist.JASHistStyle;
import jas.hist.Rebinnable1DHistogramData;
import java.awt.Color;
import java.util.Observable;

class Partition1DAdapter
extends PartitionAdapter
implements Rebinnable1DHistogramData,
HasStyle {
    private Abstract1DPartition m_partition;

    Partition1DAdapter(Abstract1DPartition abstract1DPartition) {
        super((Observable)abstract1DPartition);
        this.m_partition = abstract1DPartition;
    }

    public double[][] rebin(int n, double d, double d2, boolean bl, boolean bl2) {
        int n2 = 1;
        if (this.m_partition.isRebinnable()) {
            this.m_partition.setBinning(n, d, d2);
        }
        if (bl) {
            n2 = this.m_partition.hasSimpleQuadraticErrorBars() ? 1 : (this.m_partition.hasAsymmetricErrorBars() ? 3 : 2);
        }
        double[][] dArrayArray = new double[n2][];
        dArrayArray[0] = this.m_partition.getBins();
        if (n2 > 1) {
            dArrayArray[1] = this.m_partition.getPlusErrors();
        }
        if (n2 > 2) {
            dArrayArray[2] = this.m_partition.getMinusErrors();
        }
        return dArrayArray;
    }

    public double getMin() {
        return this.m_partition.getMin();
    }

    public double getMax() {
        return this.m_partition.getMax();
    }

    public int getBins() {
        return this.m_partition.getNumberOfBins();
    }

    public int getAxisType() {
        return this.m_partition.getAxisType();
    }

    public boolean isRebinnable() {
        return this.m_partition.isRebinnable();
    }

    public String[] getAxisLabels() {
        return this.m_partition.getAxisLabels();
    }

    public JASHistStyle getStyle() {
        Style style = this.m_partition.getStyle();
        if (style == null) {
            return null;
        }
        JASHist1DHistogramStyle jASHist1DHistogramStyle = new JASHist1DHistogramStyle();
        if (style.get((Object)"dataPointColor") != null) {
            jASHist1DHistogramStyle.setDataPointColor((Color)style.get((Object)"dataPointColor"));
        }
        if (style.get((Object)"errorBarColor") != null) {
            jASHist1DHistogramStyle.setErrorBarColor((Color)style.get((Object)"errorBarColor"));
        }
        if (style.get((Object)"histogramBarColor") != null) {
            jASHist1DHistogramStyle.setHistogramBarColor((Color)style.get((Object)"histogramBarColor"));
        }
        if (style.get((Object)"lineColor") != null) {
            jASHist1DHistogramStyle.setLineColor((Color)style.get((Object)"lineColor"));
        }
        if (style.get((Object)"showErrorBars") != null) {
            jASHist1DHistogramStyle.setShowErrorBars((Boolean)style.get((Object)"showErrorBars"));
        }
        if (style.get((Object)"showHistogramBars") != null) {
            jASHist1DHistogramStyle.setShowHistogramBars((Boolean)style.get((Object)"showHistogramBars"));
        }
        if (style.get((Object)"showLinesBetweenPoints") != null) {
            jASHist1DHistogramStyle.setShowLinesBetweenPoints((Boolean)style.get((Object)"showLinesBetweenPoints"));
        }
        if (style.get((Object)"showDataPoints") != null) {
            jASHist1DHistogramStyle.setShowDataPoints((Boolean)style.get((Object)"showDataPoints"));
        }
        if (style.get((Object)"histogramFill") != null) {
            jASHist1DHistogramStyle.setHistogramFill((Boolean)style.get((Object)"histogramFill"));
        }
        if (style.get((Object)"dataPointSize") != null) {
            jASHist1DHistogramStyle.setDataPointSize((Integer)style.get((Object)"dataPointSize"));
        }
        if (style.get((Object)"dataPointSymbol") != null) {
            jASHist1DHistogramStyle.setDataPointStyle((Integer)style.get((Object)"dataPointSymbol"));
        }
        if (style.get((Object)"customOverlay") != null) {
            jASHist1DHistogramStyle.setCustomOverlay((CustomOverlay)style.get((Object)"customOverlay"));
        }
        return jASHist1DHistogramStyle;
    }
}

