/*
 * Decompiled with CFR 0.152.
 */
package PLUI;

import PLUI.LearnerThread;
import PLUI.NatClass;
import PLUI.NatClassContainer;
import PLUI.PhoneticSymbol;
import PLUI.WarningException;
import PLUI.WorkingDlg;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class PLData {
    public static final String INITFILENAME = "PLsettings.ini";
    public static final String INITFOLDERFILENAME = "PLfolder.ini";
    private static final String TEMPDIR = "temp";
    private static final String OUTPUTDIR = "output";
    private static final String LOGFILENAME = "ProgramTrace.txt";
    private static final String RUNSETTINGSFILENAME = "LearnerSettings.txt";
    private static final String NATCLASSESFILENAME = "NatClassesFile.txt";
    private static final String TEMPFEATCHARTFILENAME = "tempFeatureChart.tmp";
    private static final String TEMPFEATLISTFILENAME = "tempFeatureList.tmp";
    private static final String TEMPTRAININGFILENAME = "tempLearningFile.tmp";
    private static final String TEMPTESTINGFILENAME = "tempTestingFile.tmp";
    private static final String TEMPPROJECTIONSFILENAME = "tempProjections.tmp";
    private static final String TEMPTIERGRAMSIZEFILENAME = "tempTierGramSizeFile.tmp";
    private static final String TEMPCONSTRAINTSFILENAME = "tempConstraints.tmp";
    private static final String TEMPCOPIEDTRAININGFILENAME = "tempTestFile.tmp";
    private static final int DEFGRAMSIZE = 3;
    private transient JFrame Parent;
    private String MaxConstraints;
    private String Sigma2;
    private String LearningSampleSize;
    private String MaxGramSize;
    private String MaxOE;
    private String Smoothing;
    private String MaxPath;
    private boolean AllowComplements;
    private String JavaExec;
    private String FilesLoc;
    private String[] Files;
    private int Task;
    static final int FEAT = 0;
    static final int TEST = 1;
    static final int TRAINING = 2;
    static final int NGRAM = 3;
    static final int ACCURACY = 4;
    static final int CONSTR = 5;
    static final int TIERS = 6;
    static final int NUMFILES = 7;
    private transient String[] Features;
    private transient LinkedList phonSymbols;
    private transient NatClassContainer Classes;
    private transient LinkedHashSet Tiers;
    private transient boolean ChangedFlag;
    private transient LearnerThread workerThread;
    private transient boolean ConstraintsAndWeights;
    private transient int userMaxGramSize;

    String InitFilename() {
        return this.FilesLoc + File.separator + INITFILENAME;
    }

    String FullFilename(String s) {
        return (this.FilesLoc + File.separator + s).trim();
    }

    String QuotedFilename(String s) {
        return '\"' + (this.FilesLoc + File.separator + s).trim() + '\"';
    }

    String TempFilename(String s) {
        return (this.FilesLoc + File.separator + TEMPDIR + File.separator + s).trim();
    }

    String TempDir() {
        return this.FilesLoc + File.separator + TEMPDIR;
    }

    String OutputDir() {
        return this.FilesLoc + File.separator + OUTPUTDIR;
    }

    String OutputFilename(String s) {
        return this.FilesLoc + File.separator + OUTPUTDIR + File.separator + s;
    }

    String TempFilenameOnly(String s) {
        return (TEMPDIR + File.separator + s).trim();
    }

    String FullFilenameOnly(String s) {
        return s;
    }

    private boolean isSegment(String s) {
        for (PhoneticSymbol ps : this.phonSymbols) {
            if (!s.equals(ps.Symbol)) continue;
            return true;
        }
        return false;
    }

    private boolean isTier(String s) {
        Iterator i = this.Tiers.iterator();
        while (i.hasNext()) {
            if (!s.equals((String)i.next())) continue;
            return true;
        }
        return false;
    }

    private boolean isFeature(String s) {
        int i = 0;
        while (i < this.Features.length && this.Features[i] != null) {
            if (!this.Features[i++].equals(s)) continue;
            return true;
        }
        return false;
    }

    private boolean isValuedFeature(String s) {
        if (s.charAt(0) != '+' && s.charAt(0) != '-' && s.charAt(0) != '0') {
            return false;
        }
        return this.isFeature(s.substring(1).trim());
    }

    private boolean isStrictlyValuedFeature(String s) {
        if (s.charAt(0) != '+' && s.charAt(0) != '-') {
            return false;
        }
        return this.isFeature(s.substring(1).trim());
    }

    int FindSpace(String s, int begin) {
        while (begin < s.length()) {
            char c = s.charAt(begin);
            if (c == '\t' || c == ' ') {
                return begin;
            }
            ++begin;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PLData(JFrame parent) {
        this.ClearSettings();
        this.Parent = parent;
        this.ChangedFlag = false;
        this.FilesLoc = "";
        try {
            BufferedReader file = new BufferedReader(new FileReader(INITFOLDERFILENAME));
            try {
                this.FilesLoc = file.readLine();
            }
            catch (Exception exception) {
            }
            finally {
                file.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void ClearSettings() {
        this.AllowComplements = false;
        this.Task = 0;
        this.MaxConstraints = new String();
        this.Sigma2 = new String();
        this.LearningSampleSize = new String();
        this.MaxGramSize = new String();
        this.MaxOE = new String();
        this.Smoothing = new String();
        this.MaxPath = new String();
        this.Files = new String[7];
        for (int i = 0; i < 7; ++i) {
            this.Files[i] = new String();
        }
    }

    void WriteFilesLocToFile() {
        if (this.FilesLoc.trim().length() == 0) {
            return;
        }
        BufferedWriter file = null;
        try {
            file = new BufferedWriter(new FileWriter(INITFOLDERFILENAME));
            file.write(this.FilesLoc);
            file.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            File f = new File(INITFOLDERFILENAME);
            JOptionPane.showMessageDialog(this.Parent, "Error writing Working Folder to file:\n" + f.getAbsolutePath() + "\n" + ex.getMessage() + ".\nYour settings will not be saved.");
        }
    }

    public void ReadSettingsFromFile() {
        BufferedReader file = null;
        if (this.FilesLoc.trim().length() == 0) {
            return;
        }
        File f = new File(this.FilesLoc);
        if (!f.isDirectory()) {
            JOptionPane.showMessageDialog(this.Parent, "Folder for input files does not exist.  Please select a valid Working Folder.");
            return;
        }
        try {
            String line;
            this.ClearSettings();
            file = new BufferedReader(new FileReader(this.InitFilename()));
            while ((line = file.readLine()) != null) {
                int space;
                if ((line = line.trim()).equals("") || line.charAt(0) == ';' || (space = this.FindSpace(line, 0)) < 0) continue;
                String field = line.substring(0, space).trim();
                if (field.equals("Task")) {
                    this.Task = new Integer(line.substring(space + 1));
                }
                if (field.equals("MaxConstraints")) {
                    this.MaxConstraints = line.substring(space + 1).trim();
                }
                if (field.equals("Sigma2")) {
                    this.Sigma2 = line.substring(space + 1).trim();
                }
                if (field.equals("LearningSampleSize")) {
                    this.LearningSampleSize = line.substring(space + 1).trim();
                }
                if (field.equals("MaxGramSize")) {
                    this.MaxGramSize = line.substring(space + 1).trim();
                }
                if (field.equals("MaxOE")) {
                    this.MaxOE = line.substring(space + 1).trim();
                }
                if (field.equals("Smoothing")) {
                    this.Smoothing = line.substring(space + 1).trim();
                }
                if (field.equals("MaxPath")) {
                    this.MaxPath = line.substring(space + 1).trim();
                }
                if (field.equals("AllowComplements")) {
                    boolean bl = this.AllowComplements = line.substring(space + 1).trim().equals("true");
                }
                if (field.equals("FeatureFile")) {
                    this.Files[0] = line.substring(space + 1).trim();
                }
                if (field.equals("LearningFile")) {
                    this.Files[2] = line.substring(space + 1).trim();
                }
                if (field.equals("TestFile")) {
                    this.Files[1] = line.substring(space + 1).trim();
                }
                if (field.equals("ProjectionsFile")) {
                    this.Files[6] = line.substring(space + 1).trim();
                }
                if (field.equals("NGramConstraints")) {
                    this.Files[3] = line.substring(space + 1).trim();
                }
                if (!field.equals("UserConstraints")) continue;
                this.Files[5] = line.substring(space + 1).trim();
            }
            file.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void WriteSettingsToFile() {
        this.WriteSettingsToFile(this.InitFilename());
    }

    void WriteSettingsToFile(String filename) {
        BufferedWriter file = null;
        if (this.FilesLoc.trim().length() == 0) {
            return;
        }
        File f = new File(this.FilesLoc);
        if (!f.isDirectory()) {
            return;
        }
        try {
            file = new BufferedWriter(new FileWriter(filename));
            file.write("; This file is a record of the settings for a run of the phonotactic learning program, indicating time of run and the settings that were used.");
            file.newLine();
            file.write("; Where a field is left blank, it means that the default setting for the program was used (see manual).");
            file.newLine();
            file.write("; ");
            file.newLine();
            file.write("; Location of the input files:  " + this.FilesLoc);
            file.newLine();
            file.write("; Time and date that the program ran:  " + new Date(System.currentTimeMillis()).toString());
            file.newLine();
            file.newLine();
            file.write("Task ");
            file.write(Integer.toString(this.Task));
            file.newLine();
            file.write("FeatureFile ");
            file.write(this.Files[0]);
            file.newLine();
            file.write("LearningFile ");
            file.write(this.Files[2]);
            file.newLine();
            file.write("TestFile ");
            file.write(this.Files[1]);
            file.newLine();
            file.write("ProjectionsFile ");
            file.write(this.Files[6]);
            file.newLine();
            file.write("NGramConstraints ");
            file.write(this.Files[3]);
            file.newLine();
            file.write("UserConstraints ");
            file.write(this.Files[5]);
            file.newLine();
            file.write("MaxConstraints ");
            file.write(this.MaxConstraints);
            file.newLine();
            file.write("Sigma2 ");
            file.write(this.Sigma2);
            file.newLine();
            file.write("LearningSampleSize ");
            file.write(this.LearningSampleSize);
            file.newLine();
            file.write("MaxGramSize ");
            file.write(this.MaxGramSize);
            file.newLine();
            file.write("MaxOE ");
            file.write(this.MaxOE);
            file.newLine();
            file.write("Smoothing ");
            file.write(this.Smoothing);
            file.newLine();
            file.write("MaxPath ");
            file.write(this.MaxPath);
            file.newLine();
            file.write("AllowComplements ");
            file.write(this.AllowComplements ? "true" : "false");
            file.newLine();
            file.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this.Parent, "Error writting settings to file: " + ex.getMessage());
        }
    }

    public int GetTask() {
        return this.Task;
    }

    public boolean GetAllowComplements() {
        return this.AllowComplements;
    }

    public String GetMaxConstraints() {
        return this.MaxConstraints.toString();
    }

    public String GetSigma2() {
        return this.Sigma2.toString();
    }

    public String GetLearningSampleSize() {
        return this.LearningSampleSize.toString();
    }

    public String GetMaxGramSize() {
        return this.MaxGramSize.toString();
    }

    public String GetMaxOE() {
        return this.MaxOE.toString();
    }

    public String GetSmoothing() {
        return this.Smoothing.toString();
    }

    public String GetMaxPath() {
        return this.MaxPath.toString();
    }

    public String GetFile(int index) {
        return this.Files[index];
    }

    public String GetFileLoc() {
        return this.FilesLoc;
    }

    public String GetJavaExec() {
        return this.JavaExec;
    }

    public void ClearChangedFlag() {
        this.ChangedFlag = false;
    }

    public boolean GetChangedFlag() {
        return this.ChangedFlag;
    }

    public void SetTask(int i) {
        if (this.Task != i) {
            this.ChangedFlag = true;
        }
        this.Task = i;
    }

    public void SetAllowComplements(boolean state) {
        if (this.AllowComplements != state) {
            this.ChangedFlag = true;
        }
        this.AllowComplements = state;
    }

    public void SetMaxConstraints(String s) {
        if (!s.equals(this.MaxConstraints)) {
            this.ChangedFlag = true;
        }
        this.MaxConstraints = new String(s.trim());
    }

    public void SetSigma2(String s) {
        if (!s.equals(this.Sigma2)) {
            this.ChangedFlag = true;
        }
        this.Sigma2 = new String(s.trim());
    }

    public void SetLearningSampleSize(String s) {
        if (!s.equals(this.LearningSampleSize)) {
            this.ChangedFlag = true;
        }
        this.LearningSampleSize = new String(s.trim());
    }

    public void SetMaxGramSize(String s) {
        if (!s.equals(this.MaxGramSize)) {
            this.ChangedFlag = true;
        }
        this.MaxGramSize = new String(s.trim());
    }

    public void SetMaxOE(String s) {
        if (!s.equals(this.MaxOE)) {
            this.ChangedFlag = true;
        }
        this.MaxOE = new String(s.trim());
    }

    public void SetSmoothing(String s) {
        if (!s.equals(this.Smoothing)) {
            this.ChangedFlag = true;
        }
        this.Smoothing = new String(s.trim());
    }

    public void SetMaxPath(String s) {
        if (!s.equals(this.MaxPath)) {
            this.ChangedFlag = true;
        }
        this.MaxPath = new String(s.trim());
    }

    public void SetFilesLoc(String s) {
        if (!s.equals(this.FilesLoc)) {
            this.ChangedFlag = true;
        }
        this.FilesLoc = s.trim();
    }

    public void SetFile(int index, String s) {
        if (!s.equals(this.Files[index])) {
            this.ChangedFlag = true;
        }
        this.Files[index] = s.trim();
    }

    public void SetJavaExec(String s) {
        if (!s.equals(this.JavaExec)) {
            this.ChangedFlag = true;
        }
        this.JavaExec = s.trim();
    }

    static boolean notEmpty(String s) {
        return s != null && s.length() != 0;
    }

    /*
     * Unable to fully structure code
     */
    public boolean Execute(WorkingDlg reportdlg) throws IOException, Exception {
        try {
            new FileWriter(this.OutputFilename("grammar.txt"));
            new FileWriter(this.OutputFilename("sampleSalad.txt"));
            new FileWriter(this.OutputFilename("blickTestResults.txt"));
            new FileWriter(this.OutputFilename("NatClassesFile.txt"));
            new FileWriter(this.OutputFilename("LearnerSettings.txt"));
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.Parent, "There's a problem in writing the following file--most likely it's already open.\n" + e.getMessage().replace('\t', ' ') + "\nPlease close this file then click OK.", "Cannot Write Output File", 0);
            return false;
        }
        cmdline = " -sample -gui -sampleType graphical -weighting ConjugateGradient";
        try {
            block29: {
                tempdir = new File(this.TempDir());
                if (!tempdir.mkdir()) {
                    // empty if block
                }
                if (!(outputdir = new File(this.OutputDir())).mkdir()) {
                    // empty if block
                }
                try {
                    this.CheckFeatFile(this.Files[0]);
                }
                catch (WarningException e) {
                    if (1 != JOptionPane.showConfirmDialog(this.Parent, e.getMessage() + " Continue anyway?", "Caution", 0, 3)) break block29;
                    return false;
                }
            }
            this.CreateTempFeatFiles();
            this.CreateNatClassesFile(this.TempFilename("NatClassesFile.txt"));
            switch (this.Task) {
                case 1: {
                    this.CheckMaxConstraints(this.MaxConstraints);
                    this.CheckSigma2(this.Sigma2);
                    this.CheckLearningSampleSize(this.LearningSampleSize);
                    this.CheckMaxGramSize(this.MaxGramSize);
                    this.CheckMaxOE(this.MaxOE);
                    this.CheckSmoothing(this.Smoothing);
                    this.CheckMaxPath(this.MaxPath);
                    this.CheckNGramLimitsFile(this.Files[3]);
                    this.CheckTiersFile(this.Files[6]);
                    this.CheckConstraintsFile(this.Files[5]);
                    this.CheckAccuracySchedule(this.Files[4]);
                    this.CheckTestFile(this.Files[1]);
                    try {
                        this.CheckTrainingFile(this.Files[2]);
                    }
                    catch (WarningException e) {
                        if (1 != JOptionPane.showConfirmDialog(this.Parent, e.getMessage(), "Caution", 0, 3)) ** GOTO lbl53
                        return false;
                    }
lbl53:
                    // 2 sources

                    cmdline = cmdline + " -select ";
                    if (!PLData.notEmpty(this.Files[5])) {
                        throw new Exception("Please specify a grammar to perform this task.");
                    }
                    if (this.ConstraintsAndWeights) {
                        cmdline = cmdline + " -constraintsAndWeights " + this.FullFilename(this.Files[5]);
                        break;
                    }
                    cmdline = cmdline + " -constraints " + this.FullFilename(this.Files[5]);
                    break;
                }
                case 2: {
                    this.CheckSigma2(this.Sigma2);
                    this.CheckLearningSampleSize(this.LearningSampleSize);
                    this.CheckSmoothing(this.Smoothing);
                    this.CheckMaxPath(this.MaxPath);
                    this.CheckTiersFile(this.Files[6]);
                    this.CheckConstraintsFile(this.Files[5]);
                    this.CheckTestFile(this.Files[1]);
                    if (!PLData.notEmpty(this.Files[5])) break;
                    if (this.ConstraintsAndWeights) {
                        cmdline = cmdline + " -constraintsAndWeights " + this.FullFilename(this.Files[5]);
                        break;
                    }
                    cmdline = cmdline + " -constraints " + this.FullFilename(this.Files[5]);
                    break;
                }
                case 3: {
                    this.CheckSigma2(this.Sigma2);
                    this.CheckLearningSampleSize(this.LearningSampleSize);
                    this.CheckMaxGramSize(this.MaxGramSize);
                    this.CheckMaxOE(this.MaxOE);
                    this.CheckSmoothing(this.Smoothing);
                    this.CheckMaxPath(this.MaxPath);
                    this.CheckNGramLimitsFile(this.Files[3]);
                    this.CheckTiersFile(this.Files[6]);
                    this.CheckConstraintsFile(this.Files[5]);
                    this.CheckAccuracySchedule(this.Files[4]);
                    this.CheckTestFile(this.Files[1]);
                    try {
                        this.CheckTrainingFile(this.Files[2]);
                    }
                    catch (WarningException e) {
                        if (1 != JOptionPane.showConfirmDialog(this.Parent, e.getMessage(), "Caution", 0, 3)) ** GOTO lbl93
                        return false;
                    }
lbl93:
                    // 2 sources

                    cmdline = cmdline + " -train ";
                    if (!PLData.notEmpty(this.Files[5])) {
                        throw new Exception("Please specify a grammar to perform this task.");
                    }
                    if (this.ConstraintsAndWeights) {
                        cmdline = cmdline + " -constraintsAndWeights " + this.FullFilename(this.Files[5]);
                        break;
                    }
                    cmdline = cmdline + " -constraints " + this.FullFilename(this.Files[5]);
                    break;
                }
                default: {
                    this.CheckMaxConstraints(this.MaxConstraints);
                    this.CheckSigma2(this.Sigma2);
                    this.CheckLearningSampleSize(this.LearningSampleSize);
                    this.CheckMaxGramSize(this.MaxGramSize);
                    this.CheckMaxOE(this.MaxOE);
                    this.CheckSmoothing(this.Smoothing);
                    this.CheckMaxPath(this.MaxPath);
                    this.CheckNGramLimitsFile(this.Files[3]);
                    this.CheckTiersFile(this.Files[6]);
                    this.CheckAccuracySchedule(this.Files[4]);
                    this.CheckTestFile(this.Files[1]);
                    try {
                        this.CheckTrainingFile(this.Files[2]);
                    }
                    catch (WarningException e) {
                        if (1 != JOptionPane.showConfirmDialog(this.Parent, e.getMessage(), "Caution", 0, 3)) ** GOTO lbl119
                        return false;
                    }
lbl119:
                    // 2 sources

                    cmdline = cmdline + " -select";
                }
            }
            cmdline = cmdline + " -outputdir " + this.OutputDir() + File.separator;
            if (this.MaxConstraints.length() != 0) {
                cmdline = cmdline + " -maximumFieldSize " + this.MaxConstraints;
            }
            cmdline = cmdline + " -phonemes " + this.TempFilename("tempFeatureChart.tmp");
            cmdline = cmdline + " -tiers " + this.TempFilename("tempFeatureList.tmp");
            cmdline = cmdline + " -naturalClasses " + this.TempFilename("NatClassesFile.txt");
            cmdline = cmdline + " -corpus " + this.TempFilename("tempLearningFile.tmp");
            cmdline = PLData.notEmpty(this.Files[3]) != false ? cmdline + " -trigramNaturalClasses " + this.FullFilename(this.Files[3]) : cmdline + " -trigramNaturalClasses all ";
            if (this.AllowComplements) {
                cmdline = cmdline + " -complementClasses";
            }
            cmdline = this.Sigma2.length() != 0 ? cmdline + " -sigma2 " + this.Sigma2 : cmdline + " -sigma2 1";
            cmdline = this.MaxPath.length() != 0 ? cmdline + " -maximumPathLength " + this.MaxPath : cmdline + " -maximumPathLength 8 ";
            cmdline = cmdline + " -maximumGramSize " + this.TempFilename("tempTierGramSizeFile.tmp");
            if (PLData.notEmpty(this.Files[6])) {
                cmdline = cmdline + " -projections " + this.TempFilename("tempProjections.tmp");
            }
            if (PLData.notEmpty(this.Files[4])) {
                cmdline = cmdline + " -accuracySchedule " + this.FullFilename(this.Files[4]);
            }
            if (this.MaxOE.length() != 0) {
                cmdline = cmdline + " -oeThreshold " + this.MaxOE;
            }
            cmdline = PLData.notEmpty(this.Files[1]) ? cmdline + " -test " + this.TempFilename("tempTestingFile.tmp") : cmdline + " -test " + this.TempFilename("tempTestFile.tmp");
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.Parent, e.getMessage(), "Checking Input Files", 0);
            return false;
        }
        this.WriteSettingsToFile(this.OutputFilename("LearnerSettings.txt"));
        this.CreateNatClassesFile(this.OutputFilename("NatClassesFile.txt"));
        worker = new LearnerThread(cmdline, reportdlg, this.OutputFilename("ProgramTrace.txt"));
        worker.execute();
        return true;
    }

    void CreateTempFeatFiles() throws IOException {
        BufferedWriter tempfeats = new BufferedWriter(new FileWriter(this.TempFilename(TEMPFEATLISTFILENAME)));
        tempfeats.write("Tiers");
        tempfeats.newLine();
        for (int i = 0; i < this.Features.length; ++i) {
            tempfeats.write(this.Features[i]);
            tempfeats.newLine();
        }
        tempfeats.close();
        tempfeats = new BufferedWriter(new FileWriter(this.TempFilename(TEMPFEATCHARTFILENAME)));
        tempfeats.write("Segments");
        tempfeats.newLine();
        for (PhoneticSymbol ps : this.phonSymbols) {
            tempfeats.write(ps.Symbol);
            tempfeats.write("\t { ");
            for (int i = 0; i < this.Features.length; ++i) {
                tempfeats.write(ps.FeatureMatrix[i]);
                tempfeats.write(this.Features[i]);
                tempfeats.write(", ");
            }
            tempfeats.write(125);
            tempfeats.newLine();
        }
        tempfeats.close();
    }

    void CreateNatClassesFile(String filename) throws IOException, Exception {
        BufferedWriter classesfile = new BufferedWriter(new FileWriter(filename));
        NatClass pluswb = null;
        NatClass minuswb = null;
        for (NatClass nc : this.Classes.ClassesBySymbols) {
            char val = nc.IsWordBoundary();
            if (val == '-') {
                minuswb = nc;
                continue;
            }
            if (val != '+') continue;
            pluswb = nc;
        }
        if (pluswb == null) {
            throw new Exception("program error: +word_boundary natural class not found");
        }
        if (minuswb == null) {
            throw new Exception("program error: -word_boundary natural class not found");
        }
        classesfile.write("Novel of size " + pluswb.NumFeatures() + ": ");
        classesfile.write(pluswb.FeaturesToString(","));
        classesfile.write("\t");
        classesfile.write(pluswb.SymbolsToString(","));
        classesfile.newLine();
        classesfile.write("Novel of size " + minuswb.NumFeatures() + ": ");
        classesfile.write(minuswb.FeaturesToString(","));
        classesfile.write("\t");
        classesfile.write(minuswb.SymbolsToString(","));
        classesfile.newLine();
        for (NatClass nc : this.Classes.ClassesBySymbols) {
            if (nc == pluswb || nc == minuswb) continue;
            classesfile.write("Novel of size " + nc.NumFeatures() + ": ");
            classesfile.write(nc.FeaturesToString(","));
            classesfile.write("\t");
            classesfile.write(nc.SymbolsToString(","));
            classesfile.newLine();
        }
        classesfile.close();
    }

    public void CheckMaxConstraints(String s) throws Exception {
        if (s.equals("")) {
            return;
        }
        try {
            if (Integer.parseInt(s) <= 0) {
                throw new Exception();
            }
        }
        catch (Exception anyOldException) {
            throw new Exception("Please enter a positive integer (or nothing) in the window Maximum number of constraints.");
        }
    }

    public void CheckSigma2(String s) throws Exception {
        if (s.equals("")) {
            return;
        }
        try {
            if (Double.parseDouble(s) <= 0.0) {
                throw new Exception();
            }
        }
        catch (Exception anyOldException) {
            throw new Exception("Sigma2 value must be greater than zero.");
        }
    }

    public void CheckLearningSampleSize(String s) throws Exception {
        if (s.equals("")) {
            return;
        }
        try {
            if (s.trim().compareTo("") != 0 && Integer.parseInt(s) <= 0) {
                throw new Exception();
            }
        }
        catch (Exception anyOldException) {
            throw new Exception("Target size of learning samples must be a positive integer or blank.");
        }
    }

    public void CheckMaxGramSize(String s) throws Exception {
        this.userMaxGramSize = 3;
        if (s.equals("")) {
            return;
        }
        try {
            int i = Integer.parseInt(s);
            if (i < 1 || i > 4) {
                throw new Exception();
            }
            this.userMaxGramSize = i;
        }
        catch (Exception anyOldException) {
            throw new Exception("Maximum gram size must be 1, 2, 3, or 4.");
        }
    }

    public void CheckMaxOE(String s) throws Exception {
        if (s.equals("")) {
            return;
        }
        try {
            double d = Double.parseDouble(s);
            if (d < 0.0 || d > 1.0) {
                throw new Exception();
            }
        }
        catch (Exception anyOldException) {
            throw new Exception("Maximum OE must be between zero and one.");
        }
    }

    public void CheckSmoothing(String s) throws Exception {
        if (s.equals("")) {
            return;
        }
    }

    public void CheckMaxPath(String s) throws Exception {
        if (s.equals("")) {
            return;
        }
        try {
            int i = Integer.parseInt(s);
            if (i < 1) {
                throw new Exception();
            }
        }
        catch (Exception anyOldException) {
            throw new Exception("Maximum path length must be a positive integer.");
        }
    }

    public void CheckFeatFile(String s) throws Exception, WarningException {
        if (s.equals("")) {
            throw new Exception("Features file is required.");
        }
        String ss = this.FullFilename(s);
        File f = new File(ss);
        int LineCount = 0;
        if (!f.isFile()) {
            throw new Exception("Cannot find feature and segments file \"" + s + "\".");
        }
        BufferedReader r = new BufferedReader(new FileReader(ss));
        try {
            String line;
            this.phonSymbols = new LinkedList();
            do {
                if ((line = r.readLine()) == null) {
                    throw new Exception("Feature and segments file \"" + s + "\" is blank.");
                }
                line = line.trim();
                ++LineCount;
            } while (line.equals(""));
            StringTokenizer tokens = new StringTokenizer(line, "\t");
            this.Features = new String[tokens.countTokens()];
            int i = 0;
            while (tokens.hasMoreElements()) {
                String tok = tokens.nextToken().trim();
                if (tok.equals("")) {
                    throw new Exception("Feature and segments file \"" + s + "\" has a blank feature (or two consecutive tabs) on the first line.");
                }
                if (this.isFeature(tok)) {
                    throw new Exception("Feature and segments file \"" + s + "\" has duplicate feature " + tok + ".");
                }
                if (tok.charAt(0) == '0' || !tok.matches("[\\w]*")) {
                    throw new Exception("Feature and segments file \"" + s + "\" feature \"" + tok + "\" is invalid.\nFeatures must contain only numbers, letters, and underscores, and may not begin with zero.");
                }
                this.Features[i++] = tok;
            }
            while ((line = r.readLine()) != null) {
                ++LineCount;
                if (line.trim().equals("")) continue;
                tokens = new StringTokenizer(line, "\t", true);
                String sep = null;
                String tok = tokens.nextToken().trim();
                if (tok.charAt(0) >= '0' && tok.charAt(0) <= '9' || tok.matches(".*[':].*")) {
                    throw new Exception("Feature and segments file \"" + s + "\" segment \"" + tok + "\" (line " + LineCount + ") is invalid.\nSegments may not begin with a number or contain ' or : .");
                }
                if (this.isSegment(tok)) {
                    throw new Exception("Feature and segments file \"" + s + "\" segment " + tok + " exists twice.\nSecond instance is on line " + LineCount + ".");
                }
                PhoneticSymbol ps = new PhoneticSymbol(tok, this.Features.length);
                int featcount = 0;
                try {
                    while (featcount < this.Features.length) {
                        if (!tok.equals("\t")) {
                            sep = tokens.nextToken();
                        }
                        if (!tokens.hasMoreTokens() && featcount == this.Features.length - 1) {
                            ps.FeatureMatrix[featcount++] = 48;
                            break;
                        }
                        tok = tokens.nextToken();
                        if (tok.equals("\t")) {
                            ps.FeatureMatrix[featcount++] = 48;
                            continue;
                        }
                        if (!((tok = tok.trim()).equals("+") || tok.equals("-") || tok.equals("0"))) {
                            throw new Exception("Feature and segments file \"" + s + "\" segment \"" + ps.Symbol + "\" (line " + LineCount + ") has an invalid symbol \"" + tok + "\".\nThe line should only contain +, -, and 0, separated by tabs.");
                        }
                        ps.FeatureMatrix[featcount++] = tok.charAt(0);
                    }
                }
                catch (NoSuchElementException e) {
                    throw new Exception("Feature and segments file \"" + s + "\" segment \"" + ps.Symbol + "\" (line " + LineCount + ") has too few features.");
                }
                while (tokens.hasMoreTokens()) {
                    if (tokens.nextToken().equals("\t")) continue;
                    throw new Exception("Feature and segments file \"" + s + "\" segment \"" + ps.Symbol + "\" (line " + LineCount + ") has too many features.");
                }
                this.phonSymbols.add(ps);
            }
            boolean wordboundary = false;
            for (int j = 0; j < this.Features.length; ++j) {
                if (!this.Features[j].equals("word_boundary")) continue;
                wordboundary = true;
            }
            if (!wordboundary) {
                String[] newFeats = new String[this.Features.length + 1];
                System.arraycopy(this.Features, 0, newFeats, 0, this.Features.length);
                newFeats[0] = "word_boundary";
                newFeats[this.Features.length] = this.Features[0];
                this.Features = newFeats;
                PhoneticSymbol newps = new PhoneticSymbol("#", this.Features.length);
                for (int k = 1; k < newps.FeatureMatrix.length; ++k) {
                    newps.FeatureMatrix[k] = 48;
                }
                newps.FeatureMatrix[0] = 43;
                Object first = this.phonSymbols.remove();
                this.phonSymbols.addFirst(newps);
                this.phonSymbols.addLast(first);
                Iterator j = this.phonSymbols.iterator();
                j.next();
                PhoneticSymbol OldWB = null;
                while (j.hasNext()) {
                    PhoneticSymbol ps = (PhoneticSymbol)j.next();
                    if (ps.Symbol.equals("#")) {
                        OldWB = ps;
                        continue;
                    }
                    char[] newMat = new char[this.Features.length];
                    System.arraycopy(ps.FeatureMatrix, 1, newMat, 1, ps.FeatureMatrix.length - 1);
                    newMat[0] = 45;
                    newMat[ps.FeatureMatrix.length] = ps.FeatureMatrix[0];
                    ps.FeatureMatrix = newMat;
                }
                if (OldWB != null) {
                    this.phonSymbols.remove(OldWB);
                }
            }
            Iterator j = this.phonSymbols.iterator();
            PhoneticSymbol boundary = (PhoneticSymbol)j.next();
            if (!boundary.Symbol.equals("#")) {
                boundary = null;
                while (j.hasNext()) {
                    PhoneticSymbol ps = (PhoneticSymbol)j.next();
                    if (!ps.Symbol.equals("#")) continue;
                    this.phonSymbols.remove(ps);
                    boundary = ps;
                    break;
                }
                if (boundary == null) {
                    boundary = new PhoneticSymbol("#", this.Features.length);
                    for (int k = 0; k < this.Features.length; ++k) {
                        boundary.FeatureMatrix[k] = this.Features[k].equals("word_boundary") ? 43 : 48;
                    }
                }
                LinkedList<PhoneticSymbol> newSymbols = new LinkedList<PhoneticSymbol>();
                newSymbols.addAll(this.phonSymbols);
                Object first = newSymbols.remove();
                newSymbols.addFirst(boundary);
                newSymbols.addLast((PhoneticSymbol)first);
                this.phonSymbols = newSymbols;
            }
            this.CreateTempFeatFiles();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            r.close();
        }
        this.Classes = new NatClassContainer(this.Features, this.phonSymbols, this.Parent);
    }

    public void CheckTestFile(String s) throws Exception, WarningException {
        if (s.equals("")) {
            return;
        }
        String ss = this.FullFilename(s);
        File f = new File(ss);
        if (!f.isFile()) {
            throw new Exception("Cannot find Testing data file \"" + s + "\".");
        }
        BufferedReader r = new BufferedReader(new FileReader(ss));
        BufferedWriter w = new BufferedWriter(new FileWriter(this.TempFilename(TEMPTESTINGFILENAME)));
        int LineCount = 0;
        try {
            String line;
            while ((line = r.readLine()) != null) {
                line = line.trim();
                ++LineCount;
                if (line.equals("")) continue;
                StringTokenizer tabs = new StringTokenizer(line, "\t");
                StringTokenizer phones = new StringTokenizer(tabs.nextToken().trim(), " ");
                while (phones.hasMoreTokens()) {
                    String segment = phones.nextToken();
                    if (!this.isSegment(segment)) {
                        throw new Exception("Error in Testing data file \"" + s + "\" line " + LineCount + ":\nsegment \"" + segment + "\" is not found in the feature file.\nWord: \"" + line + "\".");
                    }
                    w.write(segment);
                    w.write(" ");
                }
                while (tabs.hasMoreTokens()) {
                    w.write("\t");
                    w.write(tabs.nextToken());
                }
                w.newLine();
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            r.close();
            w.close();
        }
    }

    public void CheckTrainingFile(String s) throws Exception {
        String ss = this.FullFilename(s);
        File f = new File(ss);
        if (s.equals("")) {
            throw new Exception("Learning data file is required.");
        }
        if (!f.isFile()) {
            throw new Exception("Cannot find Learning data file \"" + s + "\".");
        }
        BufferedReader r = new BufferedReader(new FileReader(ss));
        BufferedWriter w = new BufferedWriter(new FileWriter(this.TempFilename(TEMPTRAININGFILENAME)));
        BufferedWriter copy = new BufferedWriter(new FileWriter(this.TempFilename(TEMPCOPIEDTRAININGFILENAME)));
        int LineCount = 0;
        int TokenCount = 0;
        try {
            String line;
            while ((line = r.readLine()) != null) {
                String strfreq;
                line = line.trim();
                ++LineCount;
                if (line.equals("")) continue;
                StringTokenizer tabs = new StringTokenizer(line, "\t");
                String word = tabs.nextToken().trim();
                StringTokenizer phones = new StringTokenizer(word, " ");
                while (phones.hasMoreTokens()) {
                    String segment = phones.nextToken();
                    if (!this.isSegment(segment)) {
                        throw new Exception("Error in Learning data file \"" + s + "\" line " + LineCount + ":\nsegment \"" + segment + "\" is not found in the feature chart.\nWord: \"" + line.replace('\t', ' ') + "\".");
                    }
                    w.write(segment);
                    w.write(32);
                }
                int freq = 1;
                if (tabs.hasMoreTokens() && (strfreq = tabs.nextToken().trim()).length() != 0) {
                    try {
                        freq = Integer.parseInt(strfreq);
                        if (freq <= 0) {
                            throw new Exception();
                        }
                    }
                    catch (Exception anyOldException) {
                        throw new Exception("Learning data file \"" + s + "\" line " + LineCount + ": frequency count \"" + strfreq + "\" is not a positive integer.\nWord: \"" + line + "\".");
                    }
                }
                TokenCount += freq;
                w.write("\t" + freq);
                w.newLine();
                copy.write(word);
                copy.write("\ttesting datum");
                copy.newLine();
            }
            if (TokenCount < 100) {
                throw new WarningException("Caution: the Learning file has only " + TokenCount + " data.  Using this few data can have very unpredictable consequences.\nWe recommend that you multiply each frequency value to get a larger total, ideally around 3000; see manual.\nContinue anyway?");
            }
            if (TokenCount < 3000) {
                throw new WarningException("Caution: the Learning file has fewer than 3000 tokens; see manual.  Continue anyway?");
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            r.close();
            w.close();
            copy.close();
        }
    }

    public void CheckNGramLimitsFile(String s) throws Exception {
        if (s.equals("")) {
            return;
        }
        String ss = this.FullFilename(s);
        File f = new File(ss);
        if (!f.isFile()) {
            throw new Exception("Cannot find n-gram constraints file \"" + s + "\".");
        }
        BufferedReader r = new BufferedReader(new FileReader(ss));
        int LineCount = 0;
        try {
            String line;
            while ((line = r.readLine()) != null) {
                line = line.trim();
                ++LineCount;
                if (line.equals("")) continue;
                StringTokenizer tok = new StringTokenizer(line, ",", true);
                while (tok.hasMoreTokens()) {
                    String t = tok.nextToken().trim();
                    if (t.charAt(0) != '+' && t.charAt(0) != '-' && t.charAt(0) != '0') {
                        throw new Exception("Error in n-gram constraints file \"" + s + "\" line " + LineCount + ":\nnot a comma-delimited list of +, -, or 0 followed by a feature.");
                    }
                    String feat = t.substring(1);
                    if (this.isFeature(feat)) continue;
                    throw new Exception("Error in n-gram constraints file \"" + s + "\" line " + LineCount + ":\n\"" + feat + "\" is not found in the feature file.");
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            r.close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void CheckAccuracySchedule(String s) throws Exception {
        if (s.equals("")) {
            return;
        }
        String ss = this.FullFilename(s);
        File f = new File(ss);
        if (!f.isFile()) {
            throw new Exception("Cannot find accuracy schedule file \"" + s + "\".");
        }
        BufferedReader r = new BufferedReader(new FileReader(ss));
        int LineCount = 0;
        try {
            String line;
            while ((line = r.readLine()) != null) {
                line = line.trim();
                ++LineCount;
                if (line.equals("")) continue;
                try {
                    double d = Double.parseDouble(line);
                    if (!(d < 0.0) && !(d > 1.0)) continue;
                    throw new Exception();
                }
                catch (Exception anyOldException) {
                    throw new Exception("Accuracy schedule file \"" + s + "\" line " + LineCount + ": \"" + line + "\" is not a number between zero and one.");
                    return;
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            r.close();
        }
    }

    public void CheckConstraintsFile(String s) throws Exception {
        String ss = this.FullFilename(s);
        File f = new File(ss);
        if (s.equals("")) {
            return;
        }
        if (!f.isFile()) {
            throw new Exception("Cannot find constraints file \"" + s + "\".");
        }
        BufferedReader r = new BufferedReader(new FileReader(ss));
        BufferedWriter output = new BufferedWriter(new FileWriter(this.TempFilename(TEMPCONSTRAINTSFILENAME)));
        int LineCount = 0;
        this.ConstraintsAndWeights = false;
        try {
            String line;
            while ((line = r.readLine()) != null) {
                line = line.trim();
                ++LineCount;
                if (line.equals("")) continue;
                StringTokenizer tabs = new StringTokenizer(line, "*\t");
                String matstr = tabs.nextToken().trim();
                StringTokenizer matrices = new StringTokenizer(matstr, "[]", true);
                output.write(42);
                while (matrices.hasMoreTokens()) {
                    String tok = matrices.nextToken().trim();
                    if (tok.equals("")) continue;
                    if (!tok.equals("[")) {
                        throw new Exception("User constraints file \"" + s + "\" (line " + LineCount + "): error in parsing brackets:\n\"" + matstr + "\".");
                    }
                    output.write(91);
                    int commacount = 0;
                    StringTokenizer matrix = new StringTokenizer(matrices.nextToken().trim(), ",");
                    while (matrix.hasMoreTokens()) {
                        String feat = matrix.nextToken().trim();
                        if (feat.equals("[") || feat.equals("]")) {
                            throw new Exception("User constraints file \"" + s + "\" (line " + LineCount + "): error in parsing brackets:\n\"" + matstr + "\".");
                        }
                        String writestr = feat;
                        if (feat.charAt(0) == '^') {
                            feat = feat.substring(1);
                        }
                        if (!this.isStrictlyValuedFeature(feat)) {
                            throw new Exception("User constraints file \"" + s + "\" (line " + LineCount + "): \"" + feat + "\" is malformed or not in the features file.");
                        }
                        if (commacount > 0) {
                            output.write(44);
                        }
                        ++commacount;
                        output.write(writestr);
                    }
                    while (matrices.hasMoreTokens() && (tok = matrices.nextToken().trim()).equals("")) {
                    }
                    if (!tok.equals("]")) {
                        throw new Exception("User constraints file \"" + s + "\" (line " + LineCount + "): error in parsing brackets:\n\"" + matstr + "\".");
                    }
                    output.write(93);
                }
                output.write(9);
                if (!tabs.hasMoreTokens()) {
                    output.write("(tier=default)");
                    output.newLine();
                    continue;
                }
                String proj = tabs.nextToken().trim();
                if (!proj.matches("\\( *tier *= *[\\w]* *\\)")) {
                    throw new Exception("User constraints file \"" + s + "\" (line " + LineCount + "): tier \"" + proj + "\" is malformed.  It should follow \"(tier=feature)\".");
                }
                String tier = proj.substring(proj.indexOf(61) + 1, proj.indexOf(41)).trim();
                if (!tier.equalsIgnoreCase("default") && !this.isTier(tier)) {
                    throw new Exception("User constraints file \"" + s + "\" (line " + LineCount + "): tier \"" + tier + "\" is not found in the projections file.");
                }
                output.write(proj);
                if (!tabs.hasMoreTokens()) {
                    output.newLine();
                    continue;
                }
                this.ConstraintsAndWeights = true;
                String d = tabs.nextToken().trim();
                output.write(9);
                output.write(d);
                try {
                    if (Double.parseDouble(d) < 0.0) {
                        throw new Exception();
                    }
                }
                catch (Exception any) {
                    throw new Exception("User constraints file \"" + s + "\" (line " + LineCount + "): \"" + d + "\" should be non-negative.");
                }
                output.newLine();
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            r.close();
            output.close();
        }
    }

    public void CheckTiersFile(String s) throws Exception {
        if (s.equals("")) {
            BufferedWriter gramsizefile = new BufferedWriter(new FileWriter(this.TempFilename(TEMPTIERGRAMSIZEFILENAME)));
            gramsizefile.write(Integer.toString(this.userMaxGramSize));
            gramsizefile.newLine();
            gramsizefile.close();
            return;
        }
        String ss = this.FullFilename(s);
        File f = new File(ss);
        if (!f.isFile()) {
            throw new Exception("Cannot find projected tiers file \"" + s + "\".");
        }
        BufferedReader r = new BufferedReader(new FileReader(ss));
        BufferedWriter tierfile = new BufferedWriter(new FileWriter(this.TempFilename(TEMPPROJECTIONSFILENAME)));
        BufferedWriter gramsizefile = new BufferedWriter(new FileWriter(this.TempFilename(TEMPTIERGRAMSIZEFILENAME)));
        int grams = this.userMaxGramSize;
        int LineCount = 0;
        this.Tiers = new LinkedHashSet();
        try {
            String line;
            while ((line = r.readLine()) != null) {
                ++LineCount;
                if ((line = line.trim()).equals("")) continue;
                StringTokenizer colons = new StringTokenizer(line, " ");
                String tier = colons.nextToken().trim();
                if (this.isTier(tier)) {
                    throw new Exception("Projected tiers file \"" + s + "\" (line " + LineCount + "): tier \"" + tier + "\" is a duplicate.");
                }
                this.Tiers.add(tier);
                tierfile.write(tier + ' ');
                StringTokenizer feats = new StringTokenizer(colons.nextToken(":").trim(), ", ");
                boolean writtencomma = false;
                while (feats.hasMoreTokens()) {
                    String feat = feats.nextToken().trim();
                    if (!this.isValuedFeature(feat)) {
                        throw new Exception("Projected tiers file \"" + s + "\" tier \"" + tier + "\" (line " + LineCount + "): feature \"" + feat + "\" is malformed or not in the features file.");
                    }
                    if (writtencomma) {
                        tierfile.write(", ");
                    }
                    writtencomma = true;
                    tierfile.write(feat);
                }
                tierfile.write(" : ");
                StringTokenizer projs = new StringTokenizer(colons.nextToken().trim(), ", \t");
                boolean seenWordBound = false;
                writtencomma = false;
                grams = this.userMaxGramSize;
                while (projs.hasMoreTokens()) {
                    String feat = projs.nextToken().trim();
                    if (feat.equals("word_boundary")) {
                        seenWordBound = true;
                    }
                    if (!projs.hasMoreTokens() && feat.matches("[Gg]rams?")) {
                        try {
                            grams = Integer.parseInt(colons.nextToken().trim());
                            if (grams >= 1 && grams <= 4) continue;
                            throw new Exception();
                        }
                        catch (Exception anyOldException) {
                            throw new Exception("Projected tiers file \"" + s + "\" tier \"" + tier + "\" (line " + LineCount + "): Grams should be in the format, \"Grams: #\", where # is 1, 2, 3, or 4.");
                        }
                    }
                    if (!this.isFeature(feat)) {
                        throw new Exception("Projected tiers file \"" + s + "\" tier \"" + tier + "\" (line " + LineCount + "): \"" + feat + "\" is malformed or not in the features file.");
                    }
                    if (writtencomma) {
                        tierfile.write(", ");
                    }
                    writtencomma = true;
                    tierfile.write(feat);
                }
                if (!seenWordBound) {
                    throw new Exception("Projected tiers file \"" + s + "\" tier \"" + tier + "\" (line " + LineCount + "): \"word_boundary\" must be included in a projection.");
                }
                tierfile.newLine();
                gramsizefile.write(Integer.toString(grams));
                gramsizefile.newLine();
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            r.close();
            gramsizefile.write(Integer.toString(this.userMaxGramSize));
            tierfile.close();
            gramsizefile.close();
        }
    }
}

